/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.rename;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.dialogs.BaseDialog;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;

public abstract class RenameDialog
extends BaseDialog {
    private static final int PREF_COMMENTS = 1;
    private static final int PREF_NON_JAVA_FILES = 2;
    private static final int PREF_PREVIEW = 4;
    protected JTextField _textField;
    private JCheckBox _searchInComments;
    private JCheckBox _searchNonJavaFiles;
    private JCheckBox _preview;

    public RenameDialog(Context context, String string) {
        super(string, context);
        this.init();
    }

    public String getNewName() {
        return this._textField.getText();
    }

    public boolean isSearchInComments() {
        return this._searchInComments.isSelected();
    }

    public boolean isSearchInNonJavaFiles() {
        return this._searchNonJavaFiles != null && this._searchNonJavaFiles.isSelected();
    }

    public boolean hasPreview() {
        return this._preview.isSelected();
    }

    protected void updateSettings(CopyableInteger copyableInteger) {
        copyableInteger.setBit(1, this.isSearchInComments());
        copyableInteger.setBit(2, this.isSearchInNonJavaFiles());
        copyableInteger.setBit(4, this.hasPreview());
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._textField;
    }

    protected int getDefaultPreferences() {
        return 2;
    }

    private void init() {
        JLabel jLabel = new JLabel();
        this._textField = new JTextField(30);
        this.updateOnChanges(this._textField);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._textField, (String)RefactoringArb.getString(47));
        String string = RefactoringArb.getString(45);
        String string2 = RefactoringArb.getString(46);
        String string3 = RefactoringArb.getString(48);
        this._searchInComments = new JCheckBox(StringUtils.stripMnemonic((String)string));
        Util.setMnemonic(this._searchInComments, string);
        if (this.useSearchNonJavaFiles()) {
            this._searchNonJavaFiles = new JCheckBox(StringUtils.stripMnemonic((String)string2));
            Util.setMnemonic(this._searchNonJavaFiles, string2);
        }
        this._preview = new JCheckBox(StringUtils.stripMnemonic((String)string3));
        Util.setMnemonic(this._preview, string3);
        JLabel jLabel2 = new JLabel();
        jLabel2.setPreferredSize(this._preview.getPreferredSize());
        this.setMessageLabel(jLabel2);
        CopyableInteger copyableInteger = this.getSettings();
        this._searchInComments.setSelected(copyableInteger.isBitSet(1));
        if (this._searchNonJavaFiles != null) {
            this._searchNonJavaFiles.setSelected(copyableInteger.isBitSet(2));
        }
        this._preview.setSelected(copyableInteger.isBitSet(4));
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._textField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this._searchInComments, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 0, insets, 2, 0));
        if (this._searchNonJavaFiles != null) {
            this.add((Component)this._searchNonJavaFiles, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 18, 0, insets, 2, 0));
        }
        this.add((Component)this._preview, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 18, 0, insets, 2, 0));
        this.add((Component)jLabel2, new GridBagConstraints(0, 9, 2, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
    }

    protected void setOldName(String string) {
        this._textField.setText(string);
        this._textField.setCaretPosition(0);
        this._textField.setSelectionEnd(string.length());
    }

    protected boolean useSearchNonJavaFiles() {
        return true;
    }
}

