/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.rename;

import java.net.URL;
import java.text.MessageFormat;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.IdeUtil;
import oracle.jdeveloper.controls.classpick.ClassPickerFactory;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.rename.RenameDialog;

public class RenamePackageDialog
extends RenameDialog {
    public static final String PREFERENCE_KEY = "RENAME_PACKAGE_DEFAULTS";
    private String _oldPkgName;

    public RenamePackageDialog(Context context, String string) {
        super(context, PREFERENCE_KEY);
        this._oldPkgName = string;
        this.setOldName(string);
        ClassPickerFactory.attach(this._textField, context, 2);
    }

    protected String getTitle() {
        return MessageFormat.format(RefactoringArb.getString(49), this._oldPkgName);
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String string = "";
            boolean bl = true;
            String string2 = this.getNewName();
            if (string2.length() == 0) {
                bl = false;
            } else if (this._oldPkgName.equals(string2)) {
                bl = false;
            } else if (string2.endsWith(".")) {
                bl = false;
            } else if (!IdeUtil.isPackageIdentifier((String)string2)) {
                string = RefactoringArb.getString(74);
                bl = false;
            } else if (IdeUtil.isJavaReservedWord((String)string2)) {
                string = RefactoringArb.getString(74);
                bl = false;
            } else if (this.isPackageAlreadyPresent(string2)) {
                string = MessageFormat.format(RefactoringArb.getString(75), string2);
            } else if (RenamePackageDialog.hasUpperCase(string2)) {
                string = RefactoringArb.getString(76);
            }
            this.setMessage(string, bl);
            this.setOKButtonEnabled(bl);
        }
    }

    protected String getHelpTopicID() {
        return "f1_jrf_drename_html";
    }

    private boolean isPackageAlreadyPresent(String string) {
        Context context = this.getContext();
        return RenamePackageDialog.isPackageAlreadyPresent(context, string);
    }

    public static boolean isPackageAlreadyPresent(Context context, String string) {
        Project project = context.getProject();
        URLPath uRLPath = PathsConfiguration.getInstance(project).getSourcePath();
        for (URL uRL : uRLPath) {
            URL uRL2 = URLFactory.newURL((URL)uRL, (String)string);
            if (!URLFileSystem.exists((URL)uRL2)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasUpperCase(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isUpperCase(c)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

