/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.rename;

import java.text.MessageFormat;
import oracle.ide.Context;
import oracle.ide.util.IdeUtil;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.rename.RenameDialog;
import oracle.jdevimpl.refactoring.util.JotNaming;

public class RenameVariableDialog
extends RenameDialog {
    public static final String PREFERENCE_KEY = "RENAME_VARIABLE_DEFAULTS";
    private SourceVariable _sourceVariable;

    public RenameVariableDialog(Context context, SourceVariable sourceVariable) {
        super(context, PREFERENCE_KEY);
        this._sourceVariable = sourceVariable;
        String string = this.getNameBefore();
        this.setOldName(string);
    }

    private String getNameBefore() {
        return this._sourceVariable.getName();
    }

    protected String getTitle() {
        return MessageFormat.format(RefactoringArb.getString(49), this.getNameBefore());
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String string = "";
            boolean bl = true;
            String string2 = this.getNewName();
            if (string2.length() == 0) {
                bl = false;
            } else if (this.getNameBefore().equals(string2)) {
                bl = false;
            } else if (!IdeUtil.isJavaIdentifier((String)string2)) {
                string = RefactoringArb.getString(77);
                bl = false;
            } else if (IdeUtil.isJavaReservedWord((String)string2)) {
                string = RefactoringArb.getString(77);
                bl = false;
            } else if (!JotNaming.canIntroduceVariable((SourceElement)this._sourceVariable, string2)) {
                string = MessageFormat.format(RefactoringArb.getString(78), string2);
                bl = false;
            } else if (Character.isUpperCase(string2.charAt(0))) {
                string = RefactoringArb.getString(79);
            }
            this.setMessage(string, bl);
            this.setOKButtonEnabled(bl);
        }
    }

    protected String getHelpTopicID() {
        return "f1_jrf_drenamevar_html";
    }

    protected boolean useSearchNonJavaFiles() {
        return false;
    }
}

