/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.rename.member;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.util.BitField;
import oracle.ide.util.IdeUtil;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.rename.RenameDialog;
import oracle.jdevimpl.refactoring.util.NameValidation;

public class RenameFieldDialog
extends RenameDialog {
    public static final String PREFERENCE_KEY = "RENAME_FIELD_DEFAULTS";
    private SourceMemberVariable _sourceMemberVariable;

    public RenameFieldDialog(Context context, SourceMemberVariable sourceMemberVariable) {
        super(context, PREFERENCE_KEY);
        this._sourceMemberVariable = sourceMemberVariable;
        String string = this._sourceMemberVariable.getName();
        this.setOldName(string);
    }

    protected String getTitle() {
        String string = this._sourceMemberVariable.getName();
        String string2 = MessageFormat.format(RefactoringArb.getString(49), string);
        return string2;
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String string = "";
            boolean bl = true;
            String string2 = this.getNewName();
            if (string2.length() == 0) {
                bl = false;
            } else if (this._sourceMemberVariable.getName().equals(string2)) {
                bl = false;
            } else if (!IdeUtil.isJavaIdentifier((String)string2)) {
                string = RefactoringArb.getString(69);
                bl = false;
            } else if (IdeUtil.isJavaReservedWord((String)string2)) {
                string = RefactoringArb.getString(69);
                bl = false;
            } else if (RenameFieldDialog.isFieldAlreadyPresent((JavaType)this._sourceMemberVariable.getEnclosingClass(), string2)) {
                string = MessageFormat.format(RefactoringArb.getString(36), string2);
                bl = false;
            } else {
                boolean bl2;
                boolean bl3 = bl2 = this._sourceMemberVariable.isStatic() && this._sourceMemberVariable.isFinal();
                if (bl2) {
                    if (!NameValidation.isGoodConstantName(string2)) {
                        string = RefactoringArb.getString(64);
                    }
                } else {
                    boolean bl4 = Character.isUpperCase(string2.charAt(0));
                    if (bl4) {
                        string = RefactoringArb.getString(70);
                    }
                }
            }
            this.setMessage(string, bl);
            this.setOKButtonEnabled(bl);
        }
    }

    protected String getHelpTopicID() {
        return "f1_jrf_drename_html";
    }

    private static boolean isFieldAlreadyPresent(JavaType javaType, String string) {
        if (RenameFieldDialog.isFieldAlreadyPresent(javaType, javaType, string)) {
            return true;
        }
        Set set = javaType.getHierarchy();
        for (JavaType javaType2 : set) {
            if (!RenameFieldDialog.isFieldAlreadyPresent(javaType, javaType2, string)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFieldAlreadyPresent(JavaType javaType, JavaType javaType2, String string) {
        Collection collection = javaType2.getDeclaredFields();
        for (JavaField javaField : collection) {
            String string2;
            String string3;
            if (!javaField.getName().equals(string)) continue;
            int n = javaField.getModifiers();
            if (BitField.isSet((int)n, (int)1) || BitField.isSet((int)n, (int)4)) {
                return true;
            }
            return BitField.isSet((int)n, (int)2) ? javaType == javaType2 : (string3 = javaType.getPackageName()).equals(string2 = javaType2.getPackageName());
        }
        return false;
    }
}

