/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.rename.member;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.MultiMap;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTextFragment;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.java.util.SourceElementHandle;
import oracle.jdeveloper.refactoring.criteria.RenameFieldCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchFieldCriteria;
import oracle.jdeveloper.refactoring.model.FieldDescription;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.URLRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.SourceElementEntry;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.handlers.JavaURLHelper;
import oracle.jdevimpl.refactoring.oprs.rename.member.RenameMethodURLHandler;
import oracle.jdevimpl.refactoring.search.Scope;

public class RenameFieldURLHandler
extends URLRefactoringHandler {
    public static final int USAGE_DEF = 201;
    public static final int USAGE_ACCESS = 202;
    public static final int USAGE_DOC_REF = 4;
    public static final int USAGE_COMMENT = 2000;

    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] projectArray = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        switch (n) {
            case -2147483545: {
                RenameFieldCriteria renameFieldCriteria = (RenameFieldCriteria)searchCriteria;
                FieldDescription fieldDescription = renameFieldCriteria.getFieldDescription();
                MethodDescription methodDescription = renameFieldCriteria.getGetterDescription();
                MethodDescription methodDescription2 = renameFieldCriteria.getSetterDescription();
                ArrayList<Project> arrayList = new ArrayList<Project>();
                Project[] projectArray2 = RenameFieldURLHandler.getIncludedProjects(searchOperation, fieldDescription, Scope.createDummyScope());
                arrayList.addAll(Arrays.asList(projectArray2));
                if (methodDescription != null) {
                    Project[] projectArray3 = RenameMethodURLHandler.getIncludedProjects(searchOperation, methodDescription, Scope.createDummyScope());
                    arrayList.addAll(Arrays.asList(projectArray3));
                }
                if (methodDescription2 != null) {
                    Project[] projectArray4 = RenameMethodURLHandler.getIncludedProjects(searchOperation, methodDescription2, Scope.createDummyScope());
                    arrayList.addAll(Arrays.asList(projectArray4));
                }
                projectArray = arrayList.toArray(new Project[arrayList.size()]);
                break;
            }
            case 3: {
                SearchFieldCriteria searchFieldCriteria = (SearchFieldCriteria)searchCriteria;
                FieldDescription fieldDescription = searchFieldCriteria.getFieldDescription();
                Scope scope = searchFieldCriteria.getScope();
                projectArray = RenameFieldURLHandler.getIncludedProjects(searchOperation, fieldDescription, scope);
            }
        }
        return projectArray;
    }

    private static Project[] getIncludedProjects(SearchOperation searchOperation, FieldDescription fieldDescription, Scope scope) {
        Project[] projectArray;
        Context context = searchOperation.getContext();
        Project project = context.getProject();
        JavaManager javaManager = JavaManager.getJavaManager(project);
        JavaField javaField = fieldDescription.getJavaField(javaManager);
        if (javaField.isPrivate()) {
            projectArray = new Project[]{project};
        } else {
            JavaClass javaClass = javaField.getOwningClass();
            String string = javaClass.getQualifiedName();
            projectArray = RenameFieldURLHandler.getIncludedProjects(searchOperation, new String[]{string}, scope);
        }
        return projectArray;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet hashSet = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        switch (n) {
            case -2147483545: {
                HashSet hashSet2;
                HashSet hashSet3;
                RenameFieldCriteria renameFieldCriteria = (RenameFieldCriteria)searchCriteria;
                MethodDescription methodDescription = renameFieldCriteria.getGetterDescription();
                MethodDescription methodDescription2 = renameFieldCriteria.getSetterDescription();
                String string = renameFieldCriteria.getFqClassName();
                String string2 = renameFieldCriteria.getMemberNameBefore();
                Scope scope = Scope.createDummyScope();
                hashSet = RenameFieldURLHandler.chooseURLs(searchOperation, project, progressIndicator, string, string2, false, scope);
                if (methodDescription != null && (hashSet3 = RenameMethodURLHandler.chooseUrls(searchOperation, project, progressIndicator, methodDescription, false, scope)) != null) {
                    hashSet.addAll(hashSet3);
                }
                if (methodDescription2 == null || (hashSet2 = RenameMethodURLHandler.chooseUrls(searchOperation, project, progressIndicator, methodDescription2, false, scope)) == null) break;
                hashSet.addAll(hashSet2);
                break;
            }
            case 3: {
                SearchFieldCriteria searchFieldCriteria = (SearchFieldCriteria)searchCriteria;
                String string = searchFieldCriteria.getFqClassName();
                String string3 = searchFieldCriteria.getFieldName();
                Scope scope = searchFieldCriteria.getScope();
                hashSet = RenameFieldURLHandler.chooseURLs(searchOperation, project, progressIndicator, string, string3, searchFieldCriteria.isSearchInLibraries(), scope);
            }
        }
        return hashSet;
    }

    private static HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator, String string, String string2, boolean bl, Scope scope) {
        JavaField javaField;
        HashSet hashSet = null;
        JavaManager javaManager = JavaManager.getJavaManager(project);
        SourceClass sourceClass = javaManager.getSourceClass(string);
        if (sourceClass != null && (javaField = sourceClass.getField(string2)) != null) {
            hashSet = JavaURLHelper.getJavaURLsContaining(searchOperation, project, new String[]{string2}, bl, false, scope, progressIndicator);
        }
        return hashSet;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] uRLArray, ProgressIndicator progressIndicator) {
        UsageModel usageModel = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        switch (n) {
            case -2147483545: {
                RenameFieldCriteria renameFieldCriteria = (RenameFieldCriteria)searchOperation.getCriteria();
                FieldDescription fieldDescription = renameFieldCriteria.getFieldDescription();
                MethodDescription methodDescription = renameFieldCriteria.getGetterDescription();
                MethodDescription methodDescription2 = renameFieldCriteria.getSetterDescription();
                usageModel = new UsageModel();
                UsageModel[] usageModelArray = new UsageModel[3];
                UsageModel usageModel2 = RenameFieldURLHandler.findUsages(project, uRLArray, progressIndicator, fieldDescription, true);
                usageModel.addAll(usageModel2);
                usageModelArray[0] = usageModel2;
                if (methodDescription != null) {
                    UsageModel usageModel3 = RenameMethodURLHandler.findUsages(project, uRLArray, progressIndicator, methodDescription, true, true, renameFieldCriteria.isSearchInComments(), false);
                    usageModel.addAll(usageModel3);
                    usageModelArray[1] = usageModel3;
                }
                if (methodDescription2 != null) {
                    UsageModel usageModel4 = RenameMethodURLHandler.findUsages(project, uRLArray, progressIndicator, methodDescription2, true, true, renameFieldCriteria.isSearchInComments(), false);
                    usageModel.addAll(usageModel4);
                    usageModelArray[2] = usageModel4;
                }
                searchOperation.setProperty(project.getLongLabel(), usageModelArray);
                break;
            }
            case 3: {
                SearchFieldCriteria searchFieldCriteria = (SearchFieldCriteria)searchOperation.getCriteria();
                FieldDescription fieldDescription = searchFieldCriteria.getFieldDescription();
                usageModel = RenameFieldURLHandler.findUsages(project, uRLArray, progressIndicator, fieldDescription, searchFieldCriteria.isSearchInComments());
            }
        }
        return usageModel;
    }

    public static UsageModel findUsages(Project project, URL[] uRLArray, ProgressIndicator progressIndicator, FieldDescription fieldDescription, boolean bl) {
        UsageModel usageModel = new UsageModel();
        JavaManager javaManager = JavaManager.getJavaManager(project);
        JavaField javaField = fieldDescription.getJavaField(javaManager);
        SourceMemberVariable sourceMemberVariable = (SourceMemberVariable)javaField.getSourceElement();
        if (sourceMemberVariable != null) {
            SourceName sourceName = sourceMemberVariable.getNameElement();
            SourceElementEntry sourceElementEntry = new SourceElementEntry(project, (SourceElement)sourceName, 201);
            usageModel.addUsageEntry(sourceElementEntry);
        }
        String string = javaField.getName();
        Pattern pattern = null;
        int n = 0;
        while (n < uRLArray.length) {
            URL uRL = uRLArray[n];
            String string2 = URLFileSystem.getPlatformPathName((URL)uRL);
            progressIndicator.setProgressStepText(string2);
            SourceFile sourceFile = javaManager.getSourceFile(uRL);
            if (sourceFile != null) {
                List list = SourceElementAsList.asList((SourceElement)sourceFile);
                int n2 = 0;
                while (n2 < list.size()) {
                    SourceElement sourceElement = (SourceElement)list.get(n2);
                    switch (sourceElement.getSymbolKind()) {
                        case 21: {
                            SourceName sourceName = (SourceName)sourceElement;
                            if (!string.equals(sourceName.getName())) break;
                            SourceElement sourceElement2 = sourceName.getParent();
                            switch (sourceElement2.getSymbolKind()) {
                                case 50: 
                                case 58: {
                                    SourceExpression sourceExpression = (SourceExpression)sourceElement2;
                                    JavaHasType javaHasType = sourceExpression.getResolvedObject();
                                    if (!fieldDescription.equals(javaHasType)) break;
                                    SourceElementEntry sourceElementEntry = new SourceElementEntry(project, (SourceElement)sourceName, 202);
                                    usageModel.addUsageEntry(sourceElementEntry);
                                }
                            }
                            break;
                        }
                        case 67: {
                            JavaHasType javaHasType;
                            SourceDocReference sourceDocReference = (SourceDocReference)sourceElement;
                            String string3 = sourceDocReference.getText();
                            if (string3 != null && string3.endsWith(string) && fieldDescription.equals(javaHasType = sourceDocReference.getResolvedObject())) {
                                SourceElementEntry sourceElementEntry = new SourceElementEntry(project, (SourceElement)sourceDocReference, 4);
                                usageModel.addUsageEntry(sourceElementEntry);
                            }
                            list.removeAll(sourceDocReference.getChildren());
                            break;
                        }
                        case 69: {
                            SourceDocTextFragment sourceDocTextFragment;
                            String string4;
                            if (!bl || (string4 = (sourceDocTextFragment = (SourceDocTextFragment)sourceElement).getText()).indexOf(string) == -1) break;
                            if (pattern == null) {
                                pattern = Pattern.compile("\\W(" + string + ")\\W");
                            }
                            Matcher matcher = pattern.matcher(string4);
                            while (matcher.find()) {
                                int n3 = matcher.start(1);
                                int n4 = matcher.end(1);
                                SourceElementEntry sourceElementEntry = new SourceElementEntry(project, (SourceElement)sourceDocTextFragment, 2000);
                                SourceElementHandle sourceElementHandle = new SourceElementHandle((SourceElement)sourceDocTextFragment);
                                Object[] objectArray = new Object[]{sourceElementHandle, new Integer(n3), new Integer(n4)};
                                sourceElementEntry.setUserObject(objectArray);
                                usageModel.addUsageEntry(sourceElementEntry);
                            }
                            break;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return usageModel;
    }

    public boolean doChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        boolean bl = false;
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        refactoringCommandSupport.setSearchOperation(searchOperation);
        RenameFieldCriteria renameFieldCriteria = (RenameFieldCriteria)searchOperation.getCriteria();
        String string = renameFieldCriteria.getMemberNameAfter();
        String string2 = renameFieldCriteria.getFieldDescription().getFqClassName();
        UsageModel[] usageModelArray = (UsageModel[])searchOperation.getProperty(project.getLongLabel());
        UsageModel usageModel2 = usageModelArray[0];
        UsageModel usageModel3 = usageModelArray[1];
        UsageModel usageModel4 = usageModelArray[2];
        try {
            MethodDescription methodDescription;
            ArrayList arrayList = usageModel2.getUsageEntries();
            MultiMap multiMap = new MultiMap();
            int n = 0;
            while (n < arrayList.size()) {
                SourceElementEntry sourceElementEntry = (SourceElementEntry)arrayList.get(n);
                if (sourceElementEntry.isIncluded()) {
                    SourceElement sourceElement = sourceElementEntry.getSourceElementOrThrow();
                    switch (sourceElementEntry.getUsageType()) {
                        case 201: 
                        case 202: {
                            SourceName sourceName = (SourceName)sourceElement;
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceName);
                            sourceName.setValue(string);
                            break;
                        }
                        case 4: {
                            SourceDocReference sourceDocReference = (SourceDocReference)sourceElement;
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceDocReference);
                            SourceFile sourceFile = sourceDocReference.getOwningSourceFile();
                            SourceFactory sourceFactory = sourceFile.getFactory();
                            SourceDocReference sourceDocReference2 = sourceFactory.createDocMemberReference(string2, string);
                            sourceDocReference.replaceSelf((SourceElement)sourceDocReference2);
                            break;
                        }
                        case 2000: {
                            Object[] objectArray = (Object[])sourceElementEntry.getUserObject();
                            SourceElementHandle sourceElementHandle = (SourceElementHandle)objectArray[0];
                            SourceDocTextFragment sourceDocTextFragment = (SourceDocTextFragment)sourceElementHandle.getElement();
                            if (sourceDocTextFragment == null) break;
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceDocTextFragment);
                            multiMap.add((Object)sourceDocTextFragment, (Object)objectArray);
                        }
                    }
                }
                ++n;
            }
            RenameMethodURLHandler.renameMemberInComments(multiMap, string);
            MethodDescription methodDescription2 = renameFieldCriteria.getGetterDescription();
            if (methodDescription2 != null) {
                String string3 = renameFieldCriteria.getGetterNameAfter();
                RenameMethodURLHandler.doChanges(usageModel3, refactoringCommandSupport, methodDescription2, string3);
            }
            if ((methodDescription = renameFieldCriteria.getSetterDescription()) != null) {
                String string4 = renameFieldCriteria.getSetterNameAfter();
                RenameMethodURLHandler.doChanges(usageModel4, refactoringCommandSupport, methodDescription, string4);
            }
            bl = refactoringCommandSupport.commit(searchOperation.getContext(), RefactoringArb.getString(206));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }
}

