/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.rename.member;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.MultiMap;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTextFragment;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.java.util.SourceElementHandle;
import oracle.jdeveloper.refactoring.criteria.RenameMethodCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchMethodCriteria;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.URLRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.SourceElementEntry;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.handlers.JavaURLHelper;
import oracle.jdevimpl.refactoring.search.Scope;

public class RenameMethodURLHandler
extends URLRefactoringHandler {
    private static final int USAGE_SOURCE_NAME = 1000;
    private static final int USAGE_STATIC_IMPORT = 1001;
    private static final int USAGE_DOC_REFERENCE = 1002;
    private static final int USAGE_DOC_FRAGMENT = 1003;
    private static final int USAGE_ANNOTATION = 1004;

    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] projectArray = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        switch (n) {
            case -2147483546: {
                RenameMethodCriteria renameMethodCriteria = (RenameMethodCriteria)searchCriteria;
                MethodDescription methodDescription = renameMethodCriteria.getMethodDescription();
                projectArray = RenameMethodURLHandler.getIncludedProjects(searchOperation, methodDescription, Scope.createDummyScope());
                break;
            }
            case 2: {
                SearchMethodCriteria searchMethodCriteria = (SearchMethodCriteria)searchCriteria;
                MethodDescription methodDescription = searchMethodCriteria.getMethodDescription();
                projectArray = RenameMethodURLHandler.getIncludedProjects(searchOperation, methodDescription, searchMethodCriteria.getScope());
            }
        }
        return projectArray;
    }

    static Project[] getIncludedProjects(SearchOperation searchOperation, MethodDescription methodDescription, Scope scope) {
        Project[] projectArray;
        Context context = searchOperation.getContext();
        Project project = context.getProject();
        JavaManager javaManager = JavaManager.getJavaManager(project);
        JavaMethod javaMethod = methodDescription.getJavaMethod(javaManager);
        if (javaMethod.isPrivate()) {
            projectArray = new Project[]{project};
        } else {
            String string = javaMethod.getOwningClass().getQualifiedName();
            projectArray = RenameMethodURLHandler.getIncludedProjects(searchOperation, new String[]{string}, scope);
        }
        return projectArray;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet hashSet = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        switch (n) {
            case -2147483546: {
                RenameMethodCriteria renameMethodCriteria = (RenameMethodCriteria)searchCriteria;
                MethodDescription methodDescription = renameMethodCriteria.getMethodDescription();
                hashSet = RenameMethodURLHandler.chooseUrls(searchOperation, project, progressIndicator, methodDescription, false, Scope.createDummyScope());
                break;
            }
            case 2: {
                SearchMethodCriteria searchMethodCriteria = (SearchMethodCriteria)searchCriteria;
                MethodDescription methodDescription = searchMethodCriteria.getMethodDescription();
                hashSet = RenameMethodURLHandler.chooseUrls(searchOperation, project, progressIndicator, methodDescription, searchMethodCriteria.isSearchInLibraries(), searchMethodCriteria.getScope());
            }
        }
        return hashSet;
    }

    static HashSet chooseUrls(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator, MethodDescription methodDescription, boolean bl, Scope scope) {
        HashSet hashSet = null;
        JavaManager javaManager = JavaManager.getJavaManager(project);
        JavaMethod javaMethod = methodDescription.getJavaMethod(javaManager);
        JavaClass javaClass = javaMethod.getOwningClass();
        String string = javaMethod.getName();
        String[] stringArray = javaClass.isAnnotation() && "value".equals(string) ? new String[]{javaClass.getName()} : new String[]{string};
        hashSet = JavaURLHelper.getJavaURLsContaining(searchOperation, project, stringArray, bl, false, scope, progressIndicator);
        return hashSet;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] uRLArray, ProgressIndicator progressIndicator) {
        UsageModel usageModel = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        switch (n) {
            case -2147483546: {
                RenameMethodCriteria renameMethodCriteria = (RenameMethodCriteria)searchOperation.getCriteria();
                MethodDescription methodDescription = renameMethodCriteria.getMethodDescription();
                boolean bl = renameMethodCriteria.isSearchInComments();
                usageModel = RenameMethodURLHandler.findUsages(project, uRLArray, progressIndicator, methodDescription, true, true, bl, false);
                break;
            }
            case 2: {
                SearchMethodCriteria searchMethodCriteria = (SearchMethodCriteria)searchOperation.getCriteria();
                MethodDescription methodDescription = searchMethodCriteria.getMethodDescription();
                boolean bl = searchMethodCriteria.isIncludeInvocation();
                boolean bl2 = searchMethodCriteria.isIncludeDeclaration();
                boolean bl3 = searchMethodCriteria.isSearchInComments();
                boolean bl4 = searchMethodCriteria.isOverloadedMethods();
                usageModel = RenameMethodURLHandler.findUsages(project, uRLArray, progressIndicator, methodDescription, bl, bl2, bl3, bl4);
            }
        }
        return usageModel;
    }

    static UsageModel findUsages(Project project, URL[] uRLArray, ProgressIndicator progressIndicator, MethodDescription methodDescription, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        UsageModel usageModel = new UsageModel();
        JavaManager javaManager = JavaManager.getJavaManager(project);
        JavaMethod javaMethod = methodDescription.getJavaMethod(javaManager);
        String string = javaMethod.getName();
        JavaType[] javaTypeArray = javaMethod.getParameterTypes();
        JavaClass javaClass = javaMethod.getOwningClass();
        HashSet hashSet = new HashSet();
        HashSet<JavaMethod> hashSet2 = new HashSet<JavaMethod>();
        if (bl4) {
            Collection collection = javaClass.getMethods(string);
            for (JavaMethod javaMethod2 : collection) {
                hashSet2.add(javaMethod2);
            }
        } else {
            hashSet2.add(javaMethod);
        }
        boolean bl5 = javaClass.isAnnotation();
        Pattern pattern = null;
        int n = 0;
        while (n < uRLArray.length && !progressIndicator.isUserCancelled()) {
            URL uRL = uRLArray[n];
            String string2 = URLFileSystem.getPlatformPathName((URL)uRL);
            progressIndicator.setProgressStepText(string2);
            SourceFile sourceFile = javaManager.getSourceFile(uRL);
            if (sourceFile != null) {
                List list = SourceElementAsList.asList((SourceElement)sourceFile);
                int n2 = 0;
                while (n2 < list.size()) {
                    SourceElement sourceElement = (SourceElement)list.get(n2);
                    switch (sourceElement.getSymbolKind()) {
                        case 21: {
                            JavaMethod javaMethod3;
                            SourceMethodCallExpression sourceMethodCallExpression;
                            JavaMethod javaMethod4;
                            SourceElement sourceElement2;
                            SourceName sourceName;
                            String string3;
                            if (!bl || !string.equals(string3 = (sourceName = (SourceName)sourceElement).getName()) || (sourceElement2 = sourceName.getParent()).getSymbolKind() != 54 || (javaMethod4 = (sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement2).getResolvedMethod()) == null || !bl4 && javaTypeArray.length != javaMethod4.getParameters().size() || !hashSet2.contains(javaMethod3 = javaMethod4.getMethodErasure()) && !RenameMethodURLHandler.isSameMethod(javaMethod3, hashSet2, hashSet)) break;
                            SourceElementEntry sourceElementEntry = new SourceElementEntry(project, (SourceElement)sourceName, 1000);
                            usageModel.addUsageEntry(sourceElementEntry);
                            break;
                        }
                        case 3: {
                            SourceMethod sourceMethod;
                            SourceClass sourceClass;
                            if (!bl2 || !(sourceClass = (SourceClass)sourceElement).isSubtypeOf((JavaType)javaClass)) break;
                            if (bl4) {
                                Collection collection = sourceClass.getMethods(string);
                                for (JavaMethod javaMethod5 : collection) {
                                    SourceMethod sourceMethod2 = (SourceMethod)javaMethod5.getSourceElement();
                                    if (sourceMethod2 == null) continue;
                                    SourceName sourceName = sourceMethod2.getNameElement();
                                    SourceElementEntry sourceElementEntry = new SourceElementEntry(project, (SourceElement)sourceName, 1000);
                                    usageModel.addUsageEntry(sourceElementEntry);
                                }
                                break;
                            }
                            JavaMethod javaMethod6 = sourceClass.getMethod(string, javaTypeArray);
                            if (javaMethod6 == null || (sourceMethod = (SourceMethod)javaMethod6.getSourceElement()) == null) break;
                            SourceName sourceName = sourceMethod.getNameElement();
                            SourceElementEntry sourceElementEntry = new SourceElementEntry(project, (SourceElement)sourceName, 1000);
                            usageModel.addUsageEntry(sourceElementEntry);
                            break;
                        }
                        case 14: {
                            SourceName sourceName;
                            String string4;
                            SourceImport sourceImport;
                            if (!bl || !(sourceImport = (SourceImport)sourceElement).isStatic() || !(string4 = (sourceName = sourceImport.getNameElement()).getName()).endsWith(string)) break;
                            sourceFile.compile();
                            Collection collection = sourceImport.getImportedElements();
                            for (JavaElement javaElement : collection) {
                                if (javaElement.getElementKind() != 8) continue;
                                JavaMethod javaMethod7 = (JavaMethod)javaElement;
                                boolean bl6 = bl4 ? javaMethod.getName().equals(javaMethod7.getName()) : javaMethod7.equals((Object)javaMethod);
                                if (!bl6) continue;
                                SourceElementEntry sourceElementEntry = new SourceElementEntry(project, (SourceElement)sourceName, 1001);
                                usageModel.addUsageEntry(sourceElementEntry);
                            }
                            break;
                        }
                        case 67: {
                            JavaMember javaMember;
                            SourceDocReference sourceDocReference = (SourceDocReference)sourceElement;
                            String string5 = sourceDocReference.getText();
                            if (string5.indexOf(string) != -1 && (javaMember = sourceDocReference.getResolvedMember()) != null && javaMember.getElementKind() == 8) {
                                JavaMethod javaMethod8 = (JavaMethod)javaMember;
                                if ((bl4 || javaTypeArray.length == javaMethod8.getParameters().size()) && (hashSet2.contains(javaMethod8) || RenameMethodURLHandler.isSameMethod(javaMethod8, hashSet2, hashSet))) {
                                    SourceElementEntry sourceElementEntry = new SourceElementEntry(project, (SourceElement)sourceDocReference, 1002);
                                    usageModel.addUsageEntry(sourceElementEntry);
                                }
                            }
                            list.removeAll(sourceDocReference.getChildren());
                            break;
                        }
                        case 69: {
                            SourceDocTextFragment sourceDocTextFragment;
                            String string6;
                            if (!bl3 || (string6 = (sourceDocTextFragment = (SourceDocTextFragment)sourceElement).getText()).indexOf(string) == -1) break;
                            if (pattern == null) {
                                pattern = Pattern.compile("\\W(" + string + ")\\W");
                            }
                            Matcher matcher = pattern.matcher(string6);
                            while (matcher.find()) {
                                int n3 = matcher.start(1);
                                int n4 = matcher.end(1);
                                int n5 = sourceDocTextFragment.getStartOffset();
                                UsageEntry usageEntry = new UsageEntry(project, uRL, n5 + n3, n4 - n3, 1003, 1);
                                SourceElementHandle sourceElementHandle = new SourceElementHandle((SourceElement)sourceDocTextFragment);
                                Object[] objectArray = new Object[]{sourceElementHandle, new Integer(n3), new Integer(n4)};
                                usageEntry.setUserObject(objectArray);
                                usageModel.addUsageEntry(usageEntry);
                            }
                            break;
                        }
                        case 1: {
                            if (!bl5) break;
                            SourceAnnotation sourceAnnotation = (SourceAnnotation)sourceElement;
                            SourceListExpression sourceListExpression = sourceAnnotation.getArgumentList();
                            List list2 = sourceListExpression.getChildren();
                            int n6 = 0;
                            while (n6 < list2.size()) {
                                SourceExpression sourceExpression = (SourceExpression)list2.get(n6);
                                switch (sourceExpression.getSymbolKind()) {
                                    case 49: {
                                        SourceAssignmentExpression sourceAssignmentExpression = (SourceAssignmentExpression)sourceExpression;
                                        SourceExpression sourceExpression2 = sourceAssignmentExpression.getFirstOperand();
                                        if (sourceExpression2 == null || !string.equals(sourceExpression2.getText())) break;
                                        SourceElementEntry sourceElementEntry = new SourceElementEntry(project, (SourceElement)sourceExpression, 1004);
                                        usageModel.addUsageEntry(sourceElementEntry);
                                        break;
                                    }
                                    default: {
                                        if (!"value".equals(string)) break;
                                        SourceElementEntry sourceElementEntry = new SourceElementEntry(project, (SourceElement)sourceExpression, 1004);
                                        usageModel.addUsageEntry(sourceElementEntry);
                                    }
                                }
                                ++n6;
                            }
                            break;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return usageModel;
    }

    private static boolean isSameMethod(JavaMethod javaMethod, HashSet hashSet, HashSet hashSet2) {
        if (!hashSet2.contains(javaMethod)) {
            Collection collection = javaMethod.getOverriddenMethods();
            for (JavaMethod javaMethod2 : collection) {
                if (!hashSet.contains(javaMethod2)) continue;
                hashSet.add(javaMethod);
                return true;
            }
            hashSet2.addAll(collection);
        }
        return false;
    }

    public boolean doChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        boolean bl = false;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        RenameMethodCriteria renameMethodCriteria = (RenameMethodCriteria)searchCriteria;
        MethodDescription methodDescription = renameMethodCriteria.getMethodDescription();
        String string = renameMethodCriteria.getMemberNameAfter();
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            RenameMethodURLHandler.doChanges(usageModel, refactoringCommandSupport, methodDescription, string);
            refactoringCommandSupport.setSearchOperation(searchOperation);
            Context context = searchOperation.getContext();
            bl = refactoringCommandSupport.commit(context, RefactoringArb.getString(204));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            refactoringCommandSupport.abort();
        }
        return bl;
    }

    static void doChanges(UsageModel usageModel, RefactoringCommandSupport refactoringCommandSupport, MethodDescription methodDescription, String string) {
        String string2 = methodDescription.getFqClassName();
        ArrayList arrayList = usageModel.getUsageEntries();
        MultiMap multiMap = new MultiMap();
        int n = 0;
        while (n < arrayList.size()) {
            BaseUsageEntry baseUsageEntry = (BaseUsageEntry)arrayList.get(n);
            if (baseUsageEntry.isIncluded()) {
                block0 : switch (baseUsageEntry.getUsageType()) {
                    case 1000: {
                        SourceElementEntry sourceElementEntry = (SourceElementEntry)baseUsageEntry;
                        SourceName sourceName = (SourceName)sourceElementEntry.getSourceElementOrThrow();
                        refactoringCommandSupport.beginTransaction((SourceElement)sourceName);
                        sourceName.setText(string);
                        break;
                    }
                    case 1001: {
                        SourceElementEntry sourceElementEntry = (SourceElementEntry)baseUsageEntry;
                        SourceName sourceName = (SourceName)sourceElementEntry.getSourceElementOrThrow();
                        refactoringCommandSupport.beginTransaction((SourceElement)sourceName);
                        sourceName.setText(string2 + '.' + string);
                        break;
                    }
                    case 1002: {
                        SourceElementEntry sourceElementEntry = (SourceElementEntry)baseUsageEntry;
                        SourceDocReference sourceDocReference = (SourceDocReference)sourceElementEntry.getSourceElementOrThrow();
                        SourceFile sourceFile = sourceDocReference.getOwningSourceFile();
                        refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
                        SourceFactory sourceFactory = sourceFile.getFactory();
                        SourceDocReference sourceDocReference2 = sourceFactory.createDocReference(string2, string, methodDescription.getParameterTypes());
                        sourceDocReference.replaceSelf((SourceElement)sourceDocReference2);
                        break;
                    }
                    case 1003: {
                        UsageEntry usageEntry = (UsageEntry)baseUsageEntry;
                        Object object = usageEntry.getUserObject();
                        Object[] objectArray = (Object[])object;
                        SourceElementHandle sourceElementHandle = (SourceElementHandle)objectArray[0];
                        SourceDocTextFragment sourceDocTextFragment = (SourceDocTextFragment)sourceElementHandle.getElement();
                        if (sourceDocTextFragment == null) break;
                        multiMap.add((Object)sourceDocTextFragment, (Object)objectArray);
                        break;
                    }
                    case 1004: {
                        SourceElementEntry sourceElementEntry = (SourceElementEntry)baseUsageEntry;
                        SourceExpression sourceExpression = (SourceExpression)sourceElementEntry.getSourceElementOrThrow();
                        SourceFile sourceFile = sourceExpression.getOwningSourceFile();
                        refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
                        SourceFactory sourceFactory = sourceFile.getFactory();
                        SourceSimpleNameExpression sourceSimpleNameExpression = sourceFactory.createSimpleNameExpression(string);
                        switch (sourceExpression.getSymbolKind()) {
                            case 49: {
                                SourceAssignmentExpression sourceAssignmentExpression = (SourceAssignmentExpression)sourceExpression;
                                SourceExpression sourceExpression2 = sourceAssignmentExpression.getFirstOperand();
                                if ("value".equals(string)) {
                                    SourceExpression sourceExpression3 = sourceAssignmentExpression.getSecondOperand();
                                    SourceElement sourceElement = sourceExpression3.cloneSelf(sourceFile);
                                    sourceExpression.replaceSelf(sourceElement);
                                    break block0;
                                }
                                sourceExpression2.replaceSelf((SourceElement)sourceSimpleNameExpression);
                                break block0;
                            }
                        }
                        SourceExpression sourceExpression4 = (SourceExpression)sourceExpression.cloneSelf(sourceFile);
                        SourceAssignmentExpression sourceAssignmentExpression = sourceFactory.createAssignment(6, (SourceExpression)sourceSimpleNameExpression, sourceExpression4);
                        sourceExpression.replaceSelf((SourceElement)sourceAssignmentExpression);
                    }
                }
            }
            ++n;
        }
        RenameMethodURLHandler.renameMemberInComments(multiMap, string);
    }

    static void renameMemberInComments(MultiMap multiMap, String string) {
        Set set = multiMap.keySet();
        for (SourceDocTextFragment sourceDocTextFragment : set) {
            String string2 = sourceDocTextFragment.getText();
            StringBuffer stringBuffer = new StringBuffer(string2);
            List list = multiMap.get((Object)sourceDocTextFragment);
            Collections.sort(list, new 1());
            int n = 0;
            while (n < list.size()) {
                Object[] objectArray = (Object[])list.get(n);
                int n2 = (Integer)objectArray[1];
                int n3 = (Integer)objectArray[2];
                stringBuffer.replace(n2, n3, string);
                ++n;
            }
            SourceFile sourceFile = sourceDocTextFragment.getOwningSourceFile();
            SourceFactory sourceFactory = sourceFile.getFactory();
            SourceDocTextFragment sourceDocTextFragment2 = sourceFactory.createDocTextFragment(stringBuffer.toString());
            sourceDocTextFragment.replaceSelf((SourceElement)sourceDocTextFragment2);
        }
    }

    public static UsageModel searchMethod(Project project, URL[] uRLArray, ProgressIndicator progressIndicator, MethodDescription methodDescription, boolean bl) {
        return RenameMethodURLHandler.findUsages(project, uRLArray, progressIndicator, methodDescription, true, true, bl, false);
    }

    public static final class 1
    implements Comparator {
        public int compare(Object object, Object object2) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            int n = (Integer)objectArray[1];
            int n2 = (Integer)objectArray2[1];
            return n2 - n;
        }
    }
}

