/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.rename.variable;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;
import oracle.jdeveloper.refactoring.criteria.RenameVariableCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchVariableCriteria;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.TextChangeBasedRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.SourceElementEntry;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdevimpl.refactoring.handlers.TextURLHandler;

public class FindRenameVariableURLHandler
extends TextChangeBasedRefactoringHandler {
    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] projectArray = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        if (n == 6 || n == -2147483542) {
            Context context = searchOperation.getContext();
            Project project = context.getProject();
            projectArray = new Project[]{project};
        }
        return projectArray;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet<URL> hashSet = null;
        if (FindRenameVariableURLHandler.isMyType(searchOperation)) {
            URL uRL = this.getURL(searchOperation);
            hashSet = new HashSet<URL>(1);
            hashSet.add(uRL);
        }
        return hashSet;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] uRLArray, ProgressIndicator progressIndicator) {
        SearchVariableCriteria searchVariableCriteria;
        UsageModel usageModel = null;
        if (FindRenameVariableURLHandler.isMyType(searchOperation) && (searchVariableCriteria = (SearchVariableCriteria)searchOperation.getCriteria()).isValid()) {
            SourceBlock sourceBlock;
            boolean bl;
            usageModel = new UsageModel();
            SourceVariable sourceVariable = searchVariableCriteria.getVariable();
            String string = sourceVariable.getName();
            boolean bl2 = bl = sourceVariable.getSymbolKind() == 13;
            if (bl) {
                SourceMethod sourceMethod = (SourceMethod)Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceVariable);
                sourceBlock = sourceMethod.getBlock();
                SourceDocComment sourceDocComment = sourceMethod.getDocComment();
                if (sourceDocComment != null) {
                    Collection collection = sourceDocComment.findTags("@param");
                    for (SourceDocTag sourceDocTag : collection) {
                        SourceDocReference sourceDocReference;
                        String string2;
                        if (!sourceDocTag.isParameter() || !string.equals(string2 = (sourceDocReference = sourceDocTag.getReference()).getParameterName())) continue;
                        SourceElementEntry sourceElementEntry = new SourceElementEntry(project, (SourceElement)sourceDocReference, 0);
                        usageModel.addUsageEntry(sourceElementEntry);
                    }
                }
            } else {
                sourceBlock = (SourceBlock)Util.getAncestorOfClass(SourceBlock.class, (SourceElement)sourceVariable);
            }
            if (sourceBlock != null) {
                List list = SourceElementAsList.asList((SourceElement)sourceBlock, 58);
                int n = 0;
                while (n < list.size()) {
                    JavaHasType javaHasType;
                    SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)list.get(n);
                    String string3 = sourceSimpleNameExpression.getName();
                    if (string.equals(string3) && (javaHasType = sourceSimpleNameExpression.getResolvedObject()).equals(sourceVariable)) {
                        SourceElementEntry sourceElementEntry = new SourceElementEntry(project, (SourceElement)sourceSimpleNameExpression, 0);
                        usageModel.addUsageEntry(sourceElementEntry);
                    }
                    ++n;
                }
            }
            URL uRL = uRLArray[0];
            if (searchVariableCriteria.isSearchInComments()) {
                int n = sourceBlock.getStartOffset();
                int n2 = sourceBlock.getEndOffset();
                this.scanComments(project, uRL, string, usageModel, n, n2);
            }
            SourceName sourceName = sourceVariable.getNameElement();
            SourceElementEntry sourceElementEntry = new SourceElementEntry(project, (SourceElement)sourceName, 0);
            usageModel.addUsageEntry(sourceElementEntry);
        }
        return usageModel;
    }

    private void scanComments(Project project, URL uRL, String string, UsageModel usageModel, int n, int n2) {
        Node node = NodeFactory.find((URL)uRL);
        if (node instanceof TextNode) {
            int n3;
            Pattern pattern = Pattern.compile("\\b" + string + "\\b");
            TextNode textNode = (TextNode)node;
            JavaLexer javaLexer = new JavaLexer();
            TextBuffer textBuffer = textNode.acquireTextBuffer();
            javaLexer.setTextBuffer((ReadTextBuffer)textBuffer);
            LexerToken lexerToken = javaLexer.createLexerToken();
            block3: while ((n3 = javaLexer.lex(lexerToken)) != 0) {
                switch (n3) {
                    case 24: 
                    case 25: 
                    case 26: {
                        int n4 = lexerToken.getStartOffset();
                        int n5 = lexerToken.getEndOffset();
                        if (n > n4 || n5 > n2) continue block3;
                        String string2 = textBuffer.getString(n4, n5 - n4);
                        Matcher matcher = pattern.matcher(string2);
                        while (matcher.find()) {
                            int n6 = matcher.start();
                            int n7 = matcher.end();
                            UsageEntry usageEntry = new UsageEntry(project, uRL, n4 + n6, n7 - n6, 0, 2);
                            usageModel.addUsageEntry(usageEntry);
                        }
                        continue block3;
                    }
                }
            }
        }
    }

    public RefactoringChange[] getChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        RefactoringChange[] refactoringChangeArray = null;
        if (FindRenameVariableURLHandler.isMyType(searchOperation)) {
            RenameVariableCriteria renameVariableCriteria = (RenameVariableCriteria)searchOperation.getCriteria();
            ArrayList arrayList = TextURLHandler.genericRename(usageModel, renameVariableCriteria.getVariableName(), renameVariableCriteria.getNewVariableName());
            refactoringChangeArray = arrayList.toArray(new RefactoringChange[arrayList.size()]);
        }
        return refactoringChangeArray;
    }

    private static boolean isMyType(SearchOperation searchOperation) {
        boolean bl = false;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        if (n == 6 || n == -2147483542) {
            bl = true;
        }
        return bl;
    }

    private URL getURL(SearchOperation searchOperation) {
        SearchVariableCriteria searchVariableCriteria = (SearchVariableCriteria)searchOperation.getCriteria();
        SourceFile sourceFile = searchVariableCriteria.getSourceFile();
        URL uRL = sourceFile.getURL();
        return uRL;
    }
}

