/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.replacectorwithmethod;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceThrowsClause;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.oprs.replacectorwithmethod.ReplaceCtorWithMethodDialog;
import oracle.jdevimpl.refactoring.util.FindMemberUsages;

public class ReplaceCtorWithMethodController
implements Controller {
    private static final boolean HAS_BUG_CCTOR_NOT_SIMPLIFIED = true;
    private static final String OPR_TITLE = RefactoringArb.getString(199);

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = this.handle(context, false);
        ideAction.setEnabled(bl);
        return true;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        this.handle(context, true);
        return true;
    }

    private boolean handle(Context context, boolean bl) {
        ElementAt elementAt;
        boolean bl2 = false;
        if (context != null && context.getProject() != null && (elementAt = ElementAt.findElementAt(context)) != null) {
            switch (elementAt.getElementType()) {
                case 2: {
                    SourceMethod sourceMethod;
                    JavaMethod javaMethod = (JavaMethod)elementAt.getJavaElement();
                    if (javaMethod == null || (sourceMethod = (SourceMethod)javaMethod.getSourceElement()) == null || !Util.canRefactor((SourceElement)sourceMethod)) break;
                    bl2 = true;
                    if (!bl) break;
                    this.handle(context, sourceMethod);
                }
            }
        }
        return bl2;
    }

    private void handle(Context context, SourceMethod sourceMethod) {
        SourceClass sourceClass = sourceMethod.getEnclosingClass();
        if (!sourceClass.isAbstract()) {
            if (sourceClass.getOwningClass() == null) {
                ReplaceCtorWithMethodDialog replaceCtorWithMethodDialog = new ReplaceCtorWithMethodDialog(context, sourceMethod);
                if (replaceCtorWithMethodDialog.runDialog()) {
                    String string = replaceCtorWithMethodDialog.getMethodName();
                    UsageModel usageModel = new UsageModel();
                    Project project = context.getProject();
                    MyJotUsageListener myJotUsageListener = new MyJotUsageListener(project, usageModel);
                    FindMemberUsages findMemberUsages = new FindMemberUsages((JavaMember)sourceMethod);
                    findMemberUsages.findMemberUsages(project, myJotUsageListener);
                    boolean bl = true;
                    if (MyJotUsageListener.ra$_hasAnonymousClassUsages(myJotUsageListener)) {
                        String string2 = MessageFormat.format("{0} is extended by anonymous classes which will not be transformed to use the factory method ", sourceClass.getQualifiedName());
                        int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), string2, OPR_TITLE, 2, 2);
                        if (n == 2) {
                            usageModel.release();
                            return;
                        }
                        bl = false;
                    }
                    RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
                    try {
                        this.createFactoryMethod(refactoringCommandSupport, sourceMethod, string, (JavaClass)sourceClass);
                        if (bl) {
                            this.modifyCtor(sourceMethod);
                        }
                        this.replaceUsages(refactoringCommandSupport, usageModel, string, (JavaClass)sourceClass);
                        usageModel.release();
                        refactoringCommandSupport.commit(context, OPR_TITLE);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        refactoringCommandSupport.abort();
                    }
                }
            } else {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), RefactoringArb.getString(200), OPR_TITLE, 0);
            }
        } else {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), RefactoringArb.getString(201), OPR_TITLE, 0);
        }
    }

    private void replaceUsages(RefactoringCommandSupport refactoringCommandSupport, UsageModel usageModel, String string, JavaClass javaClass) {
        ArrayList arrayList = usageModel.getUsageEntries();
        int n = 0;
        while (n < arrayList.size()) {
            UsageEntry usageEntry = (UsageEntry)arrayList.get(n);
            if (usageEntry.isIncluded()) {
                SourceNewClassExpression sourceNewClassExpression = (SourceNewClassExpression)usageEntry.getUserObject();
                SourceFile sourceFile = sourceNewClassExpression.getOwningSourceFile();
                refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
                SourceFactory sourceFactory = sourceFile.getFactory();
                String string2 = javaClass.getQualifiedName();
                SourceExpression sourceExpression = sourceFactory.createExpression(string2);
                SourceListExpression sourceListExpression = sourceNewClassExpression.getArgumentList();
                SourceListExpression sourceListExpression2 = (SourceListExpression)sourceListExpression.cloneSelf(sourceFile);
                SourceMethodCallExpression sourceMethodCallExpression = sourceFactory.createMethodCall(sourceExpression, string, sourceListExpression2);
                sourceNewClassExpression.replaceSelf((SourceElement)sourceMethodCallExpression);
            }
            ++n;
        }
    }

    private void modifyCtor(SourceMethod sourceMethod) {
        sourceMethod.removeModifiers(5);
        sourceMethod.addModifiers(2);
    }

    private void createFactoryMethod(RefactoringCommandSupport refactoringCommandSupport, SourceMethod sourceMethod, String string, JavaClass javaClass) {
        SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
        SourceFile sourceFile = sourceClass.getOwningSourceFile();
        refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
        SourceFactory sourceFactory = sourceFile.getFactory();
        SourceTypeReference sourceTypeReference = sourceFactory.createType(sourceClass.getQualifiedName());
        SourceFormalParameterList sourceFormalParameterList = sourceMethod.getFormalParameterList();
        SourceBlock sourceBlock = sourceFactory.createBlock();
        List list = sourceFormalParameterList.getSourceParameters();
        SourceExpression[] sourceExpressionArray = new SourceExpression[list.size()];
        int n = 0;
        while (n < list.size()) {
            SourceVariable sourceVariable = (SourceVariable)list.get(n);
            String string2 = sourceVariable.getName();
            SourceSimpleNameExpression sourceSimpleNameExpression = sourceFactory.createSimpleNameExpression(string2);
            sourceExpressionArray[n] = sourceSimpleNameExpression;
            ++n;
        }
        SourceTypeReference sourceTypeReference2 = sourceFactory.createType(sourceClass.getName());
        SourceNewClassExpression sourceNewClassExpression = sourceFactory.createNewClassExpression(null, sourceTypeReference2, sourceFactory.createArgumentList(sourceExpressionArray), null);
        SourceReturnStatement sourceReturnStatement = sourceFactory.createReturnStatement((SourceExpression)sourceNewClassExpression);
        sourceReturnStatement.addSelf((SourceElement)sourceBlock);
        SourceTypeReference sourceTypeReference3 = (SourceTypeReference)sourceTypeReference.cloneSelf(sourceFile);
        SourceFormalParameterList sourceFormalParameterList2 = (SourceFormalParameterList)sourceFormalParameterList.cloneSelf(sourceFile);
        SourceThrowsClause sourceThrowsClause = (SourceThrowsClause)sourceMethod.getThrowsClause().cloneSelf(sourceFile);
        SourceMethod sourceMethod2 = sourceFactory.createMethod(sourceTypeReference3, string, sourceFormalParameterList2, sourceThrowsClause, sourceBlock);
        int n2 = sourceMethod.getModifiers() & 7;
        sourceMethod2.setModifiers(n2 | 8);
        sourceMethod2.addSelfAfter((SourceElement)sourceMethod);
    }

    private static class MyJotUsageListener
    extends FindMemberUsages.JotUsageListener {
        private boolean _hasAnonymousClassUsages;
        private final Project _project;
        private final UsageModel _usageModel;

        public MyJotUsageListener(Project project, UsageModel usageModel) {
            this._project = project;
            this._usageModel = usageModel;
        }

        public void whenMethodUsage(SourceInvokeExpression sourceInvokeExpression) {
            SourceNewClassExpression sourceNewClassExpression = (SourceNewClassExpression)sourceInvokeExpression;
            SourceClass sourceClass = sourceNewClassExpression.getAnonymousClass();
            if (sourceClass != null) {
                this._hasAnonymousClassUsages = true;
            } else {
                UsageEntry usageEntry = new UsageEntry(this._project, (SourceElement)sourceInvokeExpression, 0, 2);
                usageEntry.setUserObject(sourceInvokeExpression);
                this._usageModel.addUsageEntry(usageEntry);
            }
        }

        static boolean ra$_hasAnonymousClassUsages(MyJotUsageListener myJotUsageListener) {
            return myJotUsageListener._hasAnonymousClassUsages;
        }
    }
}

