/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.resbundle;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.OrderedProperties;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceTypeExpression;
import oracle.javatools.parser.java.v2.write.SourceTransaction;

public class ResourceCommand
extends Command {
    private SourceLiteralExpression _sourceLiteralExpression;
    private URL _resUrl;
    private String _resName;
    private String _resString;
    private OrderedProperties _properties;
    private UndoableEdit[] _undoableEdits;
    private final Node[] _affectedNodes;

    void $init$() {
        this._affectedNodes = new Node[2];
    }

    public ResourceCommand(Context context, SourceLiteralExpression sourceLiteralExpression, URL uRL, String string, String string2, OrderedProperties orderedProperties) throws IllegalAccessException, InstantiationException {
        super(-1, 3, "Resource Bundle Change");
        this.$init$();
        this.setContext(context);
        this._sourceLiteralExpression = sourceLiteralExpression;
        this._resUrl = uRL;
        this._resName = string;
        this._resString = string2;
        this._properties = orderedProperties;
        this._affectedNodes[0] = NodeFactory.findOrCreate((URL)this._resUrl);
        this._affectedNodes[1] = NodeFactory.findOrCreate((URL)sourceLiteralExpression.getOwningSourceFile().getURL());
    }

    public int doit() throws Exception {
        if (this._undoableEdits == null) {
            this._undoableEdits = new UndoableEdit[3];
            this.updateJavaFile();
            this.updateProperties();
            this._sourceLiteralExpression = null;
            this._resUrl = null;
            this._resName = null;
            this._resString = null;
            this._properties = null;
        } else {
            int n = 0;
            while (n < this._undoableEdits.length) {
                UndoableEdit undoableEdit = this._undoableEdits[n];
                undoableEdit.redo();
                ++n;
            }
        }
        return 0;
    }

    public int undo() throws Exception {
        int n = this._undoableEdits.length - 1;
        while (n >= 0) {
            UndoableEdit undoableEdit = this._undoableEdits[n];
            undoableEdit.undo();
            --n;
        }
        return 0;
    }

    private void updateJavaFile() {
        Project project = this.getContext().getProject();
        ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
        URL uRL = URLFileSystem.getParent((URL)this._resUrl);
        String string = contentSet.toRelativePath(uRL).replace('/', '.');
        String string2 = URLFileSystem.getFileName((URL)this._resUrl);
        String string3 = string2.substring(0, string2.indexOf(46));
        String string4 = string + string3;
        SourceFile sourceFile = this._sourceLiteralExpression.getOwningSourceFile();
        SourceTransaction sourceTransaction = sourceFile.beginTransaction();
        SourceFactory sourceFactory = sourceFile.getFactory();
        SourceTypeExpression sourceTypeExpression = sourceFactory.createTypeExpression(string4);
        SourceTypeExpression sourceTypeExpression2 = sourceFactory.createTypeExpression(string4);
        SourceDotExpression sourceDotExpression = sourceFactory.createDotReference((SourceExpression)sourceTypeExpression2, this._resName);
        SourceMethodCallExpression sourceMethodCallExpression = sourceFactory.createMethodCall((SourceExpression)sourceTypeExpression, "getString", sourceFactory.createArgumentList((SourceExpression)sourceDotExpression));
        this._sourceLiteralExpression.replaceSelf((SourceElement)sourceMethodCallExpression);
        this._undoableEdits[0] = sourceTransaction.commit();
    }

    private void updateProperties() throws IOException, IllegalAccessException, InstantiationException {
        this._properties.setProperty(this._resName, this._resString);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this._properties.store((OutputStream)byteArrayOutputStream, null);
        byteArrayOutputStream.close();
        String string = byteArrayOutputStream.toString();
        TextNode textNode = (TextNode)NodeFactory.findOrCreate((URL)this._resUrl);
        TextBuffer textBuffer = textNode.acquireTextBuffer();
        this._undoableEdits[1] = textBuffer.removeToEnd(0);
        this._undoableEdits[2] = textBuffer.insert(0, string.toCharArray());
    }

    public Node[] getAffectedNodes() {
        return this._affectedNodes;
    }
}

