/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.resbundle;

import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.OrderedProperties;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.refactoring.oprs.resbundle.ResourceCommand;
import oracle.jdevimpl.refactoring.oprs.resbundle.ResourceDialog;

public class ResourceController
implements Controller {
    private static final String TITLE = "Introduce Resource";

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = this.handle(context, false);
        ideAction.setEnabled(bl);
        return true;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        this.handle(context, true);
        return true;
    }

    private boolean handle(Context context, boolean bl) {
        boolean bl2 = false;
        View view = context.getView();
        if (view instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)view;
            Node node = context.getNode();
            if (node instanceof JavaSourceNode) {
                SourceLiteralExpression sourceLiteralExpression;
                String string;
                URL uRL = node.getURL();
                int n = codeEditor.getCaretPosition();
                Project project = context.getProject();
                JavaManager javaManager = JavaManager.getJavaManager(project);
                SourceFile sourceFile = javaManager.getSourceFile(uRL);
                SourceElement sourceElement = sourceFile.getElementAt(n);
                if (sourceElement instanceof SourceLiteralExpression && (string = (sourceLiteralExpression = (SourceLiteralExpression)sourceElement).getText()).startsWith("\"") && string.endsWith("\"")) {
                    bl2 = true;
                    if (bl) {
                        this.whenResource(context, sourceLiteralExpression);
                    }
                }
            }
        }
        return bl2;
    }

    private void whenResource(Context context, SourceLiteralExpression sourceLiteralExpression) {
        boolean bl;
        ResourceDialog resourceDialog = new ResourceDialog(context, sourceLiteralExpression);
        do {
            boolean bl2;
            bl = false;
            if (!resourceDialog.runDialog(context, sourceLiteralExpression)) continue;
            URL uRL = resourceDialog.getResUrl();
            String string = resourceDialog.getResName();
            String string2 = resourceDialog.getResString();
            Project project = context.getProject();
            ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
            String string3 = contentSet.toRelativePath(uRL);
            boolean bl3 = bl2 = string3 != null;
            if (bl2) {
                OrderedProperties orderedProperties = this.getProperties(uRL);
                if (orderedProperties.getProperty(string) != null) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)(string + " already exists."), (String)TITLE, null);
                    bl = true;
                    continue;
                }
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                try {
                    ResourceCommand resourceCommand = new ResourceCommand(context, sourceLiteralExpression, uRL, string, string2, orderedProperties);
                    commandProcessor.invoke((Command)resourceCommand);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)(URLFileSystem.getPlatformPathName((URL)uRL) + " must part of the project."), (String)TITLE, null);
            bl = true;
        } while (bl);
    }

    private OrderedProperties getProperties(URL uRL) {
        OrderedProperties orderedProperties = null;
        try {
            TextNode textNode = (TextNode)NodeFactory.findOrCreate((URL)uRL);
            TextBuffer textBuffer = textNode.acquireTextBuffer();
            String string = textBuffer.getString(0, textBuffer.getLength());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            OrderedProperties orderedProperties2 = new OrderedProperties();
            orderedProperties2.load((InputStream)byteArrayInputStream);
            orderedProperties = orderedProperties2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return orderedProperties;
    }
}

