/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.resbundle;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.controls.UpperCaseTextField;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;

class ResourceDialog
extends JPanel {
    private static final HashMap _registry = new HashMap();
    private Context _context;
    private SourceLiteralExpression _sourceLiteralExpression;
    private JComboBox _resCombo;
    private JTextField _nameField;
    private JTextField _strField;
    private static String _lastPlatformName;

    public ResourceDialog(Context context, SourceLiteralExpression sourceLiteralExpression) {
        super(new GridBagLayout());
        this._context = context;
        this._sourceLiteralExpression = sourceLiteralExpression;
        this.init();
    }

    public boolean runDialog(Context context, SourceLiteralExpression sourceLiteralExpression) {
        boolean bl = false;
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)Ide.getMainWindow(), "Resource String", 3);
        jEWTDialog.setContent((Component)this);
        jEWTDialog.setInitialFocus((Component)this._nameField);
        if (jEWTDialog.runDialog()) {
            URL uRL = this.getResUrl();
            if (uRL != null) {
                _registry.put(sourceLiteralExpression.getOwningSourceFile().getURL(), uRL);
                _lastPlatformName = URLFileSystem.getPlatformPathName((URL)uRL);
            }
            bl = true;
        }
        return bl;
    }

    private void init() {
        String string = this._sourceLiteralExpression.getText();
        String string2 = string.substring(1, string.length() - 1);
        SourceFile sourceFile = this._sourceLiteralExpression.getOwningSourceFile();
        URL uRL = sourceFile.getURL();
        URL uRL2 = (URL)_registry.get(uRL);
        JLabel jLabel = new JLabel();
        DefaultListComboBoxModel defaultListComboBoxModel = new DefaultListComboBoxModel();
        Collection collection = _registry.values();
        for (URL uRL3 : collection) {
            String string3 = URLFileSystem.getPlatformPathName((URL)uRL3);
            defaultListComboBoxModel.addElement((Object)string3);
        }
        this._resCombo = new JComboBox(defaultListComboBoxModel);
        this._resCombo.setEditable(true);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._resCombo, (String)"&File");
        if (uRL2 != null) {
            String string4 = URLFileSystem.getPlatformPathName((URL)uRL2);
            this._resCombo.setSelectedItem(string4);
        } else if (_lastPlatformName != null) {
            this._resCombo.setSelectedItem(_lastPlatformName);
        }
        JButton jButton = new JButton("...");
        jButton.addActionListener(new 1());
        JLabel jLabel2 = new JLabel();
        this._nameField = new UpperCaseTextField();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._nameField, (String)"&Name");
        String string5 = string2.replaceAll("&", "").replaceAll("\\W+", "_").replaceAll("_*$", "").toUpperCase();
        this._nameField.setText(string5);
        JLabel jLabel3 = new JLabel();
        this._strField = new JTextField(50);
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._strField, (String)"&String");
        this._strField.setText(string2.replaceAll("\\\\\"", "\""));
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._resCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)jButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._nameField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._strField, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 2, insets, 0, 0));
    }

    private void whenBrowse() {
        URL uRL;
        URLChooser uRLChooser = DialogUtil.newURLChooser((Context)this._context);
        int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), "Resource Bundle");
        if (n == 0 && (uRL = uRLChooser.getSelectedURL()) != null) {
            String string = URLFileSystem.getPlatformPathName((URL)uRL);
            this._resCombo.setSelectedItem(string);
        }
    }

    public URL getResUrl() {
        URL uRL = null;
        Object object = this._resCombo.getSelectedItem();
        if (object != null) {
            String string = object.toString();
            uRL = URLFactory.newFileURL((String)string);
        }
        return uRL;
    }

    public String getResName() {
        return this._nameField.getText();
    }

    public String getResString() {
        return this._strField.getText();
    }

    static void mav$whenBrowse(ResourceDialog resourceDialog) {
        resourceDialog.whenBrowse();
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ResourceDialog.mav$whenBrowse(ResourceDialog.this);
        }
    }
}

