/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.safedelete;

import java.awt.Point;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.util.MultiMap;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.changes.DeleteNode;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;
import oracle.jdeveloper.refactoring.changes.TextChange;
import oracle.jdeveloper.refactoring.criteria.SafeDeleteClassesCriteria;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.TextChangeBasedRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.util.Helpers;
import oracle.jdevimpl.refactoring.handlers.JavaURLHelper;
import oracle.jdevimpl.refactoring.search.FindClassURLHandler;

public class SafeDeleteClassHandler
extends TextChangeBasedRefactoringHandler {
    private static final String KEY_RANGES_TO_DELETE = "RANGES_TO_DELETE";

    private boolean isMyType(SearchOperation searchOperation) {
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        return n == -2147483538;
    }

    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] projectArray = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        if (n == -2147483538) {
            SafeDeleteClassesCriteria safeDeleteClassesCriteria = (SafeDeleteClassesCriteria)searchCriteria;
            String[] stringArray = safeDeleteClassesCriteria.getFqClassNames();
            projectArray = SafeDeleteClassHandler.getIncludedProjects(searchOperation, stringArray);
        }
        return projectArray;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet hashSet = null;
        if (this.isMyType(searchOperation)) {
            SafeDeleteClassesCriteria safeDeleteClassesCriteria = (SafeDeleteClassesCriteria)searchOperation.getCriteria();
            JavaManager javaManager = JavaManager.getJavaManager(project);
            String[] stringArray = safeDeleteClassesCriteria.getFqClassNames();
            MultiMap multiMap = this.getRangesToDelete(searchOperation);
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                SourceClass sourceClass = javaManager.getSourceClass(string);
                if (sourceClass != null) {
                    String string2 = sourceClass.getName();
                    int n2 = string2.lastIndexOf(36);
                    string2 = string2.substring(n2 + 1);
                    HashSet hashSet2 = JavaURLHelper.getJavaURLsContaining(searchOperation, project, string2, false, false, progressIndicator);
                    if (hashSet == null) {
                        hashSet = new HashSet();
                    }
                    hashSet.addAll(hashSet2);
                    SourceFile sourceFile = sourceClass.getOwningSourceFile();
                    URL uRL = sourceFile.getURL();
                    int n3 = sourceClass.getStartOffset();
                    int n4 = sourceClass.getEndOffset();
                    this.addRangeToDelete(multiMap, uRL, n3, n4);
                }
                ++n;
            }
            searchOperation.setProperty(KEY_RANGES_TO_DELETE, multiMap);
        }
        return hashSet;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] uRLArray, ProgressIndicator progressIndicator) {
        UsageModel usageModel = new UsageModel();
        if (this.isMyType(searchOperation)) {
            SafeDeleteClassesCriteria safeDeleteClassesCriteria = (SafeDeleteClassesCriteria)searchOperation.getCriteria();
            JavaManager javaManager = JavaManager.getJavaManager(project);
            String[] stringArray = safeDeleteClassesCriteria.getFqClassNames();
            MultiMap multiMap = this.getRangesToDelete(searchOperation);
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                SourceClass sourceClass = javaManager.getSourceClass(string);
                if (sourceClass != null) {
                    UsageModel usageModel2 = FindClassURLHandler.searchClass(progressIndicator, project, uRLArray, string, true, true, true, true, true, false, false);
                    ArrayList arrayList = usageModel2.getUsageEntries();
                    int n2 = 0;
                    while (n2 < arrayList.size()) {
                        int n3;
                        UsageEntry usageEntry = (UsageEntry)arrayList.get(n2);
                        TextNode textNode = usageEntry.getTextNode();
                        URL uRL = textNode.getURL();
                        if (!this.isInRangeToDelete(multiMap, uRL, n3 = usageEntry.getOffset())) {
                            usageModel.addUsageEntry(usageEntry);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return usageModel;
    }

    public RefactoringChange[] getChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        RefactoringChange[] refactoringChangeArray = new RefactoringChange[]{};
        if (this.isMyType(searchOperation)) {
            SafeDeleteClassesCriteria safeDeleteClassesCriteria = (SafeDeleteClassesCriteria)searchOperation.getCriteria();
            ArrayList<URL> arrayList = new ArrayList<URL>();
            String[] stringArray = safeDeleteClassesCriteria.getFqClassNames();
            ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(stringArray));
            JavaManager javaManager = JavaManager.getJavaManager(project);
            MultiMap multiMap = this.getRangesToDelete(searchOperation);
            Set set = multiMap.keySet();
            for (URL uRL : set) {
                SourceFile sourceFile = javaManager.getSourceFile(uRL);
                List list = sourceFile.getSourceClasses();
                boolean bl = true;
                for (SourceClass sourceClass : list) {
                    String string = sourceClass.getQualifiedName();
                    if (arrayList2.contains(string)) continue;
                    bl = false;
                }
                if (!bl) continue;
                arrayList.add(uRL);
                for (SourceClass sourceClass : list) {
                    String string = sourceClass.getQualifiedName();
                    arrayList2.remove(string);
                }
            }
            ArrayList<RefactoringChange> arrayList3 = new ArrayList<RefactoringChange>();
            int n = 0;
            while (n < arrayList.size()) {
                URL uRL = (URL)arrayList.get(n);
                DeleteNode deleteNode = new DeleteNode(project, uRL);
                arrayList3.add(deleteNode);
                ++n;
            }
            int n2 = 0;
            while (n2 < arrayList2.size()) {
                String string = arrayList2.get(n2);
                SourceClass sourceClass = javaManager.getSourceClass(string);
                URL uRL = sourceClass.getOwningSourceFile().getURL();
                TextNode textNode = (TextNode)NodeFactory.find((URL)uRL);
                int n3 = sourceClass.getStartOffset();
                int n4 = sourceClass.getEndOffset();
                TextChange textChange = new TextChange(textNode, n3, n4, "", true);
                arrayList3.add(textChange);
                ++n2;
            }
            refactoringChangeArray = arrayList3.toArray(new RefactoringChange[arrayList3.size()]);
            int n5 = 0;
            while (n5 < arrayList.size()) {
                URL uRL = (URL)arrayList.get(n5);
                Helpers.removeClasses(project, uRL);
                ++n5;
            }
        }
        return refactoringChangeArray;
    }

    private boolean isInRangeToDelete(MultiMap multiMap, URL uRL, int n) {
        List list = multiMap.get((Object)uRL);
        if (list != null) {
            int n2 = 0;
            while (n2 < list.size()) {
                Point point = (Point)list.get(n2);
                if (point.x <= n && n <= point.y) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void addRangeToDelete(MultiMap multiMap, URL uRL, int n, int n2) {
        Point point;
        List list = multiMap.getOrCreate((Object)uRL);
        if (!list.contains(point = new Point(n, n2))) {
            list.add(point);
        }
    }

    private MultiMap getRangesToDelete(SearchOperation searchOperation) {
        MultiMap multiMap = (MultiMap)searchOperation.getProperty(KEY_RANGES_TO_DELETE);
        if (multiMap == null) {
            multiMap = new MultiMap();
        }
        return multiMap;
    }
}

