/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.safedelete;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.JDialog;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.criteria.SafeDeleteClassesCriteria;
import oracle.jdeveloper.refactoring.criteria.SafeDeleteFieldCriteria;
import oracle.jdeveloper.refactoring.criteria.SafeDeleteMethodCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.refactoring.model.FieldDescription;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchResults;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.oprs.safedelete.SafeDeleteFailedDialog;
import oracle.jdevimpl.refactoring.preview.UsagesLogPage;

public class SafeDeleteController
implements Controller {
    public boolean update(IdeAction ideAction, Context context) {
        ElementAt elementAt;
        boolean bl = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null && (elementAt = ElementAt.findElementAt(context)) != null) {
            switch (elementAt.getElementType()) {
                case 1: 
                case 3: 
                case 4: 
                case 7: {
                    SourceFile sourceFile;
                    URL uRL;
                    SourceElement sourceElement = elementAt.getSourceElement();
                    if (sourceElement == null || !Util.canRefactor(uRL = (sourceFile = sourceElement.getOwningSourceFile()).getURL())) break;
                    bl = true;
                }
            }
        }
        ideAction.setEnabled(bl);
        return true;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        ElementAt elementAt = ElementAt.findElementAt(context);
        if (elementAt != null) {
            switch (elementAt.getElementType()) {
                case 1: {
                    SourceClass sourceClass = (SourceClass)elementAt.getSourceElement();
                    SafeDeleteController.whenSafeDeleteClass(context, sourceClass);
                    bl = true;
                    break;
                }
                case 3: {
                    SourceMethod sourceMethod = (SourceMethod)elementAt.getSourceElement();
                    SafeDeleteController.whenSafeDeleteMethod(context, sourceMethod);
                    bl = true;
                    break;
                }
                case 4: 
                case 7: {
                    SourceMemberVariable sourceMemberVariable = (SourceMemberVariable)elementAt.getSourceElement();
                    SafeDeleteController.whenSafeDeleteField(context, sourceMemberVariable);
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static boolean canSafeDeleteFiles(Context context, URL[] uRLArray) {
        int n = 0;
        while (n < uRLArray.length) {
            URL uRL = uRLArray[n];
            if (!Util.isJavaSource(uRL)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean safeDeleteFiles(Context context, URL[] uRLArray) {
        Project project = context.getProject();
        JavaManager javaManager = JavaManager.getJavaManager(project);
        ArrayList<SourceClass> arrayList = new ArrayList<SourceClass>();
        int n = 0;
        while (n < uRLArray.length) {
            SourceFile sourceFile;
            URL uRL = uRLArray[n];
            if (Util.isJavaSource(uRL) && (sourceFile = javaManager.getSourceFile(uRL)) != null) {
                List list = sourceFile.getSourceClasses();
                int n2 = 0;
                while (n2 < list.size()) {
                    SourceClass sourceClass = (SourceClass)list.get(n2);
                    arrayList.add(sourceClass);
                    ++n2;
                }
            }
            ++n;
        }
        SourceClass[] sourceClassArray = arrayList.toArray(new SourceClass[arrayList.size()]);
        return SafeDeleteController.doSafeDelete(context, uRLArray, sourceClassArray);
    }

    public static boolean safeDeleteClasses(Context context, SourceClass[] sourceClassArray) {
        boolean bl = false;
        if (sourceClassArray.length != 0) {
            HashSet<URL> hashSet = new HashSet<URL>(sourceClassArray.length);
            int n = 0;
            while (n < sourceClassArray.length) {
                SourceClass sourceClass = sourceClassArray[n];
                SourceFile sourceFile = sourceClass.getOwningSourceFile();
                URL uRL = sourceFile.getURL();
                hashSet.add(uRL);
                ++n;
            }
            JavaManager javaManager = JavaManager.getJavaManager(context.getProject());
            HashSet<SourceClass> hashSet2 = new HashSet<SourceClass>(Arrays.asList(sourceClassArray));
            HashSet<URL> hashSet3 = new HashSet<URL>(hashSet);
            for (URL uRL : hashSet) {
                boolean bl2 = true;
                SourceFile sourceFile = javaManager.getSourceFile(uRL);
                List list = sourceFile.getSourceClasses();
                int n2 = 0;
                while (!bl2 && n2 < list.size()) {
                    SourceClass sourceClass = (SourceClass)list.get(n2);
                    if (!hashSet2.contains(sourceClass)) {
                        bl2 = false;
                    }
                    ++n2;
                }
                if (!bl2) continue;
                hashSet3.add(uRL);
            }
            URL[] uRLArray = hashSet3.toArray(new URL[hashSet3.size()]);
            bl = SafeDeleteController.doSafeDelete(context, uRLArray, sourceClassArray);
        }
        return bl;
    }

    private static void whenSafeDeleteClass(Context context, SourceClass sourceClass) {
        SourceFile sourceFile = sourceClass.getOwningSourceFile();
        SourceClass sourceClass2 = sourceFile.getSourcePrimaryClass();
        if (sourceClass2 == sourceClass) {
            SafeDeleteController.doSafeDelete(context, sourceFile);
        } else {
            SafeDeleteController.doSafeDelete(context, new URL[0], new SourceClass[]{sourceClass});
        }
    }

    private static boolean doSafeDelete(Context context, SourceFile sourceFile) {
        ArrayList<SourceClass> arrayList = new ArrayList<SourceClass>();
        List list = sourceFile.getSourceClasses();
        for (SourceClass sourceClass : list) {
            arrayList.add(sourceClass);
        }
        SourceClass[] sourceClassArray = arrayList.toArray(new SourceClass[arrayList.size()]);
        URL[] uRLArray = new URL[]{sourceFile.getURL()};
        return SafeDeleteController.doSafeDelete(context, uRLArray, sourceClassArray);
    }

    public static boolean whenSafeDeleteMethod(Context context, SourceMethod sourceMethod) {
        MethodDescription methodDescription = new MethodDescription((JavaMethod)sourceMethod);
        SafeDeleteMethodCriteria safeDeleteMethodCriteria = new SafeDeleteMethodCriteria(methodDescription);
        SearchOperationImpl searchOperationImpl = new SearchOperationImpl(context, safeDeleteMethodCriteria);
        Util.setOperationHints(searchOperationImpl, (JavaMember)sourceMethod, false);
        return SafeDeleteController.doSafeDelete(searchOperationImpl, safeDeleteMethodCriteria);
    }

    public static boolean whenSafeDeleteField(Context context, SourceMemberVariable sourceMemberVariable) {
        FieldDescription fieldDescription = new FieldDescription((JavaField)sourceMemberVariable);
        SafeDeleteFieldCriteria safeDeleteFieldCriteria = new SafeDeleteFieldCriteria(fieldDescription);
        SearchOperationImpl searchOperationImpl = new SearchOperationImpl(context, safeDeleteFieldCriteria);
        Util.setOperationHints(searchOperationImpl, (JavaMember)sourceMemberVariable, false);
        return SafeDeleteController.doSafeDelete(searchOperationImpl, safeDeleteFieldCriteria);
    }

    private static boolean doSafeDelete(Context context, URL[] uRLArray, SourceClass[] sourceClassArray) {
        int n = sourceClassArray.length;
        ClassDescription[] classDescriptionArray = new ClassDescription[n];
        int n2 = 0;
        while (n2 < n) {
            SourceClass sourceClass = sourceClassArray[n2];
            classDescriptionArray[n2] = ClassDescription.createClassDescription((JavaClass)sourceClass);
            ++n2;
        }
        SafeDeleteClassesCriteria safeDeleteClassesCriteria = new SafeDeleteClassesCriteria(uRLArray, classDescriptionArray);
        SearchOperationImpl searchOperationImpl = new SearchOperationImpl(context, safeDeleteClassesCriteria);
        boolean bl = SafeDeleteController.doSafeDelete(searchOperationImpl, safeDeleteClassesCriteria);
        return bl;
    }

    private static boolean doSafeDelete(SearchOperationImpl searchOperationImpl, SearchCriteria searchCriteria) {
        SearchResults searchResults = searchOperationImpl.search();
        if (searchResults != null) {
            UsageModel usageModel = searchResults.getUsageModel();
            ArrayList arrayList = usageModel.getUsageEntries();
            if (arrayList.isEmpty()) {
                return searchOperationImpl.doRefactoring();
            }
            String string = searchCriteria.getLongTitle();
            SafeDeleteFailedDialog safeDeleteFailedDialog = new SafeDeleteFailedDialog(string);
            if (WizardLauncher.runDialog((JDialog)((Object)safeDeleteFailedDialog))) {
                if (safeDeleteFailedDialog.isIgnorePressed()) {
                    return searchOperationImpl.doRefactoring();
                }
                UsagesLogPage.showUsages(searchOperationImpl, false);
                return false;
            }
        }
        return false;
    }
}

