/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.safedelete;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInfixExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;
import oracle.jdeveloper.refactoring.changes.TextChange;
import oracle.jdeveloper.refactoring.criteria.SafeDeleteFieldCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchFieldCriteria;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;
import oracle.jdeveloper.refactoring.model.FieldDescription;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.TextChangeBasedRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdevimpl.refactoring.handlers.MemberURLHelperJot;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.oprs.rename.member.RenameFieldURLHandler;
import oracle.jdevimpl.refactoring.util.Visitor;

public class SafeDeleteFieldHandler
extends TextChangeBasedRefactoringHandler {
    private static final String KEY_WRITE_USAGES = "WRITE_USAGES";

    private boolean isMyType(SearchOperation searchOperation) {
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        return n == -2147483536;
    }

    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] projectArray = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        if (n == -2147483536) {
            SafeDeleteFieldCriteria safeDeleteFieldCriteria = (SafeDeleteFieldCriteria)searchCriteria;
            String string = safeDeleteFieldCriteria.getClassName();
            projectArray = SafeDeleteFieldHandler.getIncludedProjects(searchOperation, string);
        }
        return projectArray;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet hashSet = null;
        if (this.isMyType(searchOperation)) {
            SafeDeleteFieldCriteria safeDeleteFieldCriteria = (SafeDeleteFieldCriteria)searchOperation.getCriteria();
            FieldDescription fieldDescription = safeDeleteFieldCriteria.getFieldDescription();
            JavaManager javaManager = JavaManager.getJavaManager(project);
            JavaField javaField = fieldDescription.getJavaField(javaManager);
            hashSet = MemberURLHelperJot.chooseURLs(searchOperation, project, progressIndicator, (JavaMember)javaField, false, false);
        }
        return hashSet;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] uRLArray, ProgressIndicator progressIndicator) {
        UsageModel usageModel = new UsageModel();
        if (this.isMyType(searchOperation)) {
            SafeDeleteFieldCriteria safeDeleteFieldCriteria = (SafeDeleteFieldCriteria)searchOperation.getCriteria();
            FieldDescription fieldDescription = safeDeleteFieldCriteria.getFieldDescription();
            SearchFieldCriteria searchFieldCriteria = new SearchFieldCriteria(fieldDescription, false);
            JavaManager javaManager = JavaManager.getJavaManager(project);
            UsageModel usageModel2 = RenameFieldURLHandler.findUsages(project, uRLArray, progressIndicator, searchFieldCriteria.getFieldDescription(), searchFieldCriteria.isSearchInComments());
            ArrayList arrayList = usageModel2.getUsageEntries();
            ArrayList arrayList2 = this.getWriteUsages(searchOperation, project);
            int n = 0;
            while (n < arrayList.size()) {
                BaseUsageEntry baseUsageEntry = (BaseUsageEntry)arrayList.get(n);
                int n2 = baseUsageEntry.getUsageType();
                switch (n2) {
                    case 201: {
                        break;
                    }
                    default: {
                        SourceExpression sourceExpression;
                        SourceInfixExpression sourceInfixExpression;
                        SourceElement sourceElement;
                        URL uRL = baseUsageEntry.getURL();
                        SourceFile sourceFile = javaManager.getSourceFile(uRL);
                        int n3 = baseUsageEntry.getOffset();
                        boolean bl = false;
                        SourceElement sourceElement2 = sourceFile.getElementAt(n3);
                        if (sourceElement2 != null && (sourceElement = sourceElement2.getParent()) != null && (sourceInfixExpression = this.getParentAssigment(sourceElement)) != null && Patch.contains((SourceElement)(sourceExpression = sourceInfixExpression.getFirstOperand()), sourceElement2)) {
                            arrayList2.add(sourceInfixExpression);
                            bl = true;
                        }
                        if (bl) break;
                        usageModel.addUsageEntry(baseUsageEntry);
                    }
                }
                ++n;
            }
            this.setWriteUsages(searchOperation, project, arrayList2);
        }
        return usageModel;
    }

    private SourceInfixExpression getParentAssigment(SourceElement sourceElement) {
        while (sourceElement != null) {
            SourceInfixExpression sourceInfixExpression;
            int n;
            int n2 = sourceElement.getSymbolKind();
            if (n2 == 51 && Patch.isAssignment(n = (sourceInfixExpression = (SourceInfixExpression)sourceElement).getOperatorCode())) {
                return sourceInfixExpression;
            }
            sourceElement = sourceElement.getParent();
        }
        return null;
    }

    private void setWriteUsages(SearchOperation searchOperation, Project project, ArrayList arrayList) {
        HashMap<Project, ArrayList> hashMap = (HashMap<Project, ArrayList>)searchOperation.getProperty(KEY_WRITE_USAGES);
        if (hashMap == null) {
            hashMap = new HashMap<Project, ArrayList>();
            searchOperation.setProperty(KEY_WRITE_USAGES, hashMap);
        }
        hashMap.put(project, arrayList);
    }

    private ArrayList getWriteUsages(SearchOperation searchOperation, Project project) {
        ArrayList arrayList = null;
        HashMap hashMap = (HashMap)searchOperation.getProperty(KEY_WRITE_USAGES);
        if (hashMap != null) {
            arrayList = (ArrayList)hashMap.get(project);
        }
        return arrayList == null ? new ArrayList() : arrayList;
    }

    public RefactoringChange[] getChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        RefactoringChange[] refactoringChangeArray = new RefactoringChange[]{};
        if (this.isMyType(searchOperation)) {
            JavaManager javaManager;
            ArrayList arrayList = new ArrayList();
            SafeDeleteFieldCriteria safeDeleteFieldCriteria = (SafeDeleteFieldCriteria)searchOperation.getCriteria();
            FieldDescription fieldDescription = safeDeleteFieldCriteria.getFieldDescription();
            JavaField javaField = fieldDescription.getJavaField(javaManager = JavaManager.getJavaManager(project));
            SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)javaField.getSourceElement();
            if (sourceFieldVariable != null) {
                SourceFile sourceFile = sourceFieldVariable.getOwningSourceFile();
                URL uRL = sourceFile.getURL();
                try {
                    TextNode textNode = (TextNode)NodeFactory.findOrCreate((URL)uRL);
                    if (project.containsChild((Element)textNode)) {
                        this.removeDeclarations(sourceFieldVariable, textNode, arrayList);
                        this.removeAssignments(searchOperation, project, textNode, arrayList);
                        refactoringChangeArray = arrayList.toArray(new RefactoringChange[arrayList.size()]);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return refactoringChangeArray;
    }

    private void removeAssignments(SearchOperation searchOperation, Project project, TextNode textNode, ArrayList arrayList) {
        ArrayList arrayList2 = this.getWriteUsages(searchOperation, project);
        int n = 0;
        while (n < arrayList2.size()) {
            boolean bl;
            int n2;
            int n3;
            SourceInfixExpression sourceInfixExpression = (SourceInfixExpression)arrayList2.get(n);
            SourceExpression sourceExpression = sourceInfixExpression.getFirstOperand();
            if (this.isConstExpression(sourceExpression)) {
                SourceElement sourceElement = sourceInfixExpression.getParent();
                if (sourceElement instanceof SourceStatement) {
                    SourceStatement sourceStatement = (SourceStatement)sourceElement;
                    n3 = sourceStatement.getStartOffset();
                    n2 = sourceStatement.getEndOffset();
                    bl = true;
                } else {
                    n3 = sourceInfixExpression.getStartOffset();
                    n2 = sourceExpression.getStartOffset();
                    bl = false;
                }
            } else {
                n3 = sourceInfixExpression.getStartOffset();
                n2 = sourceExpression.getStartOffset();
                bl = false;
            }
            TextChange textChange = new TextChange(textNode, n3, n2, "", bl);
            arrayList.add(textChange);
            ++n;
        }
    }

    private void removeDeclarations(SourceFieldVariable sourceFieldVariable, TextNode textNode, ArrayList arrayList) {
        boolean bl;
        int n;
        int n2;
        SourceFieldDeclaration sourceFieldDeclaration = (SourceFieldDeclaration)sourceFieldVariable.getParent();
        List list = sourceFieldDeclaration.getVariables();
        SourceVariable[] sourceVariableArray = list.toArray(new SourceVariable[list.size()]);
        if (list.size() == 1) {
            n2 = sourceFieldDeclaration.getEndOffset();
            Object var10_8 = null;
            n = var10_8 != null ? var10_8.getStartOffset() : sourceFieldDeclaration.getStartOffset();
            bl = true;
        } else {
            if (sourceVariableArray[0] == sourceFieldVariable) {
                n = sourceVariableArray[0].getStartOffset();
                n2 = sourceVariableArray[1].getStartOffset();
            } else {
                int n3 = Arrays.asList(sourceVariableArray).indexOf(sourceFieldVariable);
                n = sourceVariableArray[n3 - 1].getEndOffset();
                n2 = sourceVariableArray[n3].getEndOffset();
            }
            bl = false;
        }
        TextChange textChange = new TextChange(textNode, n, n2, "", bl);
        arrayList.add(textChange);
    }

    private boolean isConstExpression(SourceExpression sourceExpression) {
        1 var2_2 = new 1();
        var2_2.visit((SourceElement)sourceExpression);
        return var2_2.getUserData() == Boolean.TRUE;
    }

    public final class 1
    extends Visitor {
        void $init$() {
            this.setUserData(Boolean.TRUE);
        }

        protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
            this.setNotConst();
        }

        protected void whenEnterInfixExpression(SourceInfixExpression sourceInfixExpression) {
            int n = sourceInfixExpression.getOperatorCode();
            if (Patch.isAssignment(n)) {
                this.setNotConst();
            }
        }

        private void setNotConst() {
            this.setUserData(Boolean.FALSE);
            this.skipChildren();
        }

        public 1() {
            this.$init$();
        }
    }
}

