/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.safedelete;

import java.awt.Point;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.util.MultiMap;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;
import oracle.jdeveloper.refactoring.changes.TextChange;
import oracle.jdeveloper.refactoring.criteria.SafeDeleteMethodCriteria;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.TextChangeBasedRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdevimpl.refactoring.handlers.MemberURLHelperJot;
import oracle.jdevimpl.refactoring.oprs.rename.member.RenameMethodURLHandler;

public class SafeDeleteMethodHandler
extends TextChangeBasedRefactoringHandler {
    private static final String KEY_RANGES_TO_DELETE = "RANGES_TO_DELETE";

    private boolean isMyType(SearchOperation searchOperation) {
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        return n == -2147483537;
    }

    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] projectArray = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        if (n == -2147483537) {
            SafeDeleteMethodCriteria safeDeleteMethodCriteria = (SafeDeleteMethodCriteria)searchCriteria;
            String string = safeDeleteMethodCriteria.getClassName();
            projectArray = SafeDeleteMethodHandler.getIncludedProjects(searchOperation, string);
        }
        return projectArray;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet hashSet = null;
        if (this.isMyType(searchOperation)) {
            SourceMethod sourceMethod;
            SafeDeleteMethodCriteria safeDeleteMethodCriteria = (SafeDeleteMethodCriteria)searchOperation.getCriteria();
            JavaManager javaManager = JavaManager.getJavaManager(project);
            MultiMap multiMap = this.getRangesToDelete(searchOperation);
            MethodDescription methodDescription = safeDeleteMethodCriteria.getMethodDescription();
            JavaMethod javaMethod = methodDescription.getJavaMethod(javaManager);
            if (javaMethod != null && (sourceMethod = (SourceMethod)javaMethod.getSourceElement()) != null) {
                hashSet = MemberURLHelperJot.chooseURLs(searchOperation, project, progressIndicator, (JavaMember)javaMethod, false, false);
                HashSet hashSet2 = this.chooseImplementedInterfacesURLs(javaManager, safeDeleteMethodCriteria);
                hashSet.addAll(hashSet2);
                int n = sourceMethod.getStartOffset();
                int n2 = sourceMethod.getEndOffset();
                SourceFile sourceFile = sourceMethod.getOwningSourceFile();
                URL uRL = sourceFile.getURL();
                this.addRangeToDelete(multiMap, uRL, n, n2);
                searchOperation.setProperty(KEY_RANGES_TO_DELETE, multiMap);
            }
        }
        return hashSet;
    }

    private HashSet chooseImplementedInterfacesURLs(JavaManager javaManager, SafeDeleteMethodCriteria safeDeleteMethodCriteria) {
        HashSet hashSet = this.getImplementedInterfaceMethods(safeDeleteMethodCriteria, javaManager);
        HashSet<URL> hashSet2 = new HashSet<URL>();
        for (SourceMethod sourceMethod : hashSet) {
            SourceFile sourceFile = sourceMethod.getOwningSourceFile();
            URL uRL = sourceFile.getURL();
            hashSet2.add(uRL);
        }
        return hashSet2;
    }

    private HashSet getImplementedInterfaceMethods(SafeDeleteMethodCriteria safeDeleteMethodCriteria, JavaManager javaManager) {
        HashSet<SourceElement> hashSet = new HashSet<SourceElement>(0);
        MethodDescription methodDescription = safeDeleteMethodCriteria.getMethodDescription();
        JavaMethod javaMethod = methodDescription.getJavaMethod(javaManager);
        Collection collection = javaMethod.getOverriddenMethods();
        for (JavaMethod javaMethod2 : collection) {
            SourceElement sourceElement = javaMethod2.getSourceElement();
            hashSet.add(sourceElement);
        }
        return hashSet;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] uRLArray, ProgressIndicator progressIndicator) {
        UsageModel usageModel = new UsageModel();
        if (this.isMyType(searchOperation)) {
            SafeDeleteMethodCriteria safeDeleteMethodCriteria = (SafeDeleteMethodCriteria)searchOperation.getCriteria();
            MultiMap multiMap = this.getRangesToDelete(searchOperation);
            MethodDescription methodDescription = safeDeleteMethodCriteria.getMethodDescription();
            UsageModel usageModel2 = RenameMethodURLHandler.searchMethod(project, uRLArray, progressIndicator, methodDescription, true);
            ArrayList arrayList = usageModel2.getUsageEntries();
            int n = 0;
            while (n < arrayList.size()) {
                int n2;
                BaseUsageEntry baseUsageEntry = (BaseUsageEntry)arrayList.get(n);
                URL uRL = baseUsageEntry.getURL();
                if (!this.isInRangeToDelete(multiMap, uRL, n2 = baseUsageEntry.getOffset())) {
                    usageModel.addUsageEntry(baseUsageEntry);
                }
                ++n;
            }
            JavaManager javaManager = JavaManager.getJavaManager(project);
            HashSet hashSet = this.getImplementedInterfaceMethods(safeDeleteMethodCriteria, javaManager);
            for (SourceMethod sourceMethod : hashSet) {
                URL uRL = sourceMethod.getOwningSourceFile().getURL();
                int n3 = sourceMethod.getStartOffset();
                int n4 = sourceMethod.getEndOffset();
                UsageEntry usageEntry = new UsageEntry(project, uRL, n3, n4 - n3, 0, 2);
                usageModel.addUsageEntry(usageEntry);
            }
        }
        return usageModel;
    }

    public RefactoringChange[] getChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        RefactoringChange[] refactoringChangeArray = new RefactoringChange[]{};
        if (this.isMyType(searchOperation)) {
            SafeDeleteMethodCriteria safeDeleteMethodCriteria = (SafeDeleteMethodCriteria)searchOperation.getCriteria();
            JavaManager javaManager = JavaManager.getJavaManager(project);
            MethodDescription methodDescription = safeDeleteMethodCriteria.getMethodDescription();
            JavaMethod javaMethod = methodDescription.getJavaMethod(javaManager);
            SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
            SourceFile sourceFile = sourceMethod.getOwningSourceFile();
            URL uRL = sourceFile.getURL();
            try {
                TextNode textNode = (TextNode)NodeFactory.findOrCreate((URL)uRL);
                if (project.containsChild((Element)textNode)) {
                    int n = sourceMethod.getStartOffset();
                    int n2 = sourceMethod.getEndOffset();
                    TextChange textChange = new TextChange(textNode, n, n2, "", true);
                    refactoringChangeArray = new RefactoringChange[]{textChange};
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return refactoringChangeArray;
    }

    private boolean isInRangeToDelete(MultiMap multiMap, URL uRL, int n) {
        List list = multiMap.get((Object)uRL);
        if (list != null) {
            int n2 = 0;
            while (n2 < list.size()) {
                Point point = (Point)list.get(n2);
                if (point.x <= n && n <= point.y) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void addRangeToDelete(MultiMap multiMap, URL uRL, int n, int n2) {
        Point point;
        List list = multiMap.getOrCreate((Object)uRL);
        if (!list.contains(point = new Point(n, n2))) {
            list.add(point);
        }
    }

    private MultiMap getRangesToDelete(SearchOperation searchOperation) {
        MultiMap multiMap = (MultiMap)searchOperation.getProperty(KEY_RANGES_TO_DELETE);
        if (multiMap == null) {
            multiMap = new MultiMap();
        }
        return multiMap;
    }
}

