/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.usersupertype;

import java.awt.Component;
import java.util.Iterator;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.MessageDialog;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.jdeveloper.refactoring.criteria.UseSupertypeCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.oprs.usersupertype.UseSupertypeDialog;

public class UseSupertypeController
implements Controller {
    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = UseSupertypeController.handle(context, false);
        ideAction.setEnabled(bl);
        return true;
    }

    public static boolean canUseSupertype(Context context, SourceClass sourceClass) {
        return UseSupertypeController.handle(context, sourceClass, false);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        UseSupertypeController.handle(context, true);
        return true;
    }

    public static void whenUseSupertype(Context context, SourceClass sourceClass) {
        UseSupertypeController.handle(context, sourceClass, true);
    }

    private static boolean handle(Context context, boolean bl) {
        boolean bl2 = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null) {
            SourceClass sourceClass = ElementAt.getSourceClassAt(context, false, false);
            bl2 = UseSupertypeController.handle(context, sourceClass, bl);
        }
        return bl2;
    }

    private static boolean handle(Context context, SourceClass sourceClass, boolean bl) {
        boolean bl2 = false;
        if (sourceClass != null && !sourceClass.isAnnotation() && !sourceClass.isAnonymous() && Util.canRefactor((SourceElement)sourceClass)) {
            bl2 = true;
            if (bl) {
                boolean bl3 = false;
                Set set = sourceClass.getHierarchy();
                Iterator iterator = set.iterator();
                while (!bl3 && iterator.hasNext()) {
                    JavaClass javaClass = (JavaClass)iterator.next();
                    SourceElement sourceElement = javaClass.getSourceElement();
                    if (sourceElement == null || !Util.canRefactor(sourceElement)) continue;
                    bl3 = true;
                }
                if (bl3) {
                    UseSupertypeDialog useSupertypeDialog = new UseSupertypeDialog(context, sourceClass);
                    if (useSupertypeDialog.runDialog()) {
                        boolean bl4 = useSupertypeDialog.hasPreview();
                        String string = useSupertypeDialog.getSelectedType();
                        JavaProvider javaProvider = sourceClass.getOwningSourceFile().getProvider();
                        SourceClass sourceClass2 = javaProvider.getSourceClass(string);
                        if (sourceClass2 != null) {
                            UseSupertypeController.whenUseSupertype(context, sourceClass, sourceClass2, bl4);
                        }
                    }
                } else {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)RefactoringArb.getString(195), (String)RefactoringArb.getString(196), null);
                }
            }
        }
        return bl2;
    }

    public static void whenUseSupertype(Context context, SourceClass sourceClass, SourceClass sourceClass2, boolean bl) {
        UseSupertypeCriteria useSupertypeCriteria = new UseSupertypeCriteria(ClassDescription.createClassDescription((JavaClass)sourceClass), ClassDescription.createClassDescription((JavaClass)sourceClass2));
        SearchOperationImpl searchOperationImpl = new SearchOperationImpl(context, useSupertypeCriteria);
        searchOperationImpl.runRefactoring(bl);
    }
}

