/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.usersupertype;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.dialogs.BaseDialog;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;

public class UseSupertypeDialog
extends BaseDialog {
    private static final String PREFERENCE_KEY = "USE_SUPERTYPE_PREF";
    private static final int PREF_PREVIEW = 1;
    private SourceClass _sourceClass;
    private JList _baseTypes;
    private JCheckBox _preview;

    public UseSupertypeDialog(Context context, SourceClass sourceClass) {
        super(PREFERENCE_KEY, context);
        this._sourceClass = sourceClass;
        this.init();
    }

    protected String getTitle() {
        return RefactoringArb.getString(93);
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    protected void updateOKButton() {
        boolean bl = true;
        if (this._baseTypes.getSelectedValue() == null) {
            bl = false;
        }
        this.setOKButtonEnabled(bl);
    }

    protected void updateSettings(CopyableInteger copyableInteger) {
        copyableInteger.setBit(1, this.hasPreview());
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._baseTypes;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dgeneralizedecl_html";
    }

    private void init() {
        JLabel jLabel = new JLabel();
        ArrayList arrayList = this.getBaseTypeNames();
        this._baseTypes = new JList<Object>(arrayList.toArray(new Object[arrayList.size()]));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._baseTypes, (String)RefactoringArb.getString(95));
        this._baseTypes.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this._baseTypes);
        if (!arrayList.isEmpty()) {
            this._baseTypes.setSelectedIndex(0);
        }
        String string = RefactoringArb.getString(96);
        this._preview = new JCheckBox(StringUtils.stripMnemonic((String)string));
        Util.setMnemonic(this._preview, string);
        this._preview.setSelected(this.getSettings().isBitSet(1));
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        this.add((Component)this._preview, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
    }

    private ArrayList getBaseTypeNames() {
        Set set = this._sourceClass.getHierarchy();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this._sourceClass.getName();
        for (JavaType javaType : set) {
            String string2;
            SourceClass sourceClass = (SourceClass)javaType.getSourceElement();
            if (sourceClass == null || string.equals(string2 = sourceClass.getQualifiedName()) || sourceClass.getSuperclass() == null) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public String getSelectedType() {
        Object e = this._baseTypes.getSelectedValue();
        return (String)e;
    }

    public boolean hasPreview() {
        return this._preview.isSelected();
    }
}

