/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.preview;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.preview.UsageSource;
import oracle.jdevimpl.refactoring.preview.UsagesLogPage;
import oracle.jdevimpl.refactoring.preview.model.UsageNode;
import oracle.jdevimpl.refactoring.preview.model.UsagesLeaf;

public class PreviewLogPage
extends UsagesLogPage
implements ActionListener,
Controller {
    public Icon getTabIcon() {
        return RefactoringArb.getIcon(22);
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_jrf_preview_log_html");
    }

    public static boolean showUsages(UsageSource usageSource) {
        PreviewLogPage previewLogPage = new PreviewLogPage();
        previewLogPage.setUsageSource(usageSource);
        return previewLogPage.showPage();
    }

    protected void whenDoit() {
        UsageSource usageSource = this.getUsageSource();
        usageSource.doRefactoring();
        this.closePage();
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n != UsagesLogPage.DO_REFACTORING_CMD_ID) {
            return super.handleEvent(ideAction, context);
        }
        this.whenDoit();
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n != UsagesLogPage.DO_REFACTORING_CMD_ID) {
            return super.update(ideAction, context);
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)object;
            String string = jMenuItem.getText();
            if (StringUtils.stripMnemonic((String)RefactoringArb.getString(30)).equals(string)) {
                this.setIncludedState(true);
                return;
            }
            if (StringUtils.stripMnemonic((String)RefactoringArb.getString(32)).equals(string)) {
                this.setIncludedState(false);
                return;
            }
        }
    }

    protected final void setIncludedState(boolean bl) {
        ArrayList arrayList = this.getSelectedLeafNodes();
        int n = 0;
        while (n < arrayList.size()) {
            UsageNode usageNode = (UsageNode)arrayList.get(n);
            UsagesLeaf usagesLeaf = (UsagesLeaf)usageNode.getUserObject();
            usagesLeaf.setIncludedStates(bl);
            ++n;
        }
        JTree jTree = this.getTree();
        jTree.repaint();
    }

    protected Toolbar createToolbar() {
        Toolbar toolbar = new Toolbar();
        this.addRefreshButton(toolbar);
        this.addRunButton(toolbar);
        this.addShowMatchButton(toolbar);
        return toolbar;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        ArrayList arrayList = this.getSelectedLeafNodes();
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        while (n < arrayList.size() && bl) {
            UsageNode usageNode = (UsageNode)arrayList.get(n);
            Object object = usageNode.getUserObject();
            if (object instanceof UsagesLeaf) {
                UsagesLeaf usagesLeaf = (UsagesLeaf)object;
                bl2 = true;
                boolean bl5 = usagesLeaf.areAllValid();
                if (bl5) {
                    boolean bl6;
                    boolean bl7 = usagesLeaf.hasIncludedChanges();
                    if (bl7) {
                        bl3 = true;
                    }
                    if (bl6 = usagesLeaf.hasExcludedChanges()) {
                        bl4 = true;
                    }
                } else {
                    bl = false;
                }
            }
            ++n;
        }
        if (bl2) {
            if (bl4) {
                JMenuItem jMenuItem = new JMenuItem(RefactoringArb.getIcon(31));
                ResourceUtils.resButton((AbstractButton)jMenuItem, (String)RefactoringArb.getString(30));
                jMenuItem.addActionListener(this);
                contextMenu.add((Component)jMenuItem);
            }
            if (bl3) {
                JMenuItem jMenuItem = new JMenuItem(RefactoringArb.getIcon(33));
                ResourceUtils.resButton((AbstractButton)jMenuItem, (String)RefactoringArb.getString(32));
                jMenuItem.addActionListener(this);
                contextMenu.add((Component)jMenuItem);
            }
        }
        if (contextMenu.getMenuCount() != 0) {
            contextMenu.add((Component)new JSeparator());
        }
        super.menuWillShow(contextMenu);
    }

    private ArrayList getSelectedLeafNodes() {
        ArrayList<UsageNode> arrayList = new ArrayList<UsageNode>();
        JTree jTree = this.getTree();
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray != null) {
            LinkedList<TreeNode> linkedList = new LinkedList<TreeNode>();
            int n = 0;
            while (n < treePathArray.length) {
                TreePath treePath = treePathArray[n];
                UsageNode usageNode = (UsageNode)treePath.getLastPathComponent();
                linkedList.add(usageNode);
                ++n;
            }
            while (!linkedList.isEmpty()) {
                UsageNode usageNode = (UsageNode)linkedList.removeFirst();
                int n2 = usageNode.getChildCount();
                if (n2 == 0) {
                    arrayList.add(usageNode);
                    continue;
                }
                int n3 = 0;
                while (n3 < n2) {
                    TreeNode treeNode = usageNode.getChildAt(n3);
                    linkedList.add(treeNode);
                    ++n3;
                }
            }
        }
        return arrayList;
    }
}

