/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.preview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.dnd.InvalidDnDOperationException;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogWindow;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.MultiMap;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.RefactorAddin;
import oracle.jdevimpl.refactoring.preview.UsageCellRenderer;
import oracle.jdevimpl.refactoring.preview.UsageSource;
import oracle.jdevimpl.refactoring.preview.model.TreeBuilder;
import oracle.jdevimpl.refactoring.preview.model.UsageNode;
import oracle.jdevimpl.refactoring.preview.model.UsagesLeaf;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class UsagesLogPage
extends AbstractLogPage
implements ContextMenuListener,
DragSourceListener,
DragGestureListener,
PropertyChangeListener,
MouseListener,
TreeSelectionListener,
ChangeListener,
Controller {
    public static int DO_REFACTORING_CMD_ID;
    public static int SHOW_MATCH_CMD_ID;
    public static int LOCK_PAGE_CMD_ID;
    protected static int CREATE_WORKINGSET_CMD_ID;
    static final String VIEW_TYPE = "REFACTORING";
    static final String VIEW_ID = "PREVIEW";
    private static int _id;
    private UsageSource _usageSource;
    private static boolean _actionsCreated;
    private JPanel _ui;
    private UsageNode _root;
    private JTree _tree;
    private boolean _mergeJavaAndNonJavaFiles;
    private Toolbar _toolbar;
    private ToggleToolButton _showMatchButton;
    private ToggleToolButton _lockPageButton;
    private ToolButton _runButton;
    private boolean _showMatchState;
    private boolean _lockPageState;
    private UsageModel _usageModel;

    void $init$() {
        this._mergeJavaAndNonJavaFiles = false;
    }

    protected UsagesLogPage() {
        super(new ViewId(VIEW_TYPE, VIEW_ID + ++_id), null, false);
        this.$init$();
        UsagesLogPage.createActions();
        this.init();
    }

    protected void setUsageSource(UsageSource usageSource) {
        this.setUsageModel(null);
        this._usageSource = usageSource;
        if (this._usageSource != null) {
            UsageModel usageModel = this._usageSource.getUsageModel();
            this.setUsageModel(usageModel);
        }
    }

    public UsageSource getUsageSource() {
        return this._usageSource;
    }

    public static boolean showUsages(UsageSource usageSource, boolean bl) {
        UsageModel usageModel = usageSource.getUsageModel();
        if (usageModel.getUsageEntries().size() != 0) {
            UsagesLogPage usagesLogPage = UsagesLogPage.findUsablePage(bl);
            usagesLogPage.setUsageSource(usageSource);
            return usagesLogPage.showPage();
        }
        MessageDialog.information((Component)Ide.getMainWindow(), (Object)RefactoringArb.getString(187), (String)RefactoringArb.getString(188), null);
        return true;
    }

    private static UsagesLogPage findUsablePage(boolean bl) {
        if (!bl) {
            LogManager logManager = LogManager.getLogManager();
            LogPage logPage = logManager.getSelectedPage();
            if (UsagesLogPage.isReusablePage(logPage)) {
                return (UsagesLogPage)logPage;
            }
            LogPage[] logPageArray = logManager.getPages();
            int n = 0;
            while (n < logPageArray.length) {
                LogPage logPage2 = logPageArray[n];
                if (UsagesLogPage.isReusablePage(logPage2)) {
                    return (UsagesLogPage)logPage2;
                }
                ++n;
            }
        }
        return new UsagesLogPage();
    }

    private static boolean isReusablePage(LogPage logPage) {
        UsagesLogPage usagesLogPage;
        return logPage.getClass() == UsagesLogPage.class && !(usagesLogPage = (UsagesLogPage)logPage).isLocked();
    }

    protected boolean showPage() {
        String string = this.getTabName();
        super.tabNameUpdated();
        this.log(string);
        LogWindow logWindow = LogManager.getIdeLogWindow();
        boolean bl = DockStation.getDockStation().activateDockable((Dockable)logWindow);
        return bl;
    }

    public String getTabName() {
        return this.getTitleName();
    }

    public Icon getTabIcon() {
        return RefactoringArb.getIcon(21);
    }

    public String getTitleName() {
        return this._usageSource.getShortTitle();
    }

    public String getToolTip() {
        return this._usageSource.getLongTitle();
    }

    public Component getGUI() {
        if (this._ui == null) {
            this.init();
        }
        return this._ui;
    }

    public Controller getController() {
        return this;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == 51) {
            this.whenRefresh();
        } else if (n != SHOW_MATCH_CMD_ID && n != LOCK_PAGE_CMD_ID) {
            if (n == CREATE_WORKINGSET_CMD_ID) {
                this.whenCreateWorkingSet(context);
            } else if (n == 31) {
                this.whenNavigatePrev();
            } else if (n == 30) {
                this.whenNavigateNext();
            } else if (n == 12) {
                this.whenExport();
            } else {
                return false;
            }
        }
        return true;
    }

    private void whenNavigatePrev() {
        this.whenNavigate(-1, false);
    }

    private void whenNavigateNext() {
        this.whenNavigate(1, false);
    }

    private boolean whenNavigate(int n, boolean bl) {
        int n2;
        boolean bl2 = false;
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this._tree.getModel();
        ArrayList arrayList = new ArrayList();
        this.getLeafNodes((TreeNode)defaultTreeModel.getRoot(), arrayList);
        TreePath treePath = this._tree.getSelectionPath();
        if (treePath != null) {
            Object object = treePath.getLastPathComponent();
            n2 = arrayList.indexOf(object) + n;
        } else {
            n2 = n < 0 ? 0 : arrayList.size() - 1;
        }
        if (0 <= n2 && n2 < arrayList.size()) {
            if (!bl) {
                TreeNode treeNode = (TreeNode)arrayList.get(n2);
                TreePath treePath2 = new TreePath(defaultTreeModel.getPathToRoot(treeNode));
                this._tree.expandPath(treePath2);
                this._tree.setSelectionPath(treePath2);
                UsagesLogPage.gotoPath(treePath2, true);
            }
            bl2 = true;
        }
        return bl2;
    }

    private void getLeafNodes(TreeNode treeNode, ArrayList arrayList) {
        int n = treeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            TreeNode treeNode2 = treeNode.getChildAt(n2);
            if (treeNode2.isLeaf()) {
                arrayList.add(treeNode2);
            } else {
                this.getLeafNodes(treeNode2, arrayList);
            }
            ++n2;
        }
    }

    protected void whenCreateWorkingSet(Context context) {
        ArrayList arrayList = this._usageModel.getUsageEntries();
        HashSet<URL> hashSet = new HashSet<URL>();
        int n = 0;
        while (n < arrayList.size()) {
            BaseUsageEntry baseUsageEntry = (BaseUsageEntry)arrayList.get(n);
            if (baseUsageEntry.isIncluded()) {
                URL uRL = baseUsageEntry.getURL();
                hashSet.add(uRL);
            }
            ++n;
        }
        URL[] uRLArray = hashSet.toArray(new URL[hashSet.size()]);
        this.whenCreateWorkingSet(context, uRLArray);
    }

    private void whenCreateWorkingSet(Context context, URL[] uRLArray) {
        JLabel jLabel = new JLabel();
        JTextField jTextField = new JTextField(20);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)jTextField, (String)RefactoringArb.getString(189));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)jTextField, "Center");
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_jrf_createworkingset_html");
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, RefactoringArb.getString(190), 7);
        jEWTDialog.setContent((Component)jPanel);
        jEWTDialog.setResizable(true);
        jEWTDialog.addVetoableChangeListener((VetoableChangeListener)new 2(this, jTextField));
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            Project project = context.getProject();
            String string = jTextField.getText();
            WorkingSets workingSets = WorkingSets.getInstance((Project)project);
            WorkingSet workingSet = workingSets.getWorkingSet(string);
            if (workingSet != null) {
                PatternFilters patternFilters = workingSet.getPatternFilters();
                patternFilters.addExclude("**");
                PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance(project);
                URLPath uRLPath = pathsConfiguration.getSourcePath();
                int n = 0;
                while (n < uRLArray.length) {
                    URL uRL = uRLArray[n];
                    String string2 = uRLPath.toRelativePath(uRL);
                    patternFilters.addInclude(string2);
                    ++n;
                }
            }
        }
    }

    private void whenExport() {
        URLChooser uRLChooser = DialogUtil.newURLChooser();
        uRLChooser.clearChooseableURLFilters();
        WildcardURLFilter wildcardURLFilter = new WildcardURLFilter("*.xml", false, RefactoringArb.getString(192));
        uRLChooser.addChooseableURLFilter((URLFilter)wildcardURLFilter);
        uRLChooser.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
        Component component = this.getGUI();
        int n = uRLChooser.showSaveDialog(component, RefactoringArb.getString(193));
        if (n == 0) {
            XMLDocument xMLDocument = new XMLDocument();
            Element element = xMLDocument.createElement(RefactoringArb.getString(194));
            xMLDocument.appendChild((org.w3c.dom.Node)element);
            String string = this._usageSource.getLongTitle();
            Comment comment = xMLDocument.createComment(string);
            element.appendChild(comment);
            MultiMap multiMap = new MultiMap();
            ArrayList arrayList = this._usageModel.getUsageEntries();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                BaseUsageEntry baseUsageEntry = (BaseUsageEntry)arrayList.get(n2);
                URL uRL = baseUsageEntry.getURL();
                multiMap.add((Object)uRL, (Object)baseUsageEntry);
                ++n2;
            }
            ArrayList arrayList2 = new ArrayList(multiMap.keySet());
            int n3 = 0;
            while (n3 < arrayList2.size()) {
                URL uRL = (URL)arrayList2.get(n3);
                try {
                    TextNode textNode = (TextNode)NodeFactory.findOrCreate((URL)uRL);
                    TextBuffer textBuffer = textNode.acquireTextBuffer();
                    LineMap lineMap = textBuffer.getLineMap();
                    Element element2 = xMLDocument.createElement("url-hits");
                    String string2 = uRL.toString();
                    element2.setAttribute("name", string2);
                    List list = multiMap.get((Object)uRL);
                    int n4 = 0;
                    while (n4 < list.size()) {
                        BaseUsageEntry baseUsageEntry = (BaseUsageEntry)list.get(n4);
                        XMLElement xMLElement = (XMLElement)xMLDocument.createElement("hit");
                        int n5 = baseUsageEntry.getOffset();
                        xMLElement.setAttribute("offset", Integer.toString(n5));
                        int n6 = baseUsageEntry.getLength();
                        int n7 = lineMap.getLineFromOffset(n5);
                        xMLElement.setAttribute("line", Integer.toString(n7));
                        String string3 = textBuffer.getString(n5, n6);
                        Text text = xMLDocument.createTextNode("text#");
                        text.setNodeValue(string3);
                        xMLElement.appendChild((org.w3c.dom.Node)text);
                        element2.appendChild((org.w3c.dom.Node)xMLElement);
                        ++n4;
                    }
                    element.appendChild(element2);
                    textNode.releaseTextBuffer();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n3;
            }
            try {
                URL uRL = uRLChooser.getSelectedURL();
                OutputStream outputStream = URLFileSystem.openOutputStream((URL)uRL);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                xMLDocument.print((OutputStream)bufferedOutputStream);
                bufferedOutputStream.close();
                outputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == 51) {
            boolean bl = this.canSearch();
            ideAction.setEnabled(bl);
        } else if (n == SHOW_MATCH_CMD_ID || n == LOCK_PAGE_CMD_ID || n == CREATE_WORKINGSET_CMD_ID || n == 12) {
            ideAction.setEnabled(true);
        } else if (n == 31) {
            boolean bl = this.whenNavigate(-1, true);
            ideAction.setEnabled(bl);
        } else if (n == 30) {
            boolean bl = this.whenNavigate(1, true);
            ideAction.setEnabled(bl);
        } else {
            return false;
        }
        return true;
    }

    protected void whenRefresh() {
        this._usageSource.doSearch();
        UsageModel usageModel = this._usageSource.getUsageModel();
        this.setUsageModel(usageModel);
    }

    private static void createActions() {
        if (!_actionsCreated) {
            String string = RefactoringArb.getString(23);
            SHOW_MATCH_CMD_ID = Ide.findOrCreateCmdID((String)"USAGES.SHOW_MATCHING_CODE");
            IdeAction ideAction = IdeAction.get((int)SHOW_MATCH_CMD_ID, null, (String)StringUtils.stripMnemonic((String)string), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), (Icon)RefactoringArb.getIcon(24), null, (boolean)true);
            ideAction.putValue("Check", (Object)Boolean.TRUE);
            String string2 = RefactoringArb.getString(25);
            LOCK_PAGE_CMD_ID = Ide.findOrCreateCmdID((String)"USAGES.LOCK_PAGE");
            IdeAction ideAction2 = IdeAction.get((int)LOCK_PAGE_CMD_ID, null, (String)StringUtils.stripMnemonic((String)string2), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string2)), (Icon)RefactoringArb.getIcon(26), null, (boolean)true);
            ideAction2.putValue("Check", (Object)Boolean.TRUE);
            String string3 = RefactoringArb.getString(29);
            CREATE_WORKINGSET_CMD_ID = Ide.findOrCreateCmdID((String)"USAGES.CREATE_WORKINGSET");
            IdeAction.get((int)CREATE_WORKINGSET_CMD_ID, null, (String)StringUtils.stripMnemonic((String)string3), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string3)), null, null, (boolean)true);
            String string4 = RefactoringArb.getString(27);
            DO_REFACTORING_CMD_ID = Ide.findOrCreateCmdID((String)"REFACTORING_PREVIEW.GO");
            IdeAction.get((int)DO_REFACTORING_CMD_ID, null, (String)StringUtils.stripMnemonic((String)string4), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string4)), (Icon)RefactoringArb.getIcon(28), null, (boolean)true);
            _actionsCreated = true;
        }
    }

    public void close() {
        super.close();
        this.release();
        this._toolbar.dispose();
        this._toolbar.removeAll();
    }

    public void closePage() {
        LogManager logManager = LogManager.getLogManager();
        logManager.removePage((LogPage)this);
    }

    public boolean isLocked() {
        boolean bl = false;
        if (this._ui != null) {
            bl = this._lockPageButton == null ? true : this._lockPageButton.isSelected();
        }
        return bl;
    }

    public IdeAction getAction(int n) {
        IdeAction ideAction = IdeAction.find((int)n);
        IdeAction ideAction2 = ideAction.newLocalAction((View)this);
        ideAction2.setEnabled(true);
        return ideAction2;
    }

    public final void stateChanged(ChangeEvent changeEvent) {
        RefactorAddin refactorAddin = RefactorAddin.getInstance();
        boolean bl = this._showMatchButton.isSelected();
        refactorAddin.setPreferenceFlag(1, bl);
    }

    public final void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath;
        if (this._showMatchButton != null && this._showMatchButton.isSelected() && (treePath = treeSelectionEvent.getNewLeadSelectionPath()) != null) {
            UsagesLogPage.gotoPath(treePath, false);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.handleContextMenu(mouseEvent) && mouseEvent.getClickCount() == 2) {
            this.whenTreeDefaultAction();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.handleContextMenu(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.handleContextMenu(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private boolean handleContextMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showContextMenu(mouseEvent);
            return true;
        }
        return false;
    }

    public ContextMenu getContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.addContextMenuListener((ContextMenuListener)this);
        return contextMenu;
    }

    private void showContextMenu(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        JTree jTree = this.getTree();
        TreeSelectionModel treeSelectionModel = jTree.getSelectionModel();
        TreePath[] treePathArray = treeSelectionModel.getSelectionPaths();
        TreePath treePath = jTree.getPathForLocation(point.x, point.y);
        if (treePath != null) {
            boolean bl = true;
            if (treePathArray != null) {
                int n = 0;
                while (n < treePathArray.length) {
                    TreePath treePath2 = treePathArray[n];
                    if (treePath.equals(treePath2)) {
                        bl = false;
                    }
                    ++n;
                }
            }
            if (bl) {
                treeSelectionModel.setSelectionPath(treePath);
            }
        }
        ContextMenu contextMenu = this.getContextMenu();
        Context context = this.getContext(mouseEvent);
        contextMenu.show(context);
    }

    private static void gotoPath(TreePath treePath, boolean bl) {
        UsageNode usageNode = (UsageNode)treePath.getLastPathComponent();
        Object object = usageNode.getUserObject();
        if (object instanceof UsagesLeaf) {
            UsagesLeaf usagesLeaf = (UsagesLeaf)object;
            usagesLeaf.goToChange(bl);
        }
    }

    protected JTree getTree() {
        return this._tree;
    }

    protected void whenTreeDefaultAction() {
        this.goToSelectedNode(true);
    }

    private void goToSelectedNode(boolean bl) {
        TreePath treePath = this.getTree().getAnchorSelectionPath();
        if (treePath != null) {
            UsagesLogPage.gotoPath(treePath, bl);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "VALID") {
            BaseUsageEntry baseUsageEntry = (BaseUsageEntry)propertyChangeEvent.getSource();
            Object object = propertyChangeEvent.getNewValue();
            boolean bl = Boolean.TRUE.equals(object);
            this.whenValidityChanges(baseUsageEntry, bl);
            this._root.whenUsageEntryChanged(baseUsageEntry, propertyChangeEvent);
            View.updateToolbarActions((Toolbar)this._toolbar);
        }
        this._ui.repaint();
    }

    protected void init() {
        this._ui = new JPanel();
        this._ui.setLayout(new BorderLayout());
        this._root = new UsageNode((Object)"x", 0);
        this.createTree();
        this._toolbar = this.createToolbar();
        JScrollPane jScrollPane = new JScrollPane(this._tree);
        Border border = BorderFactory.createEmptyBorder();
        jScrollPane.setBorder(border);
        this._ui.add((Component)jScrollPane, "Center");
        if (this._toolbar != null) {
            this._ui.add((Component)this._toolbar, "North");
        }
        DragSource dragSource = new DragSource();
        dragSource.createDefaultDragGestureRecognizer(this._tree, 3, this);
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_jed_usages_log_html");
    }

    protected Toolbar createToolbar() {
        Toolbar toolbar = new Toolbar();
        this.addRefreshButton(toolbar);
        this.addShowMatchButton(toolbar);
        this.addLockPageButton(toolbar);
        return toolbar;
    }

    protected final void addRefreshButton(Toolbar toolbar) {
        IdeAction ideAction = this.getAction(51);
        toolbar.add((ToggleAction)ideAction);
    }

    protected final void addRunButton(Toolbar toolbar) {
        IdeAction ideAction = this.getAction(DO_REFACTORING_CMD_ID);
        this._runButton = toolbar.add((ToggleAction)ideAction);
    }

    protected final void addShowMatchButton(Toolbar toolbar) {
        IdeAction ideAction = this.getAction(SHOW_MATCH_CMD_ID);
        this._showMatchButton = toolbar.addToggleButton((ToggleAction)ideAction);
        RefactorAddin refactorAddin = RefactorAddin.getInstance();
        boolean bl = refactorAddin.getPreferenceFlag(1);
        this._showMatchButton.setSelected(bl);
        ButtonModel buttonModel = this._showMatchButton.getModel();
        buttonModel.addChangeListener(this);
    }

    protected final void addLockPageButton(Toolbar toolbar) {
        IdeAction ideAction = this.getAction(LOCK_PAGE_CMD_ID);
        this._lockPageButton = toolbar.addToggleButton((ToggleAction)ideAction);
    }

    private void createTree() {
        this._tree = new JTree(this._root);
        TreeSelectionModel treeSelectionModel = this._tree.getSelectionModel();
        treeSelectionModel.addTreeSelectionListener(this);
        UsageCellRenderer usageCellRenderer = new UsageCellRenderer();
        this._tree.setCellRenderer(usageCellRenderer);
        this._tree.setShowsRootHandles(true);
        this._tree.addMouseListener(this);
        ToolTipManager.sharedInstance().registerComponent(this._tree);
        1 var3_3 = new 1();
        InputMap inputMap = this._tree.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), var3_3);
        this._tree.getActionMap().put(var3_3, var3_3);
    }

    public boolean canSearch() {
        return this._usageSource.canSearch();
    }

    protected void setMergeJavaAndNonJavaFiles(boolean bl) {
        this._mergeJavaAndNonJavaFiles = bl;
    }

    private void release() {
        this.setUsageModel(null);
    }

    private void setUsageModel(UsageModel usageModel) {
        if (this._usageModel != null) {
            this._usageModel.release();
            this._usageModel.removePropertyChangeListener(this);
        }
        this._usageModel = usageModel;
        if (this._usageModel != null) {
            this._usageModel.addPropertyChangeListener(this);
            this.whenValidityChanges(null, true);
            this.updateTreeModel();
        }
    }

    private void updateTreeModel() {
        UsageNode usageNode;
        this._root.removeAllChildren();
        Context context = this._usageSource.getContext();
        TreeBuilder treeBuilder = new TreeBuilder();
        this._root = usageNode = treeBuilder.build_by_packages(context, this._usageModel, this._mergeJavaAndNonJavaFiles, true);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this._root);
        this._tree.setModel(defaultTreeModel);
        this._tree.setRootVisible(true);
        IdeUtil.expandAllTreeRows((JTree)this._tree);
        this._tree.setRootVisible(false);
    }

    protected void whenValidityChanges(BaseUsageEntry baseUsageEntry, boolean bl) {
        if (this._runButton != null) {
            this._runButton.setEnabled(bl);
        }
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        UsageNode usageNode;
        Object object;
        JTree jTree = this.getTree();
        Point point = dragGestureEvent.getDragOrigin();
        TreePath treePath = jTree.getPathForLocation(point.x, point.y);
        if (treePath != null && (object = (usageNode = (UsageNode)treePath.getLastPathComponent()).getUserObject()) instanceof TreeBuilder.FileEntry) {
            TreeBuilder.FileEntry fileEntry = (TreeBuilder.FileEntry)object;
            URL uRL = fileEntry.getUrl();
            try {
                Node node = NodeFactory.findOrCreate((URL)uRL);
                Context context = new Context((View)this, fileEntry.getWorkspace(), fileEntry.getProject(), node);
                TransferableContext transferableContext = new TransferableContext(context);
                DragSource dragSource = DragSource.getDefaultDragSource();
                dragSource.startDrag(dragGestureEvent, null, (Transferable)transferableContext, this);
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
        }
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        IdeAction ideAction = IdeAction.find((int)12);
        ideAction.updateAction();
        JMenuItem jMenuItem = new JMenuItem((Action)ideAction);
        contextMenu.add((Component)jMenuItem);
        IdeAction ideAction2 = IdeAction.find((int)CREATE_WORKINGSET_CMD_ID);
        ideAction2.updateAction();
        JMenuItem jMenuItem2 = new JMenuItem((Action)ideAction2);
        contextMenu.add((Component)jMenuItem2);
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean isLockPageState() {
        return this._lockPageState;
    }

    public void setLockPageState(boolean bl) {
        this._lockPageState = bl;
    }

    public boolean isShowMatchState() {
        return this._showMatchState;
    }

    public void setShowMatchState(boolean bl) {
        this._showMatchState = bl;
    }

    public final class 2
    implements VetoableChangeListener {
        private final /* synthetic */ JTextField v$textField;
        final /* synthetic */ UsagesLogPage this$0;

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (propertyChangeEvent.getPropertyName().equals("closed") && Boolean.TRUE.equals(propertyChangeEvent.getNewValue()) && this.v$textField.getText().length() == 0) {
                throw new PropertyVetoException(RefactoringArb.getString(191), propertyChangeEvent);
            }
        }

        public 2(UsagesLogPage usagesLogPage, JTextField jTextField) {
            this.v$textField = jTextField;
            this.this$0 = usagesLogPage;
        }
    }

    public final class 1
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            UsagesLogPage.this.whenTreeDefaultAction();
        }
    }
}

