/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.preview.model;

import java.net.URL;
import java.text.AttributedString;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.ide.model.TextNode;
import oracle.ide.util.MultiMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdeveloper.sourcecolors.SourceColorizer;

public class ParseOptimizer {
    private MultiMap _nodeToOffsets;

    void $init$() {
        this._nodeToOffsets = new MultiMap();
    }

    public void addSegment(TextNode textNode, int n, int n2) {
        Entry entry = new Entry(n, n2);
        this._nodeToOffsets.add((Object)textNode, (Object)entry);
    }

    public void run() {
        Set set = this._nodeToOffsets.keySet();
        for (TextNode textNode : set) {
            this.parseNode(textNode);
        }
    }

    public AttributedString getAttributedString(TextNode textNode, int n, int n2) {
        List list = this._nodeToOffsets.get((Object)textNode);
        int n3 = 0;
        while (n3 < list.size()) {
            Entry entry = (Entry)list.get(n3);
            if (entry._startOffset == n) {
                return entry._attributedString;
            }
            ++n3;
        }
        return null;
    }

    private void parseNode(TextNode textNode) {
        URL uRL = textNode.getURL();
        String string = SourceColorizer.getLanguage(uRL);
        TextBuffer textBuffer = textNode.acquireTextBuffer();
        String string2 = textBuffer.getString(0, textBuffer.getLength());
        List list = this._nodeToOffsets.get((Object)textNode);
        Collections.sort(list);
        int[] nArray = new int[list.size()];
        int[] nArray2 = new int[list.size()];
        int n = 0;
        while (n < list.size()) {
            Entry entry = (Entry)list.get(n);
            nArray[n] = entry._startOffset;
            nArray2[n] = entry._endOffset;
            ++n;
        }
        AttributedString[] attributedStringArray = SourceColorizer.toAttributedString(string, string2, nArray, nArray2);
        int n2 = 0;
        while (n2 < attributedStringArray.length) {
            Entry entry = (Entry)list.get(n2);
            entry._attributedString = attributedStringArray[n2];
            ++n2;
        }
    }

    public ParseOptimizer() {
        this.$init$();
    }

    public static class Entry
    implements Comparable {
        int _startOffset;
        int _endOffset;
        AttributedString _attributedString;

        public Entry(int n, int n2) {
            this._startOffset = n;
            this._endOffset = n2;
            if (this._startOffset >= this._endOffset) {
                System.out.println("ParseOptimizer$Entry.Entry: ???");
            }
        }

        public int compareTo(Object object) {
            Entry entry = (Entry)object;
            return this._startOffset - entry._startOffset;
        }
    }
}

