/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.preview.model;

import java.net.URL;
import java.text.AttributedString;
import java.util.ArrayList;
import oracle.ide.Context;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdevimpl.refactoring.preview.model.ParseOptimizer;
import oracle.jdevimpl.refactoring.preview.model.UsageNode;
import oracle.jdevimpl.refactoring.preview.model.UsagesLeaf;

public final class TreeBuilder {
    private static final boolean DEBUG = false;
    private ArrayList _usageLeaves;

    void $init$() {
        this._usageLeaves = new ArrayList();
    }

    public UsageNode build_by_packages(Context context, UsageModel usageModel, boolean bl, boolean bl2) {
        long l = 0L;
        ArrayList arrayList = usageModel.getUsageEntries();
        UsageNode usageNode = new UsageNode();
        UsageNode usageNode2 = new UsageNode();
        Workspace workspace = context.getWorkspace();
        Project project = null;
        ContentSet contentSet = null;
        URLPath uRLPath = new URLPath();
        int n = 0;
        while (n < arrayList.size()) {
            BaseUsageEntry baseUsageEntry = (BaseUsageEntry)arrayList.get(n);
            Project project2 = baseUsageEntry.getProject();
            URL uRL = baseUsageEntry.getURL();
            FileEntry fileEntry = new FileEntry(workspace, project2, uRL);
            URL uRL2 = URLFileSystem.getParent((URL)uRL);
            UsageNode usageNode3 = null;
            if (!bl && Util.isJavaSource(uRL)) {
                String string;
                if (project2 != project) {
                    uRLPath = new URLPath();
                    contentSet = ProjectContent.getInstance((PropertyStorage)project2).getAllContents();
                    JProjectLibraries jProjectLibraries = JProjectLibraries.getInstance((PropertyStorage)project2);
                    JDK jDK = jProjectLibraries.getJDK();
                    URLPath uRLPath2 = jDK.getSourcePath();
                    uRLPath.add(uRLPath2);
                    JLibrary[] jLibraryArray = jProjectLibraries.getLibraries();
                    int n2 = 0;
                    while (n2 < jLibraryArray.length) {
                        JLibrary jLibrary = jLibraryArray[n2];
                        URLPath uRLPath3 = jLibrary.getSourcePath();
                        uRLPath.add(uRLPath3);
                        ++n2;
                    }
                    project = project2;
                }
                if ((string = contentSet.toRelativePath(uRL2)) == null) {
                    string = uRLPath.toRelativePath(uRL);
                }
                if (string != null) {
                    String string2 = string.replace('/', '.');
                    if (string2.endsWith(".")) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    usageNode3 = this.getOrCreateNode(usageNode, string2, 1);
                } else {
                    System.out.println("Cannot find " + URLFileSystem.getPlatformPathName((URL)uRL2) + " in " + project2.getShortLabel());
                }
            } else {
                FileEntry fileEntry2 = new FileEntry(workspace, project2, uRL2);
                usageNode3 = this.getOrCreateNode(usageNode2, fileEntry2, 2);
            }
            if (usageNode3 != null) {
                UsageNode usageNode4 = this.getOrCreateNode(usageNode3, fileEntry, 3);
                this.getOrCreateLeafNode(usageNode4, baseUsageEntry, bl2);
            }
            ++n;
        }
        int n3 = usageNode2.getChildCount();
        int n4 = n3 - 1;
        while (n4 > -1) {
            UsageNode usageNode5 = (UsageNode)usageNode2.getChildAt(n4);
            usageNode.add(usageNode5);
            --n4;
        }
        usageNode.sortChildren();
        long l2 = 0L;
        ParseOptimizer parseOptimizer = new ParseOptimizer();
        int n5 = 0;
        while (n5 < this._usageLeaves.size()) {
            UsagesLeaf usagesLeaf = (UsagesLeaf)this._usageLeaves.get(n5);
            TextNode textNode = usagesLeaf.getTextNode();
            int n6 = usagesLeaf.getLineStart();
            int n7 = usagesLeaf.getLineEnd();
            parseOptimizer.addSegment(textNode, n6, n7);
            ++n5;
        }
        parseOptimizer.run();
        int n8 = 0;
        while (n8 < this._usageLeaves.size()) {
            UsagesLeaf usagesLeaf = (UsagesLeaf)this._usageLeaves.get(n8);
            TextNode textNode = usagesLeaf.getTextNode();
            int n9 = usagesLeaf.getLineStart();
            int n10 = usagesLeaf.getLineEnd();
            AttributedString attributedString = parseOptimizer.getAttributedString(textNode, n9, n10);
            usagesLeaf.setAttributedString(attributedString);
            ++n8;
        }
        return usageNode;
    }

    private UsageNode getOrCreateNode(UsageNode usageNode, Object object, int n) {
        UsageNode usageNode2;
        String string = UsageNode.toString(n, object);
        UsageNode usageNode3 = usageNode.getChildNode(string);
        if (usageNode3 != null) {
            usageNode2 = usageNode3;
        } else {
            usageNode2 = new UsageNode(object, n);
            usageNode.add(usageNode2);
        }
        return usageNode2;
    }

    private void getOrCreateLeafNode(UsageNode usageNode, BaseUsageEntry baseUsageEntry, boolean bl) {
        UsageNode usageNode2 = null;
        int n = usageNode.getChildCount();
        int n2 = 0;
        while (usageNode2 == null && n2 < n) {
            UsageNode usageNode3 = (UsageNode)usageNode.getChildAt(n2);
            UsagesLeaf usagesLeaf = (UsagesLeaf)usageNode3.getUserObject();
            if (bl) {
                if (usagesLeaf.isSameLine(baseUsageEntry)) {
                    usagesLeaf.addChange(baseUsageEntry);
                    usageNode2 = usageNode3;
                }
            } else {
                int n3 = usagesLeaf.getFirstOffset();
                if (baseUsageEntry.getOffset() > n3) {
                    UsagesLeaf usagesLeaf2 = new UsagesLeaf();
                    usagesLeaf2.addChange(baseUsageEntry);
                    usageNode2 = new UsageNode((Object)usagesLeaf2, 4);
                    usageNode.add(usageNode2);
                    this._usageLeaves.add(usagesLeaf2);
                }
            }
            ++n2;
        }
        if (usageNode2 == null) {
            UsagesLeaf usagesLeaf = new UsagesLeaf();
            usagesLeaf.addChange(baseUsageEntry);
            usageNode2 = new UsageNode((Object)usagesLeaf, 4);
            usageNode.add(usageNode2);
            this._usageLeaves.add(usagesLeaf);
        }
    }

    public TreeBuilder() {
        this.$init$();
    }

    public class FileEntry {
        private Workspace _workspace;
        private Project _project;
        private URL _url;

        public FileEntry(Workspace workspace, Project project, URL uRL) {
            this._workspace = workspace;
            this._project = project;
            this._url = uRL;
        }

        public Workspace getWorkspace() {
            return this._workspace;
        }

        public Project getProject() {
            return this._project;
        }

        public URL getUrl() {
            return this._url;
        }

        public boolean equals(Object object) {
            if (object instanceof FileEntry) {
                FileEntry fileEntry = (FileEntry)object;
                if (ModelUtil.areEqual((Object)this._url, (Object)fileEntry._url)) {
                    return true;
                }
            }
            return false;
        }
    }
}

