/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.preview.model;

import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;
import oracle.jdevimpl.refactoring.preview.model.TreeBuilder;
import oracle.jdevimpl.refactoring.preview.model.UsagesLeaf;

public class UsageNode
extends DefaultMutableTreeNode
implements Comparable {
    public static final int NODE_TYPE_OTHER = 0;
    public static final int NODE_TYPE_PACKAGE = 1;
    public static final int NODE_TYPE_DIRECTORY = 2;
    public static final int NODE_TYPE_FILE = 3;
    public static final int NODE_TYPE_TEXT_LINE = 4;
    private int _nodeType;
    private HashMap _childNodes;

    public UsageNode() {
        this(null, 0);
    }

    public UsageNode(Object object, int n) {
        super(object);
        this._nodeType = n;
    }

    public int getNodeType() {
        return this._nodeType;
    }

    public UsageNode getUsageNodeAt(int n) {
        return (UsageNode)super.getChildAt(n);
    }

    public void whenUsageEntryChanged(BaseUsageEntry baseUsageEntry, PropertyChangeEvent propertyChangeEvent) {
        if (this.getNodeType() == 4) {
            UsagesLeaf usagesLeaf = (UsagesLeaf)this.getUserObject();
            usagesLeaf.whenUsageEntryChanged(baseUsageEntry, propertyChangeEvent);
        }
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            UsageNode usageNode = this.getUsageNodeAt(n2);
            usageNode.whenUsageEntryChanged(baseUsageEntry, propertyChangeEvent);
            ++n2;
        }
    }

    public String toString() {
        int n = this.getNodeType();
        Object object = this.getUserObject();
        String string = UsageNode.toString(n, object);
        return string;
    }

    public static String toString(int n, Object object) {
        String string;
        switch (n) {
            case 4: {
                UsagesLeaf usagesLeaf = (UsagesLeaf)object;
                TextNode textNode = usagesLeaf.getTextNode();
                String string2 = textNode.getLongLabel();
                if (usagesLeaf.areAllValid()) {
                    try {
                        int n2 = usagesLeaf.getLineStart();
                        TextBuffer textBuffer = textNode.acquireTextBuffer();
                        LineMap lineMap = textBuffer.getLineMap();
                        int n3 = lineMap.getLineFromOffset(n2);
                        string = string2 = string2 + ":" + (n3 + 1);
                        break;
                    }
                    finally {
                        textNode.releaseTextBuffer();
                    }
                }
                string = null;
                break;
            }
            case 3: {
                TreeBuilder.FileEntry fileEntry = (TreeBuilder.FileEntry)object;
                URL uRL = fileEntry.getUrl();
                string = URLFileSystem.getPlatformPathName((URL)uRL);
                break;
            }
            case 1: {
                string = (String)object;
                break;
            }
            case 2: {
                TreeBuilder.FileEntry fileEntry = (TreeBuilder.FileEntry)object;
                URL uRL = fileEntry.getUrl();
                string = URLFileSystem.getPlatformPathName((URL)uRL);
                break;
            }
            default: {
                string = "_";
            }
        }
        return string;
    }

    public void insert(MutableTreeNode mutableTreeNode, int n) {
        super.insert(mutableTreeNode, n);
        if (this._childNodes == null) {
            this._childNodes = new HashMap(3);
        }
        this._childNodes.put(mutableTreeNode.toString(), mutableTreeNode);
    }

    public UsageNode getChildNode(String string) {
        UsageNode usageNode = null;
        if (this._childNodes != null) {
            usageNode = (UsageNode)this._childNodes.get(string);
        }
        return usageNode;
    }

    public void sortChildren() {
        this._childNodes = null;
        if (this.children != null) {
            Collections.sort(this.children);
            int n = 0;
            while (n < this.children.size()) {
                UsageNode usageNode = (UsageNode)this.children.elementAt(n);
                usageNode.sortChildren();
                ++n;
            }
        }
    }

    public int compareTo(Object object) {
        int n;
        int n2;
        UsageNode usageNode = (UsageNode)object;
        int n3 = this.getNodeType();
        if (n3 == (n2 = usageNode.getNodeType())) {
            switch (n3) {
                case 4: {
                    UsagesLeaf usagesLeaf = (UsagesLeaf)this.getUserObject();
                    UsagesLeaf usagesLeaf2 = (UsagesLeaf)usageNode.getUserObject();
                    int n4 = usagesLeaf.getLineStart();
                    int n5 = usagesLeaf2.getLineStart();
                    n = n4 - n5;
                    break;
                }
                default: {
                    String string = this.toString();
                    String string2 = usageNode.toString();
                    n = string.compareToIgnoreCase(string2);
                    break;
                }
            }
        } else {
            n = n3 - n2;
        }
        return n;
    }

    public int getHitCount() {
        int n = 0;
        if (this._nodeType == 4) {
            UsagesLeaf usagesLeaf = (UsagesLeaf)this.getUserObject();
            n = usagesLeaf.getEntryCount();
        } else {
            int n2 = 0;
            while (n2 < this.children.size()) {
                UsageNode usageNode = (UsageNode)this.children.elementAt(n2);
                n += usageNode.getHitCount();
                ++n2;
            }
        }
        return n;
    }
}

