/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.preview.model;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.text.AttributedString;
import java.util.ArrayList;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;

public class UsagesLeaf {
    private ArrayList _usageEntries;
    private int _lineStartOffset;
    private int _lineEndOffset;
    private int _lineNumber;
    private AttributedString _baseAttributedString;
    private AttributedString _attributedString;

    void $init$() {
        this._usageEntries = new ArrayList(2);
    }

    public UsagesLeaf() {
        this.$init$();
    }

    public void addChange(BaseUsageEntry baseUsageEntry) {
        if (this._usageEntries.isEmpty()) {
            URL uRL = baseUsageEntry.getURL();
            int n = baseUsageEntry.getOffset();
            this.storeLineInfo(uRL, n);
        }
        int n = baseUsageEntry.getOffset();
        boolean bl = false;
        int n2 = 0;
        while (n2 < this._usageEntries.size()) {
            BaseUsageEntry baseUsageEntry2 = (BaseUsageEntry)this._usageEntries.get(n2);
            int n3 = baseUsageEntry2.getOffset();
            if (n == n3) {
                bl = true;
                break;
            }
            if (n <= n3) break;
            ++n2;
        }
        if (!bl) {
            this._usageEntries.add(n2, baseUsageEntry);
            this.clearAtttributedString();
        }
    }

    public int getEntryCount() {
        return this._usageEntries.size();
    }

    public void removeChange(BaseUsageEntry baseUsageEntry) {
        if (this._usageEntries.remove(baseUsageEntry)) {
            this.clearAtttributedString();
        }
    }

    public void removeAllChanges() {
        while (!this._usageEntries.isEmpty()) {
            BaseUsageEntry baseUsageEntry = (BaseUsageEntry)this._usageEntries.get(0);
            this.removeChange(baseUsageEntry);
        }
    }

    public void whenUsageEntryChanged(BaseUsageEntry baseUsageEntry, PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "VALID") {
            int n = 0;
            while (n < this._usageEntries.size()) {
                BaseUsageEntry baseUsageEntry2 = (BaseUsageEntry)this._usageEntries.get(n);
                if (baseUsageEntry == baseUsageEntry2) {
                    this.clearAtttributedString();
                    break;
                }
                ++n;
            }
        }
    }

    private void clearAtttributedString() {
        this._attributedString = null;
    }

    public void goToChange(boolean bl) {
        BaseUsageEntry baseUsageEntry = (BaseUsageEntry)this._usageEntries.get(0);
        baseUsageEntry.goToChange(bl, false);
    }

    public AttributedString getAttributedString() {
        if (this._attributedString == null) {
            boolean bl = true;
            boolean bl2 = true;
            int n = 0;
            while (n < this._usageEntries.size()) {
                BaseUsageEntry baseUsageEntry = (BaseUsageEntry)this._usageEntries.get(n);
                bl = bl && baseUsageEntry.isValid();
                bl2 = bl2 && baseUsageEntry.isIncluded();
                ++n;
            }
            boolean bl3 = bl2 = bl2 && bl;
            if (bl && bl2) {
                this._attributedString = this._baseAttributedString;
            } else {
                this._attributedString = new AttributedString(this._baseAttributedString.getIterator());
                if (!bl) {
                    this._attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                }
                if (!bl2) {
                    this._attributedString.addAttribute(TextAttribute.FOREGROUND, Color.LIGHT_GRAY);
                }
            }
        }
        return this._attributedString;
    }

    public boolean hasIncludedChanges() {
        int n = 0;
        while (n < this._usageEntries.size()) {
            BaseUsageEntry baseUsageEntry = (BaseUsageEntry)this._usageEntries.get(n);
            if (baseUsageEntry.isIncluded()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean hasExcludedChanges() {
        int n = 0;
        while (n < this._usageEntries.size()) {
            BaseUsageEntry baseUsageEntry = (BaseUsageEntry)this._usageEntries.get(n);
            if (!baseUsageEntry.isIncluded()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean areAllValid() {
        int n = 0;
        while (n < this._usageEntries.size()) {
            BaseUsageEntry baseUsageEntry = (BaseUsageEntry)this._usageEntries.get(n);
            if (!baseUsageEntry.isValid()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void setIncludedStates(boolean bl) {
        int n = 0;
        while (n < this._usageEntries.size()) {
            BaseUsageEntry baseUsageEntry = (BaseUsageEntry)this._usageEntries.get(n);
            baseUsageEntry.setIncluded(bl);
            ++n;
        }
        this.clearAtttributedString();
    }

    public boolean isSameLine(BaseUsageEntry baseUsageEntry) {
        if (this._usageEntries.size() == 0) {
            return true;
        }
        BaseUsageEntry baseUsageEntry2 = (BaseUsageEntry)this._usageEntries.get(0);
        boolean bl = baseUsageEntry2.getURL().equals(baseUsageEntry.getURL());
        if (bl) {
            int n = baseUsageEntry.getOffset();
            return this.getLineStart() <= n && n < this.getLineEnd();
        }
        return false;
    }

    public int getLineStart() {
        return this._lineStartOffset;
    }

    public int getLineEnd() {
        return this._lineEndOffset;
    }

    public int getFirstOffset() {
        if (this._usageEntries.size() == 0) {
            return -1;
        }
        BaseUsageEntry baseUsageEntry = (BaseUsageEntry)this._usageEntries.get(0);
        return baseUsageEntry.getOffset();
    }

    public TextNode getTextNode() {
        TextNode textNode = null;
        BaseUsageEntry baseUsageEntry = (BaseUsageEntry)this._usageEntries.get(0);
        URL uRL = baseUsageEntry.getURL();
        try {
            textNode = (TextNode)NodeFactory.findOrCreate((URL)uRL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return textNode;
    }

    private void storeLineInfo(URL uRL, int n) {
        try {
            TextNode textNode = (TextNode)NodeFactory.findOrCreate((URL)uRL);
            TextBuffer textBuffer = textNode.acquireTextBuffer();
            this.storeLineInfo(textBuffer, n);
            textNode.releaseTextBuffer();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void storeLineInfo(TextBuffer textBuffer, int n) {
        LineMap lineMap = textBuffer.getLineMap();
        this._lineNumber = lineMap.getLineFromOffset(n);
        this._lineStartOffset = lineMap.getLineStartOffset(this._lineNumber);
        this._lineEndOffset = lineMap.getLineEndOffset(this._lineNumber);
        String string = textBuffer.getString(this._lineStartOffset, this._lineEndOffset - this._lineStartOffset);
        int n2 = 0;
        while (n2 < string.length() && Character.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        this._lineStartOffset += n2;
    }

    public void setAttributedString(AttributedString attributedString) {
        this._baseAttributedString = attributedString;
        int n = 0;
        while (n < this._usageEntries.size()) {
            BaseUsageEntry baseUsageEntry = (BaseUsageEntry)this._usageEntries.get(n);
            int n2 = baseUsageEntry.getOffset() - this._lineStartOffset;
            int n3 = n2 + baseUsageEntry.getLength();
            this._baseAttributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, n2, n3);
            this._baseAttributedString.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, n2, n3);
            ++n;
        }
    }
}

