/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.search;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;
import oracle.jdevimpl.refactoring.search.FindDialog;

public class FindClassDialog
extends FindDialog
implements ActionListener {
    public static final String PREFERENCE_KEY = "FIND_CLASS_DLG_DEFAULTS";
    private static int PREF_CLASS = 1;
    private static int PREF_MEMBERS = 2;
    private JavaClass _javaClass;
    private JCheckBox _findClass;
    private JCheckBox _findMembers;

    public FindClassDialog(Context context, JavaClass javaClass) {
        super(PREFERENCE_KEY, context);
        this._javaClass = javaClass;
        this.init();
    }

    protected JPanel createWhatPanel() {
        CopyableInteger copyableInteger = this.getSettings();
        Insets insets = new Insets(2, 2, 2, 2);
        this._findClass = new JCheckBox();
        this._findClass.setSelected(copyableInteger.isBitSet(PREF_CLASS));
        int n = this._javaClass.isInterface() ? 54 : 53;
        ResourceUtils.resButton((AbstractButton)this._findClass, (String)RefactoringArb.getString(n));
        this._findClass.addActionListener(this);
        this._findMembers = new JCheckBox();
        this._findMembers.setSelected(copyableInteger.isBitSet(PREF_MEMBERS));
        ResourceUtils.resButton((AbstractButton)this._findMembers, (String)RefactoringArb.getString(55));
        this._findMembers.addActionListener(this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(RefactoringArb.getString(150)));
        jPanel.add((Component)this._findClass, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, insets, 2, 0));
        jPanel.add((Component)this._findMembers, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, insets, 2, 0));
        return jPanel;
    }

    protected String getTitle() {
        String string = this._javaClass.getName();
        String string2 = MessageFormat.format(RefactoringArb.getString(44), string);
        return string2;
    }

    protected int getDefaultPreferences() {
        return PREF_CLASS;
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            this.setOKButtonEnabled(this.hasFindClass() || this.hasFindMembers());
        }
    }

    protected void updateSettings(CopyableInteger copyableInteger) {
        super.updateSettings(copyableInteger);
        copyableInteger.setBit(PREF_CLASS, this.hasFindClass());
        copyableInteger.setBit(PREF_MEMBERS, this.hasFindMembers());
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._findClass;
    }

    protected String getHelpTopicID() {
        return "f1_jed_usages_of_type_dlg_html";
    }

    public boolean hasFindClass() {
        return this._findClass.isSelected();
    }

    public boolean hasFindMembers() {
        return this._findMembers.isSelected();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.updateOKButton();
    }
}

