/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.search;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.criteria.SearchClassCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchFieldCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchMethodCriteria;
import oracle.jdeveloper.refactoring.model.FieldDescription;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.URLHandler;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.usage.UsageManager;
import oracle.jdeveloper.usage.UsageQueryTask;
import oracle.jdeveloper.usage.event.ClassUsageEvent;
import oracle.jdeveloper.usage.event.ClassUsageListener;
import oracle.jdeveloper.usage.event.UsageEvent;
import oracle.jdevimpl.refactoring.handlers.JavaURLHelper;
import oracle.jdevimpl.refactoring.oprs.rename.member.RenameFieldURLHandler;
import oracle.jdevimpl.refactoring.oprs.rename.member.RenameMethodURLHandler;
import oracle.jdevimpl.refactoring.search.Scope;

public class FindClassURLHandler
extends URLHandler {
    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] projectArray = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        if (n == 1) {
            SearchClassCriteria searchClassCriteria = (SearchClassCriteria)searchCriteria;
            String string = searchClassCriteria.getFqClassName();
            Scope scope = searchClassCriteria.getScope();
            projectArray = FindClassURLHandler.getIncludedProjects(searchOperation, new String[]{string}, scope);
        }
        return projectArray;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet hashSet = null;
        if (FindClassURLHandler.isMyType(searchOperation)) {
            SearchClassCriteria searchClassCriteria = (SearchClassCriteria)searchOperation.getCriteria();
            String string = searchClassCriteria.getClassName();
            boolean bl = searchClassCriteria.isIncludeLibraries();
            hashSet = JavaURLHelper.getJavaURLsContaining(searchOperation, project, new String[]{string}, bl, searchClassCriteria.isSearchInNonJavaFiles(), searchClassCriteria.getScope(), progressIndicator);
            if (searchClassCriteria.isIncludeMembers()) {
                JavaManager javaManager = JavaManager.getJavaManager(project);
                String string2 = searchClassCriteria.getFqClassName();
                JavaClass javaClass = javaManager.getClass(string2);
                HashSet<String> hashSet2 = new HashSet<String>();
                Collection collection = javaClass.getDeclaredMethods();
                int n = 0;
                while (n < 2) {
                    for (JavaMember javaMember : collection) {
                        String string3 = javaMember.getName();
                        hashSet2.add(string3);
                    }
                    collection = javaClass.getDeclaredFields();
                    ++n;
                }
                Iterator iterator = hashSet2.iterator();
                while (iterator.hasNext() && !searchOperation.isUserCancelled()) {
                    String string4 = (String)iterator.next();
                    HashSet hashSet3 = JavaURLHelper.getJavaURLsContaining(searchOperation, project, new String[]{string4}, bl, searchClassCriteria.isSearchInNonJavaFiles(), searchClassCriteria.getScope(), progressIndicator);
                    hashSet.addAll(hashSet3);
                }
            }
        }
        return hashSet;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] uRLArray, ProgressIndicator progressIndicator) {
        UsageModel usageModel = null;
        if (FindClassURLHandler.isMyType(searchOperation)) {
            SearchClassCriteria searchClassCriteria = (SearchClassCriteria)searchOperation.getCriteria();
            usageModel = FindClassURLHandler.searchClass(project, uRLArray, searchClassCriteria, progressIndicator);
        }
        return usageModel;
    }

    public static UsageModel searchClass(Project project, URL[] uRLArray, SearchClassCriteria searchClassCriteria, ProgressIndicator progressIndicator) {
        String string = searchClassCriteria.getFqClassName();
        boolean bl = searchClassCriteria.isIncludeImports();
        boolean bl2 = searchClassCriteria.isIncludeExtends();
        boolean bl3 = searchClassCriteria.isIncludeAllocation();
        boolean bl4 = searchClassCriteria.isIncludeDeclaration();
        boolean bl5 = searchClassCriteria.isIncludeClass();
        boolean bl6 = searchClassCriteria.isSearchInComments();
        boolean bl7 = searchClassCriteria.isIncludeMembers();
        return FindClassURLHandler.searchClass(progressIndicator, project, uRLArray, string, bl, bl2, bl3, bl4, bl5, bl6, bl7);
    }

    public static UsageModel searchClass(ProgressIndicator progressIndicator, Project project, URL[] uRLArray, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        UsageModel usageModel = new UsageModel();
        MyClassUsageListener myClassUsageListener = new MyClassUsageListener(project, usageModel, bl, bl2, bl3, bl4, bl5, bl6);
        UsageManager usageManager = new UsageManager(project);
        String string2 = string.replace('$', '.');
        UsageQueryTask usageQueryTask = usageManager.findClassUsages(string2, myClassUsageListener, uRLArray);
        1 var16_16 = new 1(usageQueryTask);
        progressIndicator.addActionListener(var16_16);
        Util.waitUntilFinished(usageQueryTask, progressIndicator);
        progressIndicator.removeActionListener(var16_16);
        if (!progressIndicator.isUserCancelled() && bl7) {
            JavaManager javaManager = JavaManager.getJavaManager(project);
            JavaClass javaClass = javaManager.getClass(string);
            Collection collection = javaClass.getDeclaredMethods();
            for (JavaMethod javaMethod : collection) {
                MethodDescription methodDescription = new MethodDescription(javaMethod);
                SearchMethodCriteria searchMethodCriteria = new SearchMethodCriteria(methodDescription);
                searchMethodCriteria.setIncludeDeclaration(true);
                searchMethodCriteria.setIncludeInvocation(true);
                UsageModel usageModel2 = RenameMethodURLHandler.searchMethod(project, uRLArray, progressIndicator, methodDescription, false);
                usageModel.transferAll(usageModel2);
            }
            Collection collection2 = javaClass.getDeclaredFields();
            for (JavaField javaField : collection2) {
                FieldDescription fieldDescription = new FieldDescription(javaField);
                SearchFieldCriteria searchFieldCriteria = new SearchFieldCriteria(fieldDescription, false);
                UsageModel usageModel3 = RenameFieldURLHandler.findUsages(project, uRLArray, progressIndicator, searchFieldCriteria.getFieldDescription(), searchFieldCriteria.isSearchInComments());
                usageModel.transferAll(usageModel3);
            }
        }
        return usageModel;
    }

    private static boolean isMyType(SearchOperation searchOperation) {
        boolean bl = false;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        if (n == 1) {
            bl = true;
        }
        return bl;
    }

    public static final class 1
    implements ActionListener {
        private final /* synthetic */ UsageQueryTask v$usageQueryTask;

        public void actionPerformed(ActionEvent actionEvent) {
            this.v$usageQueryTask.cancel();
        }

        public 1(UsageQueryTask usageQueryTask) {
            this.v$usageQueryTask = usageQueryTask;
        }
    }

    private static class MyClassUsageListener
    implements ClassUsageListener {
        private final Project _project;
        private final UsageModel _usageModel;
        private boolean _includeImports;
        private boolean _includeExtends;
        private boolean _includeAllocation;
        private boolean _includeDeclaration;
        private boolean _includeClass;
        private boolean _searchInComments;

        public MyClassUsageListener(Project project, UsageModel usageModel, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
            this._project = project;
            this._usageModel = usageModel;
            this._includeImports = bl;
            this._includeExtends = bl2;
            this._includeAllocation = bl3;
            this._includeDeclaration = bl4;
            this._includeClass = bl5;
            this._searchInComments = bl6;
        }

        public void notifyClassUsage(ClassUsageEvent classUsageEvent) {
            boolean bl;
            int n = classUsageEvent.getUsageCode();
            switch (n) {
                case 101: {
                    bl = this._includeImports;
                    break;
                }
                case 103: 
                case 104: {
                    bl = this._includeExtends;
                    break;
                }
                case 112: {
                    bl = this._includeAllocation;
                    break;
                }
                case 102: {
                    bl = this._includeDeclaration;
                    break;
                }
                default: {
                    bl = this._includeClass;
                }
            }
            if (bl) {
                this.addUsage(classUsageEvent);
            }
        }

        private void addUsage(UsageEvent usageEvent) {
            int n;
            int n2;
            int n3 = usageEvent.getUsageCode();
            URL uRL = usageEvent.getURL();
            UsageEntry usageEntry = UsageEntry.createEntry(this._project, uRL, n2 = usageEvent.getStartOffset(), (n = usageEvent.getEndOffset()) - n2, n3);
            if (usageEntry != null) {
                this._usageModel.addUsageEntry(usageEntry);
            }
        }

        public void notifyFinished(UsageEvent usageEvent) {
        }

        public void notifySkipped(UsageEvent usageEvent) {
            if (this._searchInComments) {
                this.addUsage(usageEvent);
            }
        }
    }
}

