/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.search;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.criteria.SearchConstructorCriteria;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.URLHandler;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdevimpl.refactoring.handlers.JavaURLHelper;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.search.Scope;
import oracle.jdevimpl.refactoring.util.Visitor;

public class FindConstructorURLHandler
extends URLHandler {
    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] projectArray = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        if (n == 4) {
            SearchConstructorCriteria searchConstructorCriteria = (SearchConstructorCriteria)searchCriteria;
            String string = searchConstructorCriteria.getFqClassName();
            Scope scope = searchConstructorCriteria.getScope();
            projectArray = FindConstructorURLHandler.getIncludedProjects(searchOperation, new String[]{string}, scope);
        }
        return projectArray;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet hashSet = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        if (n == 4) {
            SearchConstructorCriteria searchConstructorCriteria = (SearchConstructorCriteria)searchCriteria;
            String string = searchConstructorCriteria.getClassName();
            hashSet = JavaURLHelper.getJavaURLsContaining((SearchOperationImpl)searchOperation, project, new String[]{string}, searchConstructorCriteria.isSearchInLibraries(), searchConstructorCriteria.isSearchInComments(), searchConstructorCriteria.getScope(), progressIndicator);
        }
        return hashSet;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] uRLArray, ProgressIndicator progressIndicator) {
        UsageModel usageModel = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        if (n == 4) {
            SearchConstructorCriteria searchConstructorCriteria = (SearchConstructorCriteria)searchOperation.getCriteria();
            usageModel = FindConstructorURLHandler.searchMethod(searchConstructorCriteria, project, uRLArray, progressIndicator);
        }
        return usageModel;
    }

    public static UsageModel searchMethod(SearchConstructorCriteria searchConstructorCriteria, Project project, URL[] uRLArray, ProgressIndicator progressIndicator) {
        SourceFile sourceFile;
        URL uRL;
        JavaMethod javaMethod;
        UsageModel usageModel = new UsageModel();
        String string = searchConstructorCriteria.getFqClassName();
        String string2 = searchConstructorCriteria.getClassName();
        ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
        Scope scope = searchConstructorCriteria.getScope();
        JavaManager javaManager = JavaManager.getJavaManager(project);
        JavaClass javaClass = javaManager.getClass(string);
        if (searchConstructorCriteria.hasOverloadedMethods()) {
            javaMethod = null;
        } else {
            String[] stringArray = searchConstructorCriteria.getParameterTypes();
            JavaType[] javaTypeArray = Patch.typeNames2JavaTypes(javaManager, stringArray);
            javaMethod = javaClass.getDeclaredConstructor(javaTypeArray);
        }
        SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
        if (sourceClass != null && scope.isValidPath(contentSet, uRL = (sourceFile = sourceClass.getOwningSourceFile()).getURL())) {
            if (searchConstructorCriteria.hasOverloadedMethods()) {
                Collection collection = sourceClass.getDeclaredConstructors();
                for (SourceMethod sourceMethod : collection) {
                    SourceName sourceName = sourceMethod.getNameElement();
                    usageModel.addUsageEntry(new UsageEntry(project, (SourceElement)sourceName, 0, 1));
                }
            } else {
                SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
                if (sourceMethod != null) {
                    SourceName sourceName = sourceMethod.getNameElement();
                    usageModel.addUsageEntry(new UsageEntry(project, (SourceElement)sourceName, 0, 1));
                }
            }
        }
        int n = 0;
        while (n < uRLArray.length) {
            URL uRL2 = uRLArray[n];
            if (Util.isJavaSource(uRL2) && scope.isValidPath(contentSet, uRL2)) {
                SourceFile sourceFile2 = javaManager.getSourceFile(uRL2);
                1 var26_26 = new 1(string2, javaMethod, string, usageModel, project);
                var26_26.visit((SourceElement)sourceFile2);
            }
            ++n;
        }
        return usageModel;
    }

    public static final class 1
    extends Visitor {
        private final /* synthetic */ String v$className;
        private final /* synthetic */ JavaMethod v$constructor;
        private final /* synthetic */ String v$fqClassName;
        private final /* synthetic */ UsageModel v$usageModel;
        private final /* synthetic */ Project v$project;

        protected void whenEnterClassCreatorExpression(SourceNewClassExpression sourceNewClassExpression) {
            SourceTypeReference sourceTypeReference = sourceNewClassExpression.getSourceType();
            String string = sourceTypeReference.getName();
            boolean bl = false;
            if (string.indexOf(this.v$className) != -1) {
                if (this.v$constructor == null) {
                    JavaType javaType = sourceNewClassExpression.getResolvedType();
                    if (this.v$fqClassName.equals(javaType.getQualifiedName())) {
                        bl = true;
                    }
                } else {
                    JavaMethod javaMethod = sourceNewClassExpression.getResolvedMethod();
                    if (this.v$constructor.equals((Object)javaMethod)) {
                        bl = true;
                    }
                }
            }
            if (bl) {
                SourceName sourceName = sourceTypeReference.getNameElement();
                this.v$usageModel.addUsageEntry(new UsageEntry(this.v$project, (SourceElement)sourceName, 0, 1));
            }
        }

        public 1(String string, JavaMethod javaMethod, String string2, UsageModel usageModel, Project project) {
            this.v$project = project;
            this.v$usageModel = usageModel;
            this.v$fqClassName = string2;
            this.v$constructor = javaMethod;
            this.v$className = string;
        }
    }
}

