/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.search;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.DTCache;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.navigator.Res;
import oracle.jdevimpl.refactoring.dialogs.BaseDialog;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;
import oracle.jdevimpl.refactoring.search.Scope;

public abstract class FindDialog
extends BaseDialog {
    private static final int PREF_COMMENTS = Integer.MIN_VALUE;
    private static final int PREF_NONJAVA = 0x40000000;
    private static final int PREF_LIBRARIES = 0x20000000;
    protected JCheckBox _searchComments;
    protected JCheckBox _searchNonJavaFiles;
    protected JCheckBox _searchLibraries;
    protected JCheckBox _useNewTab;
    private JComboBox _comboBox;
    private static final String DEFAULT_SCOPE_KEY = "SEARCH_DEFAULT_SCOPE";

    public FindDialog(String string, Context context) {
        super(string, context);
    }

    protected JPanel createWherePanel() {
        CopyableInteger copyableInteger = this.getSettings();
        Insets insets = new Insets(2, 2, 2, 2);
        if (this.canSearchComments()) {
            this._searchComments = new JCheckBox();
            this._searchComments.setSelected(copyableInteger.isBitSet(Integer.MIN_VALUE));
            ResourceUtils.resButton((AbstractButton)this._searchComments, (String)RefactoringArb.getString(45));
        }
        if (this.canSearchNonJavaFiles()) {
            this._searchNonJavaFiles = new JCheckBox();
            this._searchNonJavaFiles.setSelected(copyableInteger.isBitSet(0x40000000));
            ResourceUtils.resButton((AbstractButton)this._searchNonJavaFiles, (String)RefactoringArb.getString(46));
        }
        this._searchLibraries = new JCheckBox();
        this._searchLibraries.setSelected(copyableInteger.isBitSet(0x20000000));
        ResourceUtils.resButton((AbstractButton)this._searchLibraries, (String)RefactoringArb.getString(56));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(RefactoringArb.getString(183)));
        if (this._searchComments != null) {
            jPanel.add((Component)this._searchComments, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, insets, 2, 0));
        }
        if (this._searchNonJavaFiles != null) {
            jPanel.add((Component)this._searchNonJavaFiles, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, insets, 2, 0));
        }
        jPanel.add((Component)this._searchLibraries, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, insets, 2, 0));
        return jPanel;
    }

    protected boolean canSearchNonJavaFiles() {
        return true;
    }

    protected boolean canSearchComments() {
        return true;
    }

    protected void updateSettings(CopyableInteger copyableInteger) {
        Object object;
        copyableInteger.setBit(Integer.MIN_VALUE, this.hasSearchComments());
        copyableInteger.setBit(0x40000000, this.hasSearchNonJavaFiles());
        copyableInteger.setBit(0x20000000, this.hasSearchLibraries());
        FindDialog.setPreferNewTabChecked(this.hasUseNewTab());
        if (this._comboBox != null && (object = this._comboBox.getSelectedItem()) != null) {
            Object[] objectArray = (Object[])object;
            String string = (String)objectArray[0];
            DTCache dTCache = Ide.getDTCache();
            dTCache.putString(DEFAULT_SCOPE_KEY, string);
        }
    }

    public boolean hasSearchComments() {
        return this._searchComments != null && this._searchComments.isSelected();
    }

    public boolean hasSearchNonJavaFiles() {
        return this._searchNonJavaFiles != null && this._searchNonJavaFiles.isSelected();
    }

    public boolean hasSearchLibraries() {
        return this._searchLibraries.isSelected();
    }

    public boolean hasUseNewTab() {
        return this._useNewTab.isSelected();
    }

    public Scope getScope() {
        Scope scope;
        Object[] objectArray = (Object[])this._comboBox.getSelectedItem();
        Object object = objectArray[2];
        if (object instanceof Workspace) {
            Workspace workspace = (Workspace)object;
            scope = Scope.createApplicationScope(workspace);
        } else if (object instanceof Project) {
            Project project = (Project)object;
            scope = Scope.createProjectScope(project);
        } else if (object instanceof WorkingSet) {
            WorkingSet workingSet = (WorkingSet)object;
            scope = Scope.createWorkingSetScope(workingSet);
        } else {
            scope = Scope.createDummyScope();
        }
        return scope;
    }

    protected abstract JPanel createWhatPanel();

    protected final void init() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        JPanel jPanel = this.createWhatPanel();
        JPanel jPanel2 = this.createWherePanel();
        this._useNewTab = new JCheckBox();
        this._useNewTab.setSelected(BaseDialog.isPreferNewTabChecked());
        ResourceUtils.resButton((AbstractButton)this._useNewTab, (String)RefactoringArb.getString(57));
        JLabel jLabel = new JLabel();
        DefaultComboBoxModel defaultComboBoxModel = this.createScopeModel();
        this._comboBox = new JComboBox(defaultComboBoxModel);
        this._comboBox.setRenderer(new 1());
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._comboBox, (String)RefactoringArb.getString(184));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        jPanel3.add((Component)this._comboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        int n = 0;
        if (jPanel != null) {
            this.add((Component)jPanel, new GridBagConstraints(n++, 0, 1, 1, 1.0, 1.0, 18, 1, insets, 2, 0));
        }
        this.add((Component)jPanel2, new GridBagConstraints(n++, 0, 1, 1, 1.0, 0.0, 18, 1, insets, 2, 0));
        this.add((Component)jPanel3, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, insets, 2, 0));
        this.add((Component)this._useNewTab, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 18, 3, insets, 2, 0));
        DTCache dTCache = Ide.getDTCache();
        String string = dTCache.getString(DEFAULT_SCOPE_KEY);
        if (string != null) {
            int n2 = defaultComboBoxModel.getSize();
            int n3 = 0;
            while (n3 < n2) {
                Object[] objectArray = (Object[])defaultComboBoxModel.getElementAt(n3);
                Object object = objectArray[0];
                if (string.equals(object)) {
                    defaultComboBoxModel.setSelectedItem(objectArray);
                    break;
                }
                ++n3;
            }
        }
    }

    private DefaultComboBoxModel createScopeModel() {
        DefaultComboBoxModel<Object[]> defaultComboBoxModel = new DefaultComboBoxModel<Object[]>();
        Context context = this.getContext();
        Workspace workspace = context.getWorkspace();
        defaultComboBoxModel.addElement(new Object[]{RefactoringArb.getString(185), IdeIcons.getIcon((int)7), workspace});
        Project project = context.getProject();
        defaultComboBoxModel.addElement(new Object[]{RefactoringArb.getString(186), IdeIcons.getIcon((int)5), project});
        WorkingSets workingSets = WorkingSets.getInstance((Project)project);
        WorkingSet workingSet = workingSets.getCurrentWorkingSet();
        String string = workingSet.getName();
        if (FindDialog.isAcceptableWorkingset(string)) {
            defaultComboBoxModel.addElement(new Object[]{string, Res.getIcon(19), workingSet});
        }
        List list = workingSets.getWorkingSetNames();
        int n = 0;
        while (n < list.size()) {
            String string2 = (String)list.get(n);
            WorkingSet workingSet2 = workingSets.getWorkingSet(string2);
            if (FindDialog.isAcceptableWorkingset(string2) && !string.equals(string2)) {
                Object[] objectArray = new Object[]{workingSet2.getName(), Res.getIcon(19), workingSet2};
                defaultComboBoxModel.addElement(objectArray);
            }
            ++n;
        }
        return defaultComboBoxModel;
    }

    private static final boolean isAcceptableWorkingset(String string) {
        return (WorkingSets.ALL_FILES_WORKING_SET_LABEL.equals(string) || WorkingSets.DEFAULT_WORKING_SET_LABEL.equals(string)) ^ true;
    }

    public final class 1
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object[] objectArray = (Object[])object;
            Object object2 = objectArray[0];
            Icon icon = (Icon)objectArray[1];
            Component component = super.getListCellRendererComponent((JList<?>)jList, object2, n, bl, bl2);
            this.setIcon(icon);
            return component;
        }
    }
}

