/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.search;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.search.FindDialog;

public class FindMethodDialog
extends FindDialog {
    public static final String PREFERENCE_KEY = "FIND_METHOD_DLG_DEFAULTS";
    private static final String ANONYMOUS_NAME = "<Anonymous>";
    private static final int PREF_OVERLOADED = 1;
    private static final int PREF_METHOD_CALLS = 2;
    private static final int PREF_METHOD_DECLS = 4;
    private JavaMethod _javaMethod;
    private JComboBox _cls;
    private JCheckBox _overloaded;
    private JCheckBox _searchMethodCalls;
    private JCheckBox _searchMethodOverrides;

    public FindMethodDialog(Context context, JavaMethod javaMethod) {
        super(PREFERENCE_KEY, context);
        this._javaMethod = javaMethod;
        this.init();
    }

    protected JPanel createWhatPanel() {
        String[] stringArray;
        Container container = null;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(RefactoringArb.getString(150)));
        CopyableInteger copyableInteger = this.getSettings();
        Insets insets = new Insets(2, 2, 2, 2);
        if (!this._javaMethod.isConstructor() && (stringArray = this.getDefiningClasses()).length > 1) {
            JLabel jLabel = new JLabel();
            this._cls = new JComboBox<String>(stringArray);
            this._cls.setSelectedIndex(0);
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this._cls, (String)RefactoringArb.getString(151));
            jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 2, 0));
            jPanel.add((Component)this._cls, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 2, 0));
            container = jPanel;
        }
        if (this.hasOverloadedMethods()) {
            this._overloaded = new JCheckBox();
            this._overloaded.setSelected(copyableInteger.isBitSet(1));
            String string = this._javaMethod.isConstructor() ? RefactoringArb.getString(152) : RefactoringArb.getString(153);
            ResourceUtils.resButton((AbstractButton)this._overloaded, (String)string);
            jPanel.add((Component)this._overloaded, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 0, insets, 2, 0));
            container = jPanel;
        }
        if (!this._javaMethod.isConstructor()) {
            String string = RefactoringArb.getString(181);
            this._searchMethodCalls = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this._searchMethodCalls, (String)string);
            this._searchMethodCalls.setSelected(copyableInteger.isBitSet(2));
            this.updateOnChanges(this._searchMethodCalls);
            jPanel.add((Component)this._searchMethodCalls, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 18, 0, insets, 2, 0));
            if (!this._javaMethod.isFinal()) {
                String string2 = RefactoringArb.getString(182);
                this._searchMethodOverrides = new JCheckBox();
                ResourceUtils.resButton((AbstractButton)this._searchMethodOverrides, (String)string2);
                this._searchMethodOverrides.setSelected(copyableInteger.isBitSet(4));
                jPanel.add((Component)this._searchMethodOverrides, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 18, 0, insets, 2, 0));
                this.updateOnChanges(this._searchMethodOverrides);
            }
            container = jPanel;
        }
        if (container != null) {
            container.add((Component)new JPanel(), new GridBagConstraints(0, 99, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        }
        return container;
    }

    protected String getTitle() {
        String string = Util.getFullMethodName(this._javaMethod, true, false, false);
        String string2 = MessageFormat.format(RefactoringArb.getString(44), string);
        return string2;
    }

    protected int getDefaultPreferences() {
        return 7;
    }

    protected void updateSettings(CopyableInteger copyableInteger) {
        super.updateSettings(copyableInteger);
        copyableInteger.setBit(1, this.hasSearchOverloaded());
        if (this._searchMethodCalls != null) {
            copyableInteger.setBit(2, this._searchMethodCalls.isSelected());
        }
        if (this._searchMethodOverrides != null) {
            copyableInteger.setBit(4, this._searchMethodOverrides.isSelected());
        }
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            if (this._overloaded != null) {
                boolean bl = false;
                if (this._cls == null || this._cls.getSelectedIndex() == 0) {
                    bl = this.hasOverloadedMethods();
                }
                this._overloaded.setEnabled(bl);
            }
            boolean bl = !this._javaMethod.isConstructor() ? this.hasSearchMethodCalls() || this.hasSearchMethodOverrides() : true;
            this.setOKButtonEnabled(bl);
        }
    }

    protected boolean hasOverloadedMethods() {
        boolean bl;
        if (!this._javaMethod.isConstructor()) {
            String string = this._javaMethod.getName();
            JavaClass javaClass = this._javaMethod.getOwningClass();
            int n = 0;
            Collection collection = javaClass.getMethods(string);
            for (JavaMethod javaMethod : collection) {
                if (this._javaMethod.equals((Object)javaMethod)) continue;
                ++n;
            }
            bl = n > 1;
        } else {
            JavaClass javaClass = this._javaMethod.getOwningClass();
            Collection collection = javaClass.getDeclaredConstructors();
            bl = collection.size() > 1;
        }
        return bl;
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._cls;
    }

    protected String getHelpTopicID() {
        return "f1_jed_usages_of_method_dlg_html";
    }

    protected boolean canSearchComments() {
        return this._javaMethod.isConstructor() ^ true;
    }

    protected boolean canSearchNonJavaFiles() {
        return this._javaMethod.isConstructor() ^ true;
    }

    private String[] getDefiningClasses() {
        ArrayList<String> arrayList = new ArrayList<String>();
        JavaClass javaClass = this._javaMethod.getOwningClass();
        String string = javaClass.getQualifiedName();
        String string2 = javaClass.getName().length() > 0 ? string : string + ANONYMOUS_NAME;
        arrayList.add(string2);
        Set set = javaClass.getHierarchy();
        String string3 = this._javaMethod.getName();
        JavaType[] javaTypeArray = Patch.getParameterTypes(this._javaMethod);
        for (JavaClass javaClass2 : set) {
            JavaMethod javaMethod = javaClass2.getMethod(string3, javaTypeArray);
            if (javaMethod == null) continue;
            String string4 = javaClass2.getQualifiedName();
            arrayList.add(string4);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public JavaMethod getSearchedMethod() {
        JavaMethod javaMethod;
        if (this._cls != null) {
            String string = this._cls.getSelectedItem().toString();
            if (string.endsWith(ANONYMOUS_NAME)) {
                javaMethod = this._javaMethod;
            } else {
                Context context = this.getContext();
                Project project = context.getProject();
                JavaManager javaManager = JavaManager.getJavaManager(project);
                JavaClass javaClass = javaManager.getClass(string);
                javaMethod = javaClass.getMethod(this._javaMethod.getName(), this._javaMethod.getParameterTypes());
            }
        } else {
            javaMethod = this._javaMethod;
        }
        return javaMethod;
    }

    public boolean hasSearchOverloaded() {
        return this._overloaded != null && this._overloaded.isSelected() && this._overloaded.isEnabled();
    }

    public boolean hasSearchMethodCalls() {
        return this._searchMethodCalls != null && this._searchMethodCalls.isSelected() && this._searchMethodCalls.isEnabled();
    }

    public boolean hasSearchMethodOverrides() {
        return this._searchMethodOverrides != null && this._searchMethodOverrides.isSelected() && this._searchMethodOverrides.isEnabled();
    }
}

