/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.search;

import java.net.URL;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.Workspace;
import oracle.ide.util.PatternFilters;

public final class Scope {
    private static final int TYPE_ALL = 0;
    private static final int TYPE_WORKSPACE = 1;
    private static final int TYPE_PROJECT = 2;
    private static final int TYPE_WORKINGSET = 3;
    private int _type;
    private Object _object;
    public static final Scope DUMMY_SCOPE = new Scope(0, null);

    private Scope(int n, Object object) {
        this._type = n;
        this._object = object;
    }

    public boolean isValidProject(Project project) {
        switch (this._type) {
            case 2: {
                Project project2 = (Project)this._object;
                return project2.equals((Object)project);
            }
        }
        return true;
    }

    public boolean isValidRelativePath(String string) {
        boolean bl = true;
        switch (this._type) {
            case 3: {
                WorkingSet workingSet = (WorkingSet)this._object;
                PatternFilters patternFilters = workingSet.getPatternFilters();
                bl = patternFilters.isIncluded(string);
            }
        }
        return bl;
    }

    public boolean isValidPath(ContentSet contentSet, URL uRL) {
        boolean bl = true;
        switch (this._type) {
            case 3: {
                String string = contentSet.toRelativePath(uRL);
                if (string == null) break;
                bl = this.isValidRelativePath(string);
            }
        }
        return bl;
    }

    public static final Scope createDummyScope() {
        return DUMMY_SCOPE;
    }

    public static final Scope createApplicationScope(Workspace workspace) {
        return new Scope(1, workspace);
    }

    public static Scope createProjectScope(Project project) {
        return new Scope(2, project);
    }

    public static Scope createWorkingSetScope(WorkingSet workingSet) {
        return new Scope(3, workingSet);
    }
}

