/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.search;

import java.util.Collection;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.jdeveloper.refactoring.criteria.SearchClassCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchConstructorCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchFieldCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchMethodCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchVariableCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.refactoring.model.FieldDescription;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.preview.UsagesLogPage;
import oracle.jdevimpl.refactoring.search.FindClassDialog;
import oracle.jdevimpl.refactoring.search.FindFieldDialog;
import oracle.jdevimpl.refactoring.search.FindMethodDialog;
import oracle.jdevimpl.refactoring.search.Scope;

public class UsageController
implements Controller {
    public boolean update(IdeAction ideAction, Context context) {
        ElementAt elementAt;
        if (context != null && context.getWorkspace() != null && context.getProject() != null && (elementAt = ElementAt.findElementAt(context)) != null) {
            int n = elementAt.getElementType();
            switch (n) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    ideAction.setEnabled(true);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        ElementAt elementAt = ElementAt.findElementAt(context);
        if (elementAt != null) {
            switch (elementAt.getElementType()) {
                case 1: {
                    JavaClass javaClass = (JavaClass)elementAt.getJavaElement();
                    UsageController.whenFindClassUsages(context, javaClass);
                    return true;
                }
                case 4: 
                case 7: {
                    JavaField javaField = (JavaField)elementAt.getJavaElement();
                    UsageController.whenFindFieldUsages(context, javaField);
                    return true;
                }
                case 3: {
                    JavaMethod javaMethod = (JavaMethod)elementAt.getJavaElement();
                    UsageController.whenFindMethodUsages(context, javaMethod);
                    return true;
                }
                case 2: {
                    JavaMethod javaMethod = (JavaMethod)elementAt.getJavaElement();
                    UsageController.whenFindConstructorUsages(context, javaMethod);
                    return true;
                }
                case 5: {
                    SourceVariable sourceVariable = (SourceVariable)elementAt.getSourceElement();
                    SourceFile sourceFile = sourceVariable.getOwningSourceFile();
                    UsageController.whenFindVariableUsages(context, sourceVariable, sourceFile);
                    return true;
                }
            }
        }
        return false;
    }

    public static void whenFindConstructorUsages(Context context, JavaMethod javaMethod) {
        FindMethodDialog findMethodDialog = new FindMethodDialog(context, javaMethod);
        if (findMethodDialog.runDialog()) {
            JavaMember[] javaMemberArray;
            MethodDescription methodDescription = new MethodDescription(javaMethod);
            SearchConstructorCriteria searchConstructorCriteria = new SearchConstructorCriteria(methodDescription);
            boolean bl = findMethodDialog.hasSearchOverloaded();
            searchConstructorCriteria.setIncludeAllocation(true);
            searchConstructorCriteria.setIncludeSuperAndThis(true);
            searchConstructorCriteria.setOverloadedMethods(bl);
            searchConstructorCriteria.setSearchInLibraries(findMethodDialog.hasSearchLibraries());
            searchConstructorCriteria.setScope(findMethodDialog.getScope());
            SearchOperationImpl searchOperationImpl = new SearchOperationImpl(context, searchConstructorCriteria);
            if (bl) {
                JavaClass javaClass = javaMethod.getOwningClass();
                Collection collection = javaClass.getDeclaredConstructors();
                javaMemberArray = collection.toArray(new JavaMember[collection.size()]);
            } else {
                javaMemberArray = new JavaMember[]{javaMethod};
            }
            Util.setOperationHints(searchOperationImpl, javaMemberArray);
            if (searchOperationImpl.doSearch()) {
                boolean bl2 = findMethodDialog.hasUseNewTab();
                UsagesLogPage.showUsages(searchOperationImpl, bl2);
            }
        }
    }

    public static void whenFindClassUsages(Context context, JavaClass javaClass) {
        FindClassDialog findClassDialog = new FindClassDialog(context, javaClass);
        if (findClassDialog.runDialog()) {
            boolean bl = findClassDialog.hasSearchComments();
            boolean bl2 = findClassDialog.hasSearchNonJavaFiles();
            SearchClassCriteria searchClassCriteria = new SearchClassCriteria(ClassDescription.createClassDescription(javaClass), bl, bl2);
            boolean bl3 = findClassDialog.hasFindClass();
            boolean bl4 = findClassDialog.hasFindMembers();
            boolean bl5 = findClassDialog.hasSearchLibraries();
            boolean bl6 = findClassDialog.hasUseNewTab();
            Scope scope = findClassDialog.getScope();
            searchClassCriteria.setInclude(bl3, bl3, bl3, bl3, bl4, bl3);
            searchClassCriteria.setIncludeLibraries(bl5);
            searchClassCriteria.setScope(scope);
            SearchOperationImpl searchOperationImpl = new SearchOperationImpl(context, searchClassCriteria);
            Util.setOperationHints(searchOperationImpl, javaClass, bl4);
            if (searchOperationImpl.doSearch()) {
                UsagesLogPage.showUsages(searchOperationImpl, bl6);
            }
        }
    }

    public static void whenFindFieldUsages(Context context, JavaField javaField) {
        FindFieldDialog findFieldDialog = new FindFieldDialog(context, javaField);
        if (findFieldDialog.runDialog()) {
            FieldDescription fieldDescription = new FieldDescription(javaField);
            SearchFieldCriteria searchFieldCriteria = new SearchFieldCriteria(fieldDescription);
            searchFieldCriteria.setSearchInComments(findFieldDialog.hasSearchComments());
            searchFieldCriteria.setSearchInLibraries(findFieldDialog.hasSearchLibraries());
            searchFieldCriteria.setScope(findFieldDialog.getScope());
            SearchOperationImpl searchOperationImpl = new SearchOperationImpl(context, searchFieldCriteria);
            Util.setOperationHints(searchOperationImpl, new JavaMember[]{javaField});
            if (searchOperationImpl.doSearch()) {
                boolean bl = findFieldDialog.hasUseNewTab();
                UsagesLogPage.showUsages(searchOperationImpl, bl);
            }
        }
    }

    public static void whenFindMethodUsages(Context context, JavaMethod javaMethod) {
        JavaMethod javaMethod2 = javaMethod.getMethodErasure();
        FindMethodDialog findMethodDialog = new FindMethodDialog(context, javaMethod2);
        if (findMethodDialog.runDialog()) {
            boolean bl = findMethodDialog.hasSearchOverloaded();
            boolean bl2 = findMethodDialog.hasSearchMethodCalls();
            boolean bl3 = findMethodDialog.hasSearchMethodOverrides();
            JavaMethod javaMethod3 = findMethodDialog.getSearchedMethod();
            MethodDescription methodDescription = new MethodDescription(javaMethod3);
            SearchMethodCriteria searchMethodCriteria = new SearchMethodCriteria(methodDescription, bl);
            searchMethodCriteria.setIncludeDeclaration(bl3);
            searchMethodCriteria.setIncludeInvocation(bl2);
            searchMethodCriteria.setSearchInComments(findMethodDialog.hasSearchComments());
            searchMethodCriteria.setSearchInLibraries(findMethodDialog.hasSearchLibraries());
            searchMethodCriteria.setScope(findMethodDialog.getScope());
            SearchOperationImpl searchOperationImpl = new SearchOperationImpl(context, searchMethodCriteria);
            Util.setOperationHints(searchOperationImpl, (JavaMember)javaMethod2, bl);
            boolean bl4 = findMethodDialog.hasUseNewTab();
            if (searchOperationImpl.doSearch()) {
                UsagesLogPage.showUsages(searchOperationImpl, bl4);
            }
        }
    }

    private static void whenFindVariableUsages(Context context, SourceVariable sourceVariable, SourceFile sourceFile) {
        SearchVariableCriteria searchVariableCriteria = new SearchVariableCriteria(sourceVariable, sourceFile, false);
        SearchOperationImpl searchOperationImpl = new SearchOperationImpl(context, searchVariableCriteria);
        if (searchOperationImpl.doSearch()) {
            UsagesLogPage.showUsages(searchOperationImpl, false);
        }
    }
}

