/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.util;

import java.util.Collection;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInfixExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceQuestionExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceTypecastExpression;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdevimpl.refactoring.jotpatch.Patch;

public class ExpressionUtil {
    public static JavaType getExpectedType(SourceExpression sourceExpression) {
        JavaType javaType = null;
        SourceElement sourceElement = sourceExpression.getParent();
        while (sourceElement != null) {
            int n = sourceElement.getSymbolKind();
            switch (n) {
                case 2: {
                    return null;
                }
                case 49: {
                    SourceAssignmentExpression sourceAssignmentExpression = (SourceAssignmentExpression)sourceElement;
                    SourceExpression sourceExpression2 = sourceAssignmentExpression.getFirstOperand();
                    if (!Patch.contains((SourceElement)sourceExpression2, (SourceElement)sourceExpression)) {
                        javaType = sourceExpression2.getResolvedType();
                    }
                    return javaType;
                }
                case 17: {
                    SourceLocalVariable sourceLocalVariable = (SourceLocalVariable)sourceElement;
                    if (Patch.contains((SourceElement)sourceLocalVariable.getInitializer(), (SourceElement)sourceExpression)) {
                        javaType = sourceLocalVariable.getResolvedType();
                    }
                    return javaType;
                }
                case 54: 
                case 56: {
                    SourceInvokeExpression sourceInvokeExpression = (SourceInvokeExpression)sourceElement;
                    SourceExpression sourceExpression3 = sourceInvokeExpression.getLhsOperand();
                    if (sourceExpression3 != null && Patch.contains((SourceElement)sourceExpression3, (SourceElement)sourceExpression)) {
                        JavaMethod javaMethod = sourceInvokeExpression.getResolvedMethod();
                        if (javaMethod != null) {
                            javaType = javaMethod.getOwningClass();
                        }
                    } else {
                        Collection collection;
                        JavaVariable[] javaVariableArray;
                        int n2;
                        JavaMethod javaMethod = sourceInvokeExpression.getResolvedMethod();
                        if (javaMethod != null && (n2 = Patch.getArgumentPos(sourceInvokeExpression, (SourceElement)sourceExpression)) >= 0 && n2 < (javaVariableArray = (collection = javaMethod.getParameters()).toArray(new JavaVariable[collection.size()])).length) {
                            JavaVariable javaVariable = javaVariableArray[n2];
                            javaType = javaVariable.getResolvedType();
                        }
                    }
                    return javaType;
                }
                case 41: {
                    SourceMethod sourceMethod = (SourceMethod)Util.getAncestorOfClass(SourceMethod.class, sourceElement);
                    if (sourceMethod != null) {
                        javaType = sourceMethod.getReturnType();
                    }
                    return javaType;
                }
                case 60: {
                    SourceTypecastExpression sourceTypecastExpression = (SourceTypecastExpression)sourceElement;
                    javaType = sourceTypecastExpression.getResolvedType();
                    return javaType;
                }
                case 48: 
                case 50: 
                case 52: 
                case 62: {
                    break;
                }
                case 61: {
                    break;
                }
                case 57: {
                    SourceQuestionExpression sourceQuestionExpression = (SourceQuestionExpression)sourceElement;
                    SourceExpression sourceExpression4 = sourceQuestionExpression.getFirstOperand();
                    if (sourceExpression4 == null || !Patch.contains((SourceElement)sourceExpression4, (SourceElement)sourceExpression)) break;
                    PrimitiveType primitiveType = CommonUtilities.getPrimitiveType((String)"boolean");
                    return primitiveType;
                }
                case 51: {
                    SourceInfixExpression sourceInfixExpression = (SourceInfixExpression)sourceElement;
                    int n3 = sourceInfixExpression.getOperatorCode();
                    switch (n3) {
                        case 20: {
                            SourceExpression sourceExpression5 = sourceInfixExpression.getFirstOperand();
                            SourceExpression sourceExpression6 = Patch.contains((SourceElement)sourceExpression5, (SourceElement)sourceExpression) ? sourceInfixExpression.getSecondOperand() : sourceExpression5;
                            if (!sourceExpression6.getText().equals("null")) {
                                JavaType javaType2 = sourceExpression6.getResolvedType();
                                return javaType2;
                            }
                            return null;
                        }
                    }
                    return null;
                }
                default: {
                    if (!(sourceElement instanceof SourceExpression)) break;
                    SourceExpression sourceExpression7 = (SourceExpression)sourceElement;
                    System.out.println(ExpressionUtil.class.getName() + ": " + "Unhandled expression: " + sourceExpression7.getClass().getName());
                    System.out.println("Please report");
                    return null;
                }
            }
            sourceElement = sourceElement.getParent();
        }
        return null;
    }
}

