/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.util;

import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLPath;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.MultiMap;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.usage.UsageManager;
import oracle.jdeveloper.usage.UsageQueryTask;
import oracle.jdeveloper.usage.event.ConstructorUsageEvent;
import oracle.jdeveloper.usage.event.ConstructorUsageListener;
import oracle.jdeveloper.usage.event.FieldUsageEvent;
import oracle.jdeveloper.usage.event.FieldUsageListener;
import oracle.jdeveloper.usage.event.MethodUsageEvent;
import oracle.jdeveloper.usage.event.MethodUsageListener;
import oracle.jdeveloper.usage.event.UsageEvent;
import oracle.jdeveloper.usage.keyword.KeywordBatchQueryTask;
import oracle.jdeveloper.usage.keyword.KeywordIndex;
import oracle.jdevimpl.refactoring.util.Visitor;

public class FindMemberUsages {
    public ArrayList _members;
    private MultiMap _keywordHits;

    public FindMemberUsages(JavaMember javaMember) {
        this._members = new ArrayList(1);
        this._members.add(javaMember);
    }

    public FindMemberUsages(JavaMember[] javaMemberArray) {
        this._members = new ArrayList<JavaMember>(Arrays.asList(javaMemberArray));
    }

    public void findMemberUsages(Project project, JotUsageListener jotUsageListener) {
        HashSet<JavaMember> hashSet = new HashSet<JavaMember>(this._members.size());
        HashSet hashSet2 = new HashSet();
        HashSet<String> hashSet3 = new HashSet<String>();
        int n = 0;
        while (n < this._members.size()) {
            JavaMember javaMember = (JavaMember)this._members.get(n);
            hashSet.add(javaMember);
            if (javaMember.getElementKind() == 8) {
                JavaMethod javaMethod = (JavaMethod)javaMember;
                if (javaMethod.isConstructor()) {
                    JavaClass javaClass = javaMember.getOwningClass();
                    String string = javaClass.getName();
                    hashSet3.add(string);
                    hashSet3.add("this");
                    hashSet3.add("super");
                } else {
                    hashSet3.add(javaMember.getName());
                }
            } else {
                hashSet3.add(javaMember.getName());
            }
            ++n;
        }
        URL[] uRLArray = this.findMemberUsages(project);
        JavaManager javaManager = JavaManager.getJavaManager(project);
        int n2 = 0;
        while (n2 < uRLArray.length) {
            URL uRL = uRLArray[n2];
            SourceFile sourceFile = javaManager.getSourceFile(uRL);
            if (sourceFile != null) {
                1 var16_16 = new 1(this, hashSet, jotUsageListener, hashSet3, hashSet2);
                var16_16.visit((SourceElement)sourceFile);
            }
            ++n2;
        }
    }

    private void verifyHits(Project project, MyUsageListener myUsageListener) {
        UsageManager usageManager = null;
        JavaManager javaManager = null;
        int n = 0;
        while (n < this._members.size()) {
            boolean bl;
            JavaMember javaMember = (JavaMember)this._members.get(n);
            String string = FindMemberUsages.getMemberName(javaMember);
            List list = this._keywordHits.get((Object)string);
            URL[] uRLArray = list.toArray(new URL[list.size()]);
            JavaClass javaClass = javaMember.getOwningClass();
            String string2 = javaClass.getQualifiedName();
            boolean bl2 = string2.endsWith(".");
            boolean bl3 = bl = !bl2;
            if (bl) {
                JavaField javaField;
                JavaType javaType;
                if (usageManager == null) {
                    usageManager = new UsageManager(project);
                }
                UsageQueryTask usageQueryTask = null;
                if (javaMember instanceof JavaMethod) {
                    JavaMethod javaMethod = (JavaMethod)javaMember;
                    String[] stringArray = Util.getFqParamTypes(javaMethod);
                    usageQueryTask = javaMethod.isConstructor() ? usageManager.findConstructorUsages(string2, stringArray, myUsageListener, uRLArray) : usageManager.findMethodUsages(string2, string, stringArray, myUsageListener, uRLArray);
                } else if (javaMember instanceof JavaField && (javaType = (javaField = (JavaField)javaMember).getResolvedType()) != null) {
                    String string3 = javaType.getQualifiedName();
                    usageQueryTask = usageManager.findFieldUsages(string2, string3, string, myUsageListener, uRLArray);
                }
                if (usageQueryTask != null) {
                    Util.waitUntilFinished(usageQueryTask);
                }
            } else {
                if (javaManager == null) {
                    javaManager = JavaManager.getJavaManager(project);
                }
                switch (javaMember.getElementKind()) {
                    case 8: {
                        JavaMethod javaMethod = (JavaMethod)javaMember;
                        if (javaMethod.isConstructor()) {
                            this.findConstuctorUsages(javaManager, javaMethod, uRLArray, myUsageListener);
                            break;
                        }
                        this.findMethodUsages(javaManager, javaMethod, uRLArray, myUsageListener);
                        break;
                    }
                    case 5: {
                        JavaField javaField = (JavaField)javaMember;
                        this.findFieldUsages(javaManager, javaField, uRLArray, myUsageListener);
                    }
                }
                myUsageListener.notifyFinished(new UsageEvent(null, 0));
            }
            ++n;
        }
    }

    private void findConstuctorUsages(JavaManager javaManager, JavaMethod javaMethod, URL[] uRLArray, ConstructorUsageListener constructorUsageListener) {
        JavaClass javaClass = javaMethod.getOwningClass();
        String string = javaClass.getName();
        int n = 0;
        while (n < uRLArray.length) {
            URL uRL = uRLArray[n];
            SourceFile sourceFile = javaManager.getSourceFile(uRL);
            if (sourceFile != null) {
                List list = SourceElementAsList.asList((SourceElement)sourceFile, new int[]{21, 67});
                int n2 = 0;
                while (n2 < list.size()) {
                    SourceElement sourceElement = (SourceElement)list.get(n2);
                    block0 : switch (sourceElement.getSymbolKind()) {
                        case 21: {
                            SourceMethodCallExpression sourceMethodCallExpression;
                            SourceElement sourceElement2;
                            SourceName sourceName = (SourceName)sourceElement;
                            String string2 = sourceName.getName();
                            if (string.equals(string2)) {
                                SourceElement sourceElement3 = sourceName.getParent();
                                switch (sourceElement3.getSymbolKind()) {
                                    case 56: {
                                        SourceNewClassExpression sourceNewClassExpression = (SourceNewClassExpression)sourceElement3;
                                        if (!javaMethod.equals((Object)sourceNewClassExpression)) break block0;
                                        ConstructorUsageEvent constructorUsageEvent = new ConstructorUsageEvent(null, 304, uRL, sourceName.getStartOffset(), sourceName.getEndOffset());
                                        constructorUsageListener.notifyConstructorUsage(constructorUsageEvent);
                                        break;
                                    }
                                    case 6: {
                                        SourceMethod sourceMethod = (SourceMethod)sourceElement3;
                                        if (javaMethod.equals((Object)sourceMethod)) {
                                            ConstructorUsageEvent constructorUsageEvent = new ConstructorUsageEvent(null, 301, uRL, sourceName.getStartOffset(), sourceName.getEndOffset());
                                            constructorUsageListener.notifyConstructorUsage(constructorUsageEvent);
                                        } else {
                                            break;
                                        }
                                    }
                                }
                                break;
                            }
                            if (!"this".equals(string2) && !"super".equals(string2) || (sourceElement2 = sourceName.getParent()).getSymbolKind() != 54 || !javaMethod.equals((Object)(sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement2))) break;
                            ConstructorUsageEvent constructorUsageEvent = new ConstructorUsageEvent(null, "this".equals(string2) ? 302 : 303, uRL, sourceName.getStartOffset(), sourceName.getEndOffset());
                            constructorUsageListener.notifyConstructorUsage(constructorUsageEvent);
                        }
                    }
                    ++n2;
                }
            } else {
                constructorUsageListener.notifySkipped(new UsageEvent(null, 3, uRL));
            }
            ++n;
        }
    }

    private void findMethodUsages(JavaManager javaManager, JavaMethod javaMethod, URL[] uRLArray, MethodUsageListener methodUsageListener) {
        String string = javaMethod.getName();
        int n = 0;
        while (n < uRLArray.length) {
            URL uRL = uRLArray[n];
            SourceFile sourceFile = javaManager.getSourceFile(uRL);
            if (sourceFile != null) {
                List list = SourceElementAsList.asList((SourceElement)sourceFile, new int[]{21, 67});
                int n2 = 0;
                while (n2 < list.size()) {
                    SourceElement sourceElement = (SourceElement)list.get(n2);
                    block0 : switch (sourceElement.getSymbolKind()) {
                        case 21: {
                            SourceName sourceName = (SourceName)sourceElement;
                            String string2 = sourceName.getName();
                            if (!string.equals(string2)) break;
                            SourceElement sourceElement2 = sourceName.getParent();
                            switch (sourceElement2.getSymbolKind()) {
                                case 54: {
                                    SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement2;
                                    JavaMethod javaMethod2 = sourceMethodCallExpression.getResolvedMethod();
                                    if (!javaMethod.equals((Object)javaMethod2)) break block0;
                                    MethodUsageEvent methodUsageEvent = new MethodUsageEvent(null, 402, uRL, sourceName.getStartOffset(), sourceName.getEndOffset());
                                    methodUsageListener.notifyMethodUsage(methodUsageEvent);
                                    break;
                                }
                                case 19: {
                                    SourceMethod sourceMethod = (SourceMethod)sourceElement2;
                                    if (javaMethod.equals((Object)sourceMethod)) {
                                        MethodUsageEvent methodUsageEvent = new MethodUsageEvent(null, 401, uRL, sourceName.getStartOffset(), sourceName.getEndOffset());
                                        methodUsageListener.notifyMethodUsage(methodUsageEvent);
                                    } else {
                                        break;
                                    }
                                }
                            }
                            break;
                        }
                        case 67: {
                            JavaMember javaMember;
                            SourceDocReference sourceDocReference = (SourceDocReference)sourceElement;
                            String string3 = sourceDocReference.getText();
                            if (string3.indexOf(string) == -1 || !javaMethod.equals((Object)(javaMember = sourceDocReference.getResolvedMember()))) break;
                            MethodUsageEvent methodUsageEvent = new MethodUsageEvent(null, 4, uRL, sourceDocReference.getStartOffset(), sourceDocReference.getEndOffset());
                            methodUsageListener.notifyMethodUsage(methodUsageEvent);
                        }
                    }
                    ++n2;
                }
            } else {
                methodUsageListener.notifySkipped(new UsageEvent(null, 3, uRL));
            }
            ++n;
        }
    }

    private void findFieldUsages(JavaManager javaManager, JavaField javaField, URL[] uRLArray, FieldUsageListener fieldUsageListener) {
        String string = javaField.getName();
        int n = 0;
        while (n < uRLArray.length) {
            URL uRL = uRLArray[n];
            SourceFile sourceFile = javaManager.getSourceFile(uRL);
            if (sourceFile != null) {
                List list = SourceElementAsList.asList((SourceElement)sourceFile, new int[]{21, 67});
                int n2 = 0;
                while (n2 < list.size()) {
                    SourceElement sourceElement = (SourceElement)list.get(n2);
                    block0 : switch (sourceElement.getSymbolKind()) {
                        case 21: {
                            SourceName sourceName = (SourceName)sourceElement;
                            String string2 = sourceName.getName();
                            if (!string.equals(string2)) break;
                            SourceElement sourceElement2 = sourceName.getParent();
                            switch (sourceElement2.getSymbolKind()) {
                                case 50: 
                                case 58: {
                                    SourceExpression sourceExpression = (SourceExpression)sourceElement2;
                                    JavaHasType javaHasType = sourceExpression.getResolvedObject();
                                    if (!javaField.equals(javaHasType)) break block0;
                                    FieldUsageEvent fieldUsageEvent = new FieldUsageEvent(null, 202, uRL, sourceName.getStartOffset(), sourceName.getEndOffset());
                                    fieldUsageListener.notifyFieldUsage(fieldUsageEvent);
                                    break;
                                }
                                case 10: {
                                    SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)sourceElement2;
                                    if (javaField.equals(sourceFieldVariable)) {
                                        FieldUsageEvent fieldUsageEvent = new FieldUsageEvent(null, 201, uRL, sourceName.getStartOffset(), sourceName.getEndOffset());
                                        fieldUsageListener.notifyFieldUsage(fieldUsageEvent);
                                    } else {
                                        break;
                                    }
                                }
                            }
                            break;
                        }
                        case 67: {
                            JavaMember javaMember;
                            SourceDocReference sourceDocReference = (SourceDocReference)sourceElement;
                            if (!sourceDocReference.getText().endsWith(string) || !javaField.equals(javaMember = sourceDocReference.getResolvedMember())) break;
                            FieldUsageEvent fieldUsageEvent = new FieldUsageEvent(null, 201, uRL, sourceDocReference.getStartOffset(), sourceDocReference.getEndOffset());
                            fieldUsageListener.notifyFieldUsage(fieldUsageEvent);
                        }
                    }
                    ++n2;
                }
            } else {
                fieldUsageListener.notifySkipped(new UsageEvent(null, 3, uRL));
            }
            ++n;
        }
    }

    private MultiMap searchKeywords(Project project) {
        String[] stringArray = this.getSearchKeywords();
        MultiMap multiMap = new MultiMap();
        URLPath uRLPath = PathsConfiguration.getInstance(project).getProjectSourcePath();
        URL[] uRLArray = uRLPath.getEntries();
        int n = 0;
        while (n < uRLArray.length) {
            URL uRL = uRLArray[n];
            KeywordIndex keywordIndex = KeywordIndex.getKeywordIndex(uRL);
            KeywordBatchQueryTask keywordBatchQueryTask = keywordIndex.getBatchQueryTask(stringArray);
            while (!keywordBatchQueryTask.isFinished()) {
                try {
                    Thread.sleep(25);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            URL[][] uRLArray2 = keywordBatchQueryTask.getBatchQueryResult();
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string = stringArray[n2];
                URL[] uRLArray3 = uRLArray2[n2];
                multiMap.addAll((Object)string, Arrays.asList(uRLArray3));
                ++n2;
            }
            ++n;
        }
        return multiMap;
    }

    private String[] getSearchKeywords() {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < this._members.size()) {
            JavaMember javaMember = (JavaMember)this._members.get(n);
            String string = FindMemberUsages.getMemberName(javaMember);
            hashSet.add(string);
            ++n;
        }
        String[] stringArray = hashSet.toArray(new String[hashSet.size()]);
        return stringArray;
    }

    private static String getMemberName(JavaMember javaMember) {
        JavaMethod javaMethod;
        if (javaMember.getElementKind() == 8 && (javaMethod = (JavaMethod)javaMember).isConstructor()) {
            JavaClass javaClass = javaMember.getOwningClass();
            String string = javaClass.getName();
            return string;
        }
        String string = javaMember.getName();
        return string;
    }

    public URL[] findMemberUsages(Project project) {
        this._keywordHits = this.searchKeywords(project);
        MyUsageListener myUsageListener = new MyUsageListener(project);
        this.verifyHits(project, myUsageListener);
        return myUsageListener.getUrls();
    }

    public final class 1
    extends Visitor {
        private final /* synthetic */ HashSet v$memberSet;
        private final /* synthetic */ JotUsageListener v$usageListener;
        private final /* synthetic */ HashSet v$memberNames;
        private final /* synthetic */ HashSet v$notMembersSet;
        final /* synthetic */ FindMemberUsages this$0;

        protected void whenEnterClassCreatorExpression(SourceNewClassExpression sourceNewClassExpression) {
            JavaMethod javaMethod = sourceNewClassExpression.getResolvedMethod();
            if (this.v$memberSet.contains(javaMethod)) {
                this.v$usageListener.whenMethodUsage((SourceInvokeExpression)sourceNewClassExpression);
            }
        }

        protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
            JavaMethod javaMethod;
            String string = sourceMethodCallExpression.getName();
            if (this.v$memberNames.contains(string) && (javaMethod = sourceMethodCallExpression.getResolvedMethod()) != null) {
                if (this.v$memberSet.contains(javaMethod)) {
                    this.v$usageListener.whenMethodUsage((SourceInvokeExpression)sourceMethodCallExpression);
                } else if (!this.v$notMembersSet.contains(javaMethod)) {
                    if (!javaMethod.isStatic()) {
                        boolean bl = false;
                        Collection collection = javaMethod.getOverriddenMethods();
                        Iterator iterator = collection.iterator();
                        while (!bl && iterator.hasNext()) {
                            JavaMethod javaMethod2 = (JavaMethod)iterator.next();
                            if (!this.v$memberSet.contains(javaMethod2)) continue;
                            this.v$usageListener.whenMethodUsage((SourceInvokeExpression)sourceMethodCallExpression);
                            bl = true;
                        }
                        if (bl) {
                            for (JavaMethod javaMethod3 : collection) {
                                this.v$memberSet.add(javaMethod3);
                                if (javaMethod != javaMethod3) {
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.v$notMembersSet.addAll(collection);
                        }
                    } else {
                        this.v$notMembersSet.add(javaMethod);
                    }
                }
            }
        }

        protected void whenEnterDotExpression(SourceDotExpression sourceDotExpression) {
            JavaHasType javaHasType;
            String string = sourceDotExpression.getName();
            if (this.v$memberNames.contains(string) && this.v$memberSet.contains(javaHasType = sourceDotExpression.getResolvedObject())) {
                this.v$usageListener.whenFieldUsage((SourceExpression)sourceDotExpression);
            }
        }

        protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
            JavaHasType javaHasType;
            String string = sourceSimpleNameExpression.getName();
            if (this.v$memberNames.contains(string) && this.v$memberSet.contains(javaHasType = sourceSimpleNameExpression.getResolvedObject())) {
                this.v$usageListener.whenFieldUsage((SourceExpression)sourceSimpleNameExpression);
            }
        }

        protected void whenEnterConstructorDeclaration(SourceMethod sourceMethod) {
            JavaClass javaClass;
            String string;
            if (this.v$memberSet.contains(sourceMethod)) {
                this.v$usageListener.whenMethodDeclaration(sourceMethod);
            } else if (!this.v$notMembersSet.contains(sourceMethod) && this.v$memberNames.contains(string = (javaClass = sourceMethod.getOwningClass()).getName())) {
                if (this.v$memberSet.contains(sourceMethod)) {
                    this.v$usageListener.whenMethodDeclaration(sourceMethod);
                } else {
                    this.v$notMembersSet.add(sourceMethod);
                }
            }
        }

        protected void whenEnterMethodDeclaration(SourceMethod sourceMethod) {
            String string;
            if (this.v$memberSet.contains(sourceMethod)) {
                this.v$usageListener.whenMethodDeclaration(sourceMethod);
            } else if (!this.v$notMembersSet.contains(sourceMethod) && this.v$memberNames.contains(string = sourceMethod.getName())) {
                Collection collection = sourceMethod.getOverriddenMethods();
                if (IdeUtil.containsAny((AbstractCollection)this.v$memberSet, (Collection)collection)) {
                    this.v$memberSet.addAll(collection);
                    this.v$usageListener.whenMethodDeclaration(sourceMethod);
                } else {
                    this.v$notMembersSet.addAll(collection);
                }
            }
        }

        public 1(FindMemberUsages findMemberUsages, HashSet hashSet, JotUsageListener jotUsageListener, HashSet hashSet2, HashSet hashSet3) {
            this.v$notMembersSet = hashSet3;
            this.v$memberNames = hashSet2;
            this.v$usageListener = jotUsageListener;
            this.v$memberSet = hashSet;
            this.this$0 = findMemberUsages;
        }
    }

    public static class JotUsageListener {
        public void whenMethodDeclaration(SourceMethod sourceMethod) {
        }

        public void whenMethodUsage(SourceInvokeExpression sourceInvokeExpression) {
        }

        public void whenFieldUsage(SourceExpression sourceExpression) {
        }
    }

    private static class MyUsageListener
    implements ConstructorUsageListener,
    FieldUsageListener,
    MethodUsageListener {
        private HashSet _verifiedUrls;
        private ContentSet _allContents;

        void $init$() {
            this._verifiedUrls = new HashSet();
        }

        public MyUsageListener(Project project) {
            this.$init$();
            this._allContents = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
        }

        public void notifyMethodUsage(MethodUsageEvent methodUsageEvent) {
            URL uRL = methodUsageEvent.getURL();
            if (this._allContents.canHaveMember(uRL)) {
                this._verifiedUrls.add(uRL);
            }
        }

        public void notifyConstructorUsage(ConstructorUsageEvent constructorUsageEvent) {
            URL uRL = constructorUsageEvent.getURL();
            if (this._allContents.canHaveMember(uRL)) {
                this._verifiedUrls.add(uRL);
            }
        }

        public void notifyFieldUsage(FieldUsageEvent fieldUsageEvent) {
            URL uRL;
            int n = fieldUsageEvent.getUsageCode();
            if (n == 202 && this._allContents.canHaveMember(uRL = fieldUsageEvent.getURL())) {
                this._verifiedUrls.add(uRL);
            }
        }

        public void notifyFinished(UsageEvent usageEvent) {
        }

        public void notifySkipped(UsageEvent usageEvent) {
        }

        public URL[] getUrls() {
            return this._verifiedUrls.toArray(new URL[this._verifiedUrls.size()]);
        }
    }

    public static class FillListsUsageListener
    extends JotUsageListener {
        private final List _methodDeclarations;
        private final List _sourceInvokeExpressions;
        private final List _sourceExpressions;

        public FillListsUsageListener(List list, List list2, List list3) {
            this._methodDeclarations = list;
            this._sourceInvokeExpressions = list2;
            this._sourceExpressions = list3;
        }

        public List getSourceExpressions() {
            return this._sourceExpressions;
        }

        public List getSourceInvokeExpressions() {
            return this._sourceInvokeExpressions;
        }

        public List getSourceMethods() {
            return this._methodDeclarations;
        }

        public void whenMethodDeclaration(SourceMethod sourceMethod) {
            if (this._methodDeclarations != null) {
                this._methodDeclarations.add(sourceMethod);
            }
        }

        public void whenMethodUsage(SourceInvokeExpression sourceInvokeExpression) {
            if (this._sourceInvokeExpressions != null) {
                this._sourceInvokeExpressions.add(sourceInvokeExpression);
            }
        }

        public void whenFieldUsage(SourceExpression sourceExpression) {
            if (this._sourceExpressions != null) {
                this._sourceExpressions.add(sourceExpression);
            }
        }
    }
}

