/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.util;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import oracle.ide.util.Pair;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdeveloper.icons.JavaIcons;
import oracle.jdeveloper.refactoring.util.Util;

public class JotListCellRenderer
extends DefaultListCellRenderer {
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object instanceof Pair) {
            Pair pair = (Pair)object;
            return this.getListCellRendererComponent(jList, pair.first, n, bl, bl2);
        }
        Icon icon = null;
        if (object instanceof SourceElement) {
            SourceElement sourceElement = (SourceElement)object;
            int n2 = sourceElement.getSymbolKind();
            switch (n2) {
                case 3: {
                    SourceClass sourceClass = (SourceClass)sourceElement;
                    object = sourceClass.getName();
                    if (sourceClass.isInterface()) {
                        icon = JavaIcons.getIcon(1);
                        break;
                    }
                    icon = JavaIcons.getIcon(0);
                    break;
                }
                case 19: {
                    SourceMethod sourceMethod = (SourceMethod)sourceElement;
                    object = Util.getFullMethodName((JavaMethod)sourceMethod, false, false, false);
                    icon = JavaIcons.getIcon(3);
                    break;
                }
                case 9: {
                    SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)sourceElement;
                    SourceTypeReference sourceTypeReference = sourceFieldVariable.getSourceType();
                    String string = sourceTypeReference.getName();
                    object = sourceFieldVariable.getName() + ":" + string;
                    icon = JavaIcons.getIcon(2);
                }
            }
        }
        Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        this.setIcon(icon);
        return component;
    }
}

