/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import oracle.ide.util.BitField;
import oracle.ide.util.IdeUtil;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceCatchClause;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdevimpl.refactoring.jotpatch.Patch;

public class JotNaming {
    public static final NameFormater FIELD_FORMATER = new NameFormater(NameFormater.ra$TYPE_FIELD(), null);
    public static final NameFormater CONSTANT_FORMATER = new NameFormater(NameFormater.ra$TYPE_CONSTANT(), null);
    public static final NameFormater VARIABLE_FORMATER = new NameFormater(NameFormater.ra$TYPE_VARIABLE(), null);
    public static final NameFormater PARAMETER_FORMATER = new NameFormater(NameFormater.ra$TYPE_PARAM(), null);
    private static HashMap _altNames;

    public static boolean canIntroduceVariable(SourceElement sourceElement, String string) {
        boolean bl = true;
        if (JotNaming.isNameDefinedInParents(sourceElement.getParent(), sourceElement, string)) {
            bl = false;
        } else {
            SourceElement sourceElement2 = JotNaming.getNameInChildrenScope(sourceElement);
            if (JotNaming.isNameDefinedInChildren(sourceElement2, string)) {
                bl = false;
            } else {
                CallerContext callerContext = CallerContext.createContext((SourceElement)sourceElement);
                JavaHasType javaHasType = callerContext.resolveExpressionName(string);
                if (javaHasType != null) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private static SourceElement getNameInChildrenScope(SourceElement sourceElement) {
        SourceElement sourceElement2 = sourceElement.getParent();
        switch (sourceElement2.getSymbolKind()) {
            case 2: 
            case 9: {
                return sourceElement2;
            }
            case 3: {
                return sourceElement;
            }
            case 19: {
                SourceMethod sourceMethod = (SourceMethod)sourceElement2;
                SourceBlock sourceBlock = sourceMethod.getBlock();
                if (sourceBlock != null) {
                    return sourceBlock;
                }
                return sourceMethod;
            }
        }
        return JotNaming.getNameInChildrenScope(sourceElement2);
    }

    private static boolean isNameDefinedInChildren(SourceElement sourceElement, String string) {
        boolean bl = false;
        List list = sourceElement.getChildren();
        int n = 0;
        while (!bl && n < list.size()) {
            SourceElement sourceElement2 = (SourceElement)list.get(n);
            switch (sourceElement2.getSymbolKind()) {
                case 17: {
                    SourceLocalVariable sourceLocalVariable = (SourceLocalVariable)sourceElement2;
                    if (!string.equals(sourceLocalVariable.getName())) break;
                    bl = true;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    bl = JotNaming.isNameDefinedInChildren(sourceElement2, string);
                }
            }
            ++n;
        }
        return bl;
    }

    private static boolean isNameDefinedInParents(SourceElement sourceElement, SourceElement sourceElement2, String string) {
        boolean bl = false;
        if (sourceElement.getSymbolKind() != 4) {
            List list = sourceElement.getChildren();
            int n = 0;
            while (!bl && n < list.size()) {
                SourceElement sourceElement3 = (SourceElement)list.get(n);
                if (sourceElement2 != sourceElement3 && sourceElement3.getSymbolKind() == 18) {
                    SourceLocalVariableDeclaration sourceLocalVariableDeclaration = (SourceLocalVariableDeclaration)sourceElement3;
                    List list2 = sourceLocalVariableDeclaration.getVariables();
                    int n2 = 0;
                    while (n2 < list2.size()) {
                        SourceVariable sourceVariable = (SourceVariable)list2.get(n2);
                        if (sourceVariable != null && string.equals(sourceVariable)) {
                            bl = true;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            if (!bl) {
                bl = JotNaming.isNameDefinedInParents(sourceElement.getParent(), sourceElement, string);
            }
        }
        return bl;
    }

    public static List suggestNamesFromCamelWord(String string) {
        return JotNaming.suggestNamesFromCamelWord(string, null);
    }

    public static List suggestNamesFromCamelWord(String string, NameFormater nameFormater) {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (n == 0 || Character.isUpperCase(c)) {
                String string2;
                String string3 = Character.toLowerCase(c) + string.substring(n + 1);
                String string4 = string2 = nameFormater == null ? string3 : nameFormater.toString(string3);
                if (!IdeUtil.isJavaReservedWord((String)string2)) {
                    hashSet.add(string2);
                } else {
                    String string5 = JotNaming.getAltName(string2);
                    if (string5 != null) {
                        hashSet.add(string5);
                    }
                }
            }
            ++n;
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList);
        return arrayList;
    }

    private static Collection suggestNamesFromCamelWord(String string, Collection collection, NameFormater nameFormater) {
        List list = JotNaming.suggestNamesFromCamelWord(string, nameFormater);
        list.removeAll(collection);
        return list;
    }

    private static String getAltName(String string) {
        if (_altNames == null) {
            _altNames = new HashMap();
            _altNames.put("boolean", "b");
            _altNames.put("byte", "i");
            _altNames.put("short", "i");
            _altNames.put("int", "i");
            _altNames.put("long", "i");
            _altNames.put("char", "c");
            _altNames.put("float", "f");
            _altNames.put("double", "f");
            _altNames.put("class", "cls");
        }
        return (String)_altNames.get(string);
    }

    public static List suggestVariableNames(SourceElement sourceElement, String string) {
        return JotNaming.suggestNames(sourceElement, string, VARIABLE_FORMATER);
    }

    public static List suggestParameterNames(SourceElement sourceElement, String string) {
        return JotNaming.suggestNames(sourceElement, string, PARAMETER_FORMATER);
    }

    public static List suggestFieldNames(SourceElement sourceElement, String string) {
        return JotNaming.suggestNames(sourceElement, string, FIELD_FORMATER);
    }

    public static List suggestConstantNames(SourceElement sourceElement, String string) {
        return JotNaming.suggestNames(sourceElement, string, CONSTANT_FORMATER);
    }

    private static ArrayList suggestNames(SourceElement sourceElement, String string, NameFormater nameFormater) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet hashSet2 = new HashSet();
        JotNaming.fillWithParentVariableDeclaration(sourceElement, hashSet2);
        JotNaming.fillWithMembers(sourceElement, hashSet2);
        int n = sourceElement.getSymbolKind();
        switch (n) {
            case 54: {
                SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement;
                String string2 = sourceMethodCallExpression.getName();
                if (JotNaming.suggestNamesForAccessor(hashSet, string2, "get", true, hashSet2, nameFormater) || JotNaming.suggestNamesForAccessor(hashSet, string2, "is", false, hashSet2, nameFormater) || JotNaming.suggestNamesForAccessor(hashSet, string2, "has", false, hashSet2, nameFormater) || JotNaming.suggestNamesForAccessor(hashSet, string2, "can", false, hashSet2, nameFormater)) break;
                Collection collection = JotNaming.suggestNamesFromCamelWord(string2, hashSet2, nameFormater);
                hashSet.addAll(collection);
                break;
            }
            case 50: {
                SourceDotExpression sourceDotExpression = (SourceDotExpression)sourceElement;
                JotNaming.suggestNameForFieldAccess(nameFormater, hashSet2, hashSet, sourceDotExpression);
                break;
            }
            default: {
                String string3;
                if (!(sourceElement instanceof SourceHasName)) break;
                SourceHasName sourceHasName = (SourceHasName)sourceElement;
                String string4 = JotNaming.getBaseName(sourceHasName);
                String string5 = string3 = nameFormater == null ? string4 : nameFormater.toString(string4);
                if (hashSet2.contains(string3)) break;
                hashSet.add(string3);
            }
        }
        if (string != null) {
            int n2;
            int n3;
            int n4;
            int n5 = string.lastIndexOf(46);
            if (n5 >= 0) {
                string = string.substring(n5 + 1);
            }
            if ((n4 = string.lastIndexOf(36)) >= 0) {
                string = string.substring(n4 + 1);
            }
            if ((n3 = string.indexOf(91)) >= 0) {
                string = string.substring(0, n3);
            }
            if ((n2 = string.indexOf(60)) >= 0) {
                string = string.substring(0, n2);
            }
            Collection collection = JotNaming.suggestNamesFromCamelWord(string, hashSet2, nameFormater);
            hashSet.addAll(collection);
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList);
        return arrayList;
    }

    private static String getBaseName(SourceHasName sourceHasName) {
        String string = sourceHasName.getName();
        if (sourceHasName instanceof SourceSimpleNameExpression) {
            CodingStyleManager codingStyleManager = CodingStyleManager.getCodingStyleManager();
            CodingStyleOptions codingStyleOptions = codingStyleManager.getCodingStyleOptions();
            String[][] stringArrayArray = new String[][]{{codingStyleOptions.getFieldPrefix(), codingStyleOptions.getFieldSuffix()}, {codingStyleOptions.getStaticFieldPrefix(), codingStyleOptions.getStaticFieldSuffix()}, {codingStyleOptions.getParameterPrefix(), codingStyleOptions.getParameterSuffix()}, {codingStyleOptions.getLocalVariablePrefix(), codingStyleOptions.getLocalVariableSuffix()}};
            boolean bl = false;
            int n = 0;
            while (!bl && n < stringArrayArray.length) {
                String[] stringArray = stringArrayArray[n];
                if (stringArray[0] != null && string.startsWith(stringArray[0]) || stringArray[1] != null && string.endsWith(stringArray[1])) {
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                int n2;
                SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceHasName;
                JavaHasType javaHasType = sourceSimpleNameExpression.getResolvedObject();
                switch (javaHasType.getElementKind()) {
                    case 5: {
                        JavaField javaField = (JavaField)javaHasType;
                        n2 = javaField.isStatic() ? 1 : 0;
                        break;
                    }
                    case 7: {
                        JavaLocalVariable javaLocalVariable = (JavaLocalVariable)javaHasType;
                        SourceVariable sourceVariable = (SourceVariable)javaLocalVariable.getSourceElement();
                        n2 = sourceVariable.getSymbolKind() == 13 ? 2 : 3;
                        break;
                    }
                    default: {
                        n2 = -1;
                    }
                }
                String[] stringArray = stringArrayArray[n2];
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                if (string2 != null && string.startsWith(string2)) {
                    string = string.substring(string2.length());
                }
                if (string3 != null && string.endsWith(string3)) {
                    string = string.substring(0, string.length() - string3.length());
                }
            }
        }
        return string;
    }

    private static void suggestNameForFieldAccess(NameFormater nameFormater, HashSet hashSet, Collection collection, SourceDotExpression sourceDotExpression) {
        String string = sourceDotExpression.getName();
        int n = string.lastIndexOf(95);
        if ((string = string.substring(n + 1)).length() > 0) {
            Collection collection2 = JotNaming.suggestNamesFromCamelWord(string, hashSet, nameFormater);
            collection.addAll(collection2);
        }
    }

    private static boolean suggestNamesForAccessor(Collection collection, String string, String string2, boolean bl, HashSet hashSet, NameFormater nameFormater) {
        if (string.startsWith(string2)) {
            String string3 = bl ? string.substring(string2.length()) : string;
            Collection collection2 = JotNaming.suggestNamesFromCamelWord(string3, hashSet, nameFormater);
            collection.addAll(collection2);
            return true;
        }
        return false;
    }

    private static void fillWithMembers(SourceElement sourceElement, HashSet hashSet) {
        JavaType javaType = (JavaType)Util.getAncestorOfClass(SourceClass.class, sourceElement);
        while (javaType != null) {
            Collection collection = javaType.getDeclaredFields();
            for (JavaField javaField : collection) {
                String string = javaField.getName();
                hashSet.add(string);
            }
            javaType = javaType.getSuperclass();
        }
    }

    public static void fillWithParentVariableDeclaration(SourceElement sourceElement, HashSet hashSet) {
        while (sourceElement != null) {
            int n = sourceElement.getSymbolKind();
            if (n == 19 || n == 5 || n == 6) {
                return;
            }
            SourceElement sourceElement2 = sourceElement.getParent();
            if (sourceElement2 != null) {
                JotNaming.fillWithVariableDeclarations(sourceElement2, hashSet);
                SourceElement[] sourceElementArray = sourceElement2.getContainedElements();
                int n2 = 0;
                while (n2 < sourceElementArray.length) {
                    SourceElement sourceElement3 = sourceElementArray[n2];
                    if (sourceElement3 != sourceElement) {
                        JotNaming.fillWithVariableDeclarations(sourceElement3, hashSet);
                    }
                    ++n2;
                }
            }
            sourceElement = sourceElement2;
        }
    }

    private static void fillWithVariableDeclarations(SourceElement sourceElement, HashSet hashSet) {
        int n = sourceElement.getSymbolKind();
        switch (n) {
            case 18: {
                SourceLocalVariableDeclaration sourceLocalVariableDeclaration = (SourceLocalVariableDeclaration)sourceElement;
                List list = sourceLocalVariableDeclaration.getVariables();
                for (SourceVariable sourceVariable : list) {
                    String string = sourceVariable.getName();
                    hashSet.add(string);
                }
                break;
            }
            case 19: {
                SourceMethod sourceMethod = (SourceMethod)sourceElement;
                Collection collection = sourceMethod.getParameters();
                for (JavaVariable javaVariable : collection) {
                    String string = javaVariable.getName();
                    hashSet.add(string);
                }
                break;
            }
            case 32: {
                SourceCatchClause sourceCatchClause = (SourceCatchClause)sourceElement;
                SourceVariable sourceVariable = sourceCatchClause.getCatchVariable();
                String string = sourceVariable.getName();
                hashSet.add(string);
                break;
            }
            case 39: {
                SourceForStatement sourceForStatement = (SourceForStatement)sourceElement;
                if (sourceForStatement.getForType() != 1) break;
                List list = sourceForStatement.getForVariables();
                for (SourceVariable sourceVariable : list) {
                    String string = sourceVariable.getName();
                    hashSet.add(string);
                }
                break;
            }
        }
    }

    public static String canIntroduceField(SourceElement sourceElement, String string) {
        String string2 = null;
        if (!IdeUtil.isJavaIdentifier((String)string)) {
            string2 = RefactoringArb.getString(130);
        } else if (IdeUtil.isJavaReservedWord((String)string)) {
            string2 = RefactoringArb.getString(130);
        } else if (JotNaming.isFieldAlreadyPresent(sourceElement, string)) {
            string2 = MessageFormat.format(RefactoringArb.getString(131), string);
        }
        return string2;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isFieldAlreadyPresent(SourceElement var0, String var1_1) {
        var2_2 = (SourceClass)Util.getAncestorOfClass(SourceClass.class, var0.getParent());
        if (Patch.getJavaField((JavaType)var2_2, var1_1) == null) ** GOTO lbl8
        return true;
lbl-1000:
        // 1 sources

        {
            var3_3 = Patch.getJavaField((JavaType)var2_2, var1_1);
            if (var3_3 != null && !BitField.isSet((int)(var4_4 = var3_3.getModifiers()), (int)2)) {
                return true;
            }
            var2_2 = var2_2.getSuperclass();
lbl8:
            // 2 sources

            ** while (var2_2 != null)
        }
lbl9:
        // 1 sources

        return false;
    }

    public static class NameFormater {
        private static final int TYPE_FIELD = 1;
        private static final int TYPE_CONSTANT = 2;
        private static final int TYPE_VARIABLE = 3;
        private static final int TYPE_PARAM = 4;
        private int _type;

        private NameFormater(int n) {
            this._type = n;
        }

        public String toString(String string) {
            CodingStyleManager codingStyleManager = CodingStyleManager.getCodingStyleManager();
            CodingStyleOptions codingStyleOptions = codingStyleManager.getCodingStyleOptions();
            string = string.substring(string.lastIndexOf(46) + 1);
            string = string.substring(string.lastIndexOf(36) + 1);
            switch (this._type) {
                case 1: {
                    string = NameFormater.lowCapName(string);
                    return codingStyleOptions.getFieldName(string);
                }
                case 2: {
                    return codingStyleOptions.getStaticFieldName(string).toUpperCase();
                }
                case 3: {
                    string = NameFormater.lowCapName(string);
                    return codingStyleOptions.getLocalVariableName(string);
                }
                case 4: {
                    string = NameFormater.lowCapName(string);
                    return codingStyleOptions.getParameterName(string);
                }
            }
            return null;
        }

        private static String lowCapName(String string) {
            string = string.length() > 1 ? Character.toLowerCase(string.charAt(0)) + string.substring(1) : Character.toString(Character.toLowerCase(string.charAt(0)));
            return string;
        }

        static int ra$TYPE_FIELD() {
            return TYPE_FIELD;
        }

        NameFormater(int n, 1 var2_2) {
            this(n);
        }

        static int ra$TYPE_CONSTANT() {
            return TYPE_CONSTANT;
        }

        static int ra$TYPE_VARIABLE() {
            return TYPE_VARIABLE;
        }

        static int ra$TYPE_PARAM() {
            return TYPE_PARAM;
        }

        public final class 1 {
        }
    }
}

