/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.util;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;

public class MemberAccess {
    /*
     * Enabled aggressive block sorting
     */
    public static Set getAccessedMembers(SourceElement sourceElement) {
        HashSet<Object> hashSet = new HashSet<Object>();
        List list = SourceElementAsList.asList(sourceElement);
        int n = 0;
        while (n < list.size()) {
            SourceElement sourceElement2 = (SourceElement)list.get(n);
            int n2 = sourceElement2.getSymbolKind();
            switch (n2) {
                case 28: {
                    SourceTypeReference sourceTypeReference = (SourceTypeReference)sourceElement2;
                    JavaType javaType = sourceTypeReference.getResolvedType();
                    if (javaType == null || javaType.isPublic()) break;
                    if (javaType.isArray()) {
                        javaType = javaType.getComponentType();
                    }
                    javaType = javaType.getTypeErasure();
                    hashSet.add(javaType);
                    break;
                }
                case 54: 
                case 56: {
                    SourceInvokeExpression sourceInvokeExpression = (SourceInvokeExpression)sourceElement2;
                    JavaMethod javaMethod = sourceInvokeExpression.getResolvedMethod();
                    if (javaMethod == null || javaMethod.isPublic()) break;
                    hashSet.add(javaMethod);
                    break;
                }
                case 50: 
                case 58: {
                    SourceExpression sourceExpression = (SourceExpression)sourceElement2;
                    JavaHasType javaHasType = sourceExpression.getResolvedObject();
                    if (javaHasType == null) break;
                    int n3 = javaHasType.getElementKind();
                    switch (n3) {
                        case 5: {
                            JavaField javaField = (JavaField)javaHasType;
                            if (javaField.isPublic()) break;
                            hashSet.add(javaField);
                        }
                    }
                    break;
                }
            }
            ++n;
        }
        return hashSet;
    }

    public static boolean updateAccessModifiers(RefactoringCommandSupport refactoringCommandSupport, SourceElement sourceElement, SourceClass sourceClass) {
        SourceFile sourceFile;
        boolean bl = true;
        SourceFile sourceFile2 = sourceElement.getOwningSourceFile();
        boolean bl2 = sourceFile2.equals(sourceFile = sourceClass.getOwningSourceFile());
        if (!bl2) {
            Set set = MemberAccess.getAccessedMembers(sourceElement);
            String string = sourceFile2.getPackageName();
            String string2 = sourceFile.getPackageName();
            boolean bl3 = string.equals(string2);
            ArrayList<JavaMember> arrayList = new ArrayList<JavaMember>();
            for (JavaMember javaMember : set) {
                if (javaMember.isPrivate()) {
                    arrayList.add(javaMember);
                    continue;
                }
                if (bl3 || !javaMember.isPackagePrivate() && !javaMember.isProtected()) continue;
                arrayList.add(javaMember);
            }
            if (arrayList.size() > 0) {
                bl = MemberAccess.confirmAndUpdateAccessModifiers(refactoringCommandSupport, arrayList);
            }
        }
        return bl;
    }

    public static boolean confirmAndUpdateAccessModifiers(RefactoringCommandSupport refactoringCommandSupport, Collection collection) {
        boolean bl = false;
        Collection collection2 = MemberAccess.confirmMembers(collection);
        if (collection2 != null) {
            MemberAccess.updateConfirmedMembers(refactoringCommandSupport, collection2);
            bl = true;
        }
        return bl;
    }

    public static Collection confirmMembers(Collection collection) {
        ArrayList<JavaMember> arrayList = Collections.EMPTY_LIST;
        int n = collection.size();
        if (n > 0) {
            Object[] objectArray = new String[]{" ", RefactoringArb.getString(357), RefactoringArb.getString(358)};
            Object[][] objectArray2 = new Object[n][3];
            Iterator iterator = collection.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                String string;
                JavaMember javaMember = (JavaMember)iterator.next();
                int n3 = javaMember.getElementKind();
                switch (n3) {
                    case 3: {
                        JavaClass javaClass = (JavaClass)javaMember;
                        string = javaClass.getQualifiedName();
                        break;
                    }
                    case 5: {
                        JavaField javaField = (JavaField)javaMember;
                        JavaClass javaClass = javaField.getOwningClass();
                        String string2 = javaClass.getQualifiedName();
                        String string3 = javaField.getName();
                        string = string2 + "." + string3;
                        break;
                    }
                    case 8: {
                        JavaMethod javaMethod = (JavaMethod)javaMember;
                        string = Util.getFullMethodName(javaMethod, true, true, false);
                        break;
                    }
                    default: {
                        string = "???";
                    }
                }
                objectArray2[n2][0] = Boolean.TRUE;
                objectArray2[n2][1] = string;
                objectArray2[n2][2] = "public";
                ++n2;
            }
            1 var16_16 = new 1(objectArray2, objectArray);
            NiceTable niceTable = new NiceTable((TableModel)var16_16);
            niceTable.setAutoResizeMode(0);
            niceTable.autoSizeColumnsToFit();
            JLabel jLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)jLabel, (Component)niceTable, (String)RefactoringArb.getString(359));
            JScrollPane jScrollPane = new JScrollPane((Component)niceTable);
            jScrollPane.getViewport().setBackground(niceTable.getBackground());
            JPanel jPanel = new JPanel(new GridBagLayout());
            Insets insets = new Insets(2, 2, 2, 2);
            jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
            HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_jrf_dconfirmaccssbltychng_html");
            JEWTDialog jEWTDialog = new JEWTDialog((Frame)Ide.getMainWindow(), RefactoringArb.getString(360), 7);
            jEWTDialog.setContent((Component)jPanel);
            jEWTDialog.setResizable(true);
            if (jEWTDialog.runDialog()) {
                arrayList = new ArrayList<JavaMember>(collection.size());
                Iterator iterator2 = collection.iterator();
                int n4 = 0;
                while (iterator2.hasNext()) {
                    JavaMember javaMember = (JavaMember)iterator2.next();
                    Object object = var16_16.getValueAt(n4, 0);
                    if (Boolean.TRUE.equals(object)) {
                        arrayList.add(javaMember);
                    }
                    ++n4;
                }
            } else {
                arrayList = null;
            }
        }
        return arrayList;
    }

    public static void updateConfirmedMembers(RefactoringCommandSupport refactoringCommandSupport, Collection collection) {
        for (JavaMember javaMember : collection) {
            SourceMember sourceMember = (SourceMember)javaMember.getSourceElement();
            if (sourceMember == null) continue;
            refactoringCommandSupport.beginTransaction((SourceElement)sourceMember);
            sourceMember.removeModifiers(6);
            sourceMember.addModifiers(1);
        }
    }

    public static final class 1
    extends DefaultTableModel {
        public Class getColumnClass(int n) {
            if (n != 0) {
                return super.getColumnClass(n);
            }
            return Boolean.class;
        }

        public 1(Object[][] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
        }
    }
}

