/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.util;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import oracle.ide.model.Project;
import oracle.ide.util.BitField;
import oracle.ide.util.IdeUtil;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.util.JotNaming;

public class NameValidation {
    private boolean _valid;
    private String _message;

    private NameValidation() {
    }

    private NameValidation(boolean bl, String string) {
        this._valid = bl;
        this._message = string;
    }

    public static NameValidation validateMethod(SourceMethod sourceMethod, String string) {
        NameValidation nameValidation = NameValidation.validateMethodName(string, true);
        if (nameValidation.isValid() && NameValidation.isMethodAlreadyPresent(sourceMethod, string)) {
            nameValidation.setMessage(RefactoringArb.getString(72));
            nameValidation.setValid(false);
        }
        return nameValidation;
    }

    public static NameValidation validateMethodName(String string, boolean bl) {
        NameValidation nameValidation = new NameValidation();
        String string2 = null;
        boolean bl2 = true;
        if (string.length() == 0) {
            bl2 = false;
            if (!bl) {
                string2 = RefactoringArb.getString(180);
            }
        } else if (!IdeUtil.isJavaIdentifier((String)string)) {
            string2 = RefactoringArb.getString(71);
            bl2 = false;
        } else if (IdeUtil.isJavaReservedWord((String)string)) {
            string2 = RefactoringArb.getString(71);
            bl2 = false;
        } else if (Character.isUpperCase(string.charAt(0))) {
            string2 = RefactoringArb.getString(73);
        }
        nameValidation.setMessage(string2);
        nameValidation.setValid(bl2);
        return nameValidation;
    }

    public static NameValidation validateClassName(Project project, String string, String string2, boolean bl) {
        NameValidation nameValidation = new NameValidation();
        String string3 = "";
        boolean bl2 = true;
        if (string2.length() == 0) {
            bl2 = false;
        } else if (!IdeUtil.isJavaIdentifier((String)string2)) {
            string3 = RefactoringArb.getString(103);
            bl2 = false;
        } else if (string2.lastIndexOf(36) >= 0) {
            string3 = RefactoringArb.getString(103);
            bl2 = false;
        } else if (IdeUtil.isJavaReservedWord((String)string2)) {
            string3 = RefactoringArb.getString(103);
            bl2 = false;
        } else if (bl && NameValidation.isClassAlreadyPresent(project, string, string2)) {
            string3 = MessageFormat.format(RefactoringArb.getString(36), string2);
            bl2 = false;
        } else if (!Character.isUpperCase(string2.charAt(0))) {
            string3 = RefactoringArb.getString(104);
        }
        nameValidation.setMessage(string3);
        nameValidation.setValid(bl2);
        return nameValidation;
    }

    public static NameValidation validateFieldName(String string, boolean bl, SourceElement sourceElement) {
        String string2 = "";
        boolean bl2 = true;
        if (string != null && string.length() == 0) {
            bl2 = false;
        } else {
            String string3 = JotNaming.canIntroduceField(sourceElement, string);
            if (string3 != null) {
                string2 = string3;
                bl2 = false;
            } else if (!bl) {
                if (Character.isUpperCase(string.charAt(0))) {
                    string2 = RefactoringArb.getString(63);
                }
            } else if (!NameValidation.isGoodConstantName(string)) {
                string2 = RefactoringArb.getString(64);
            }
        }
        NameValidation nameValidation = new NameValidation(bl2, string2);
        return nameValidation;
    }

    public static boolean isGoodConstantName(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (Character.isLetter(c) && Character.isLowerCase(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isClassAlreadyPresent(Project project, String string, String string2) {
        JavaManager javaManager = JavaManager.getJavaManager(project);
        String string3 = string.length() == 0 ? string2 : string + "." + string2;
        SourceClass sourceClass = javaManager.getSourceClass(string3);
        return sourceClass != null;
    }

    private void setValid(boolean bl) {
        this._valid = bl;
    }

    public boolean isValid() {
        return this._valid;
    }

    private void setMessage(String string) {
        this._message = string;
    }

    public String getMessage() {
        return this._message;
    }

    private static boolean isMethodAlreadyPresent(SourceMethod sourceMethod, String string) {
        SourceClass sourceClass = sourceMethod.getEnclosingClass();
        Collection collection = sourceMethod.getParameters();
        JavaHasType[] javaHasTypeArray = collection.toArray(new JavaHasType[collection.size()]);
        return NameValidation.isMethodAlreadyPresent(sourceClass, string, javaHasTypeArray);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isMethodAlreadyPresent(SourceClass var0, String var1_1, JavaHasType[] var2_2) {
        var3_3 = var0;
        var4_4 = var0.getSourceMethods();
        if (var4_4.size() == 0) ** GOTO lbl19
        var5_5 = CallerContext.createContext((SourceElement)((SourceElement)var4_4.get(0)));
        var6_6 = new JavaType[var2_2.length];
        var7_7 = 0;
        while (var7_7 < var6_6.length) {
            var6_6[var7_7] = var2_2[var7_7].getResolvedType();
            ++var7_7;
        }
        var8_8 = var5_5.resolveMethod(null, var1_1, var6_6);
        if (var8_8 == null) ** GOTO lbl19
        return true;
lbl-1000:
        // 1 sources

        {
            if (NameValidation.isMethodAlreadyPresent((JavaType)var0, (JavaType)var3_3, var1_1, var2_2)) {
                return true;
            }
            if (NameValidation.recIsMethodPresentInItface((JavaType)var0, (JavaType)var3_3, var1_1, var2_2)) {
                return true;
            }
            var3_3 = var3_3.getSuperclass();
lbl19:
            // 3 sources

            ** while (var3_3 != null)
        }
lbl20:
        // 1 sources

        return false;
    }

    private static boolean recIsMethodPresentInItface(JavaType javaType, JavaType javaType2, String string, JavaHasType[] javaHasTypeArray) {
        Collection collection = javaType2.getInterfaces();
        for (JavaType javaType3 : collection) {
            if (!NameValidation.isMethodAlreadyPresent(javaType, javaType3, string, javaHasTypeArray)) continue;
            return true;
        }
        for (JavaType javaType4 : collection) {
            NameValidation.recIsMethodPresentInItface(javaType, javaType4, string, javaHasTypeArray);
        }
        return false;
    }

    private static boolean isMethodAlreadyPresent(JavaType javaType, JavaType javaType2, String string, JavaHasType[] javaHasTypeArray) {
        JavaType[] javaTypeArray = Patch.javaHasTypes2JavaTypes(Arrays.asList(javaHasTypeArray));
        JavaMethod javaMethod = javaType2.getMethod(string, javaTypeArray);
        if (javaMethod != null) {
            int n = javaMethod.getModifiers();
            if (BitField.isSet((int)n, (int)1) || BitField.isSet((int)n, (int)4)) {
                return true;
            }
            if (BitField.isSet((int)n, (int)2)) {
                return javaType == javaType2;
            }
            return javaType.getPackageName().equals(javaType2.getPackageName());
        }
        return false;
    }
}

