/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.util;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

public class RadioKeyController
extends AbstractAction {
    private static final KeyStroke KEY_UP = KeyStroke.getKeyStroke(38, 0);
    private static final KeyStroke KEY_LEFT = KeyStroke.getKeyStroke(37, 0);
    private static final KeyStroke KEY_DOWN = KeyStroke.getKeyStroke(40, 0);
    private static final KeyStroke KEY_RIGHT = KeyStroke.getKeyStroke(39, 0);
    private AbstractButton[] _buttons;
    private int _direction;
    private static final String UP_ACTION_KEY = "UP";
    private static final String DOWN_ACTION_KEY = "DOWN";

    private RadioKeyController(AbstractButton[] abstractButtonArray, int n) {
        this._direction = n;
        this._buttons = abstractButtonArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.getSelectedButton();
        int n2 = n + this._direction;
        int n3 = n2 >= 0 ? n2 % this._buttons.length : this._buttons.length - 1;
        AbstractButton abstractButton = this._buttons[n3];
        abstractButton.setSelected(true);
        abstractButton.requestFocus();
    }

    private int getSelectedButton() {
        int n = 0;
        while (n < this._buttons.length) {
            AbstractButton abstractButton = this._buttons[n];
            if (abstractButton.isSelected()) {
                return n;
            }
            ++n;
        }
        return -this._direction;
    }

    public static void attach(ButtonGroup buttonGroup) {
        AbstractButton[] abstractButtonArray = RadioKeyController.getButtons(buttonGroup);
        RadioKeyController radioKeyController = new RadioKeyController(abstractButtonArray, -1);
        RadioKeyController radioKeyController2 = new RadioKeyController(abstractButtonArray, 1);
        int n = 0;
        while (n < abstractButtonArray.length) {
            AbstractButton abstractButton = abstractButtonArray[n];
            InputMap inputMap = abstractButton.getInputMap(0);
            inputMap.put(KEY_UP, UP_ACTION_KEY);
            inputMap.put(KEY_LEFT, UP_ACTION_KEY);
            inputMap.put(KEY_DOWN, DOWN_ACTION_KEY);
            inputMap.put(KEY_RIGHT, DOWN_ACTION_KEY);
            ActionMap actionMap = abstractButton.getActionMap();
            actionMap.put(UP_ACTION_KEY, radioKeyController);
            actionMap.put(DOWN_ACTION_KEY, radioKeyController2);
            ++n;
        }
    }

    private static AbstractButton[] getButtons(ButtonGroup buttonGroup) {
        ArrayList<AbstractButton> arrayList = new ArrayList<AbstractButton>();
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            arrayList.add(abstractButton);
        }
        AbstractButton[] abstractButtonArray = arrayList.toArray(new AbstractButton[arrayList.size()]);
        return abstractButtonArray;
    }
}

