/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdevimpl.refactoring.util.Visitor;

public class RichBuffer
implements Transferable {
    public static final DataFlavor FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref; class=" + RichBuffer.class.getName(), "Java Code");
    private static final DataFlavor[] _flavors = new DataFlavor[]{FLAVOR, DataFlavor.stringFlavor};
    private String _text;
    private ClassUseEntry[] _fqClassNames;

    public static RichBuffer createJotRichBuffer(SourceFile sourceFile, int n, int n2) {
        URL uRL = sourceFile.getURL();
        TextNode textNode = (TextNode)NodeFactory.find((URL)uRL);
        TextBuffer textBuffer = textNode.acquireTextBuffer();
        String string = textBuffer.getString(n, n2 - n);
        ClassUseEntry[] classUseEntryArray = RichBuffer.containsImportsOrPackageDirective(sourceFile, n, n2) ? new ClassUseEntry[]{} : RichBuffer.extractImports((SourceElement)sourceFile, n, n2);
        RichBuffer richBuffer = new RichBuffer(string, classUseEntryArray);
        richBuffer.setText(string);
        return richBuffer;
    }

    private static boolean containsImportsOrPackageDirective(SourceFile sourceFile, int n, int n2) {
        2 var3_3 = new 2(n, n2);
        var3_3.visit((SourceElement)sourceFile);
        return var3_3.getUserData() != null;
    }

    public static String[] getNecessaryImports(SourceFile sourceFile, int n, int n2) {
        ClassUseEntry[] classUseEntryArray = RichBuffer.extractImports((SourceElement)sourceFile, n, n2);
        String[] stringArray = RichBuffer.toImportArray(classUseEntryArray);
        return stringArray;
    }

    private static String[] toImportArray(ClassUseEntry[] classUseEntryArray) {
        String[] stringArray = new String[classUseEntryArray.length];
        int n = 0;
        while (n < classUseEntryArray.length) {
            stringArray[n] = classUseEntryArray[n].fqName;
            ++n;
        }
        return stringArray;
    }

    private static ClassUseEntry[] extractImports(SourceElement sourceElement, int n, int n2) {
        HashMap hashMap = new HashMap();
        HashSet hashSet = new HashSet();
        new 1(n, n2, hashMap, hashSet).visit(sourceElement);
        String[] stringArray = hashSet.toArray(new String[hashSet.size()]);
        int n3 = 0;
        while (n3 < stringArray.length) {
            String string = stringArray[n3];
            hashMap.remove(stringArray[n3]);
            ++n3;
        }
        Object[] objectArray = hashMap.values().toArray(new ClassUseEntry[hashMap.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private RichBuffer(String string, ClassUseEntry[] classUseEntryArray) {
        this._text = string;
        this._fqClassNames = classUseEntryArray;
    }

    private void dump() {
        String[] stringArray = this.getFQClassNames();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            System.out.println("import " + string + ";");
            ++n;
        }
        System.out.print("\n\n");
        System.out.println(this._text);
    }

    public String getText() {
        return this._text;
    }

    public void setText(String string) {
        this._text = string;
    }

    public String getFqText(String[] stringArray) {
        ArrayList<ReplaceItem> arrayList = new ArrayList<ReplaceItem>();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < this._fqClassNames.length) {
                if (stringArray[n].equals(this._fqClassNames[n2].fqName)) {
                    ArrayList arrayList2 = this._fqClassNames[n2].usedPos;
                    int n3 = 0;
                    while (n3 < arrayList2.size()) {
                        TextSegment textSegment = (TextSegment)arrayList2.get(n3);
                        arrayList.add(new ReplaceItem(stringArray[n], textSegment.start, textSegment.end));
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
        Object[] objectArray = arrayList.toArray(new ReplaceItem[arrayList.size()]);
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer(this._text.length() * 2);
        int n4 = 0;
        int n5 = 0;
        while (n5 < objectArray.length) {
            Object object = objectArray[n5];
            if (n4 < ((ReplaceItem)object).start) {
                stringBuffer.append(this._text.substring(n4, ((ReplaceItem)object).start));
            }
            stringBuffer.append(((ReplaceItem)object).text);
            n4 = ((ReplaceItem)object).end;
            ++n5;
        }
        if (n4 < this._text.length()) {
            stringBuffer.append(this._text.substring(n4));
        }
        return stringBuffer.toString();
    }

    public String[] getFQClassNames() {
        return RichBuffer.toImportArray(this._fqClassNames);
    }

    public String[] getMissingImports(SourceFile sourceFile) {
        String[] stringArray = this.getFQClassNames();
        return RichBuffer.getMissingImports(sourceFile, stringArray);
    }

    public static String[] getMissingImports(SourceFile sourceFile, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = sourceFile.getSourceImports();
        HashSet<String> hashSet = new HashSet<String>(list.size());
        for (SourceImport sourceImport : list) {
            String string = sourceImport.getName();
            hashSet.add(string);
        }
        String string = sourceFile.getPackageName();
        int n = 0;
        while (n < stringArray.length) {
            String string2;
            String string3;
            int n2;
            String string4 = stringArray[n];
            if (!(hashSet.contains(string4) || (n2 = string4.lastIndexOf(46)) == -1 || hashSet.contains(string3 = (string2 = string4.substring(0, n2)) + ".*") || string.equals(string2))) {
                arrayList.add(string4);
            }
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static int getAddedImports(BasicDocument basicDocument, String[] stringArray, SourceFile sourceFile, HashSet hashSet, HashSet hashSet2) {
        int n;
        List list = sourceFile.getSourceImports();
        String string = sourceFile.getPackageName();
        JavaProvider javaProvider = sourceFile.getProvider();
        String[] stringArray2 = new String[stringArray.length];
        if (javaProvider != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string2 = stringArray[n2];
                JavaClass javaClass = javaProvider.getClass(string2);
                if (javaClass != null) {
                    stringArray2[n2] = javaClass.getPackageName();
                    if (!string.equals(stringArray2[n2]) && !"java.lang".equals(stringArray2[n2])) {
                        hashSet.add(string2);
                    }
                }
                ++n2;
            }
        }
        LineMap lineMap = basicDocument.getLineMap();
        if (!list.isEmpty()) {
            SourceImport[] sourceImportArray = list.toArray(new SourceImport[list.size()]);
            int n3 = 0;
            while (n3 < sourceImportArray.length) {
                SourceImport sourceImport = sourceImportArray[n3];
                String string3 = sourceImport.getName();
                if (string3.endsWith("*")) {
                    String string4 = string3.substring(0, string3.lastIndexOf(46));
                    int n4 = 0;
                    while (n4 < stringArray2.length) {
                        if (string4.equals(stringArray2[n4])) {
                            hashSet.remove(stringArray[n4]);
                        }
                        ++n4;
                    }
                } else {
                    hashSet.remove(string3);
                }
                ++n3;
            }
            SourceImport sourceImport = sourceImportArray[sourceImportArray.length - 1];
            int n5 = sourceImport.getEndOffset();
            int n6 = lineMap.getLineFromOffset(n5);
            n = lineMap.getLineEndOffset(n6);
        } else {
            SourcePackage sourcePackage = sourceFile.getSourcePackage();
            if (sourcePackage != null) {
                int n7 = sourcePackage.getEndOffset();
                int n8 = lineMap.getLineFromOffset(n7);
                n = lineMap.getLineEndOffset(n8);
            } else {
                n = 0;
            }
        }
        if (hashSet.size() != 0) {
            HashSet<String> hashSet3 = new HashSet<String>();
            RichBuffer.addAllImportedClasses(javaProvider, string, hashSet3);
            SourceImport[] sourceImportArray = list.toArray(new SourceImport[list.size()]);
            int n9 = 0;
            while (n9 < sourceImportArray.length) {
                SourceImport sourceImport = sourceImportArray[n9];
                String string5 = sourceImport.getName();
                if (string5.endsWith("*")) {
                    String string6 = string5.substring(0, string5.lastIndexOf(46));
                    RichBuffer.addAllImportedClasses(javaProvider, string6, hashSet3);
                } else {
                    JavaClass javaClass = javaProvider.getClass(string5);
                    if (javaClass != null) {
                        hashSet3.add(javaClass.getName());
                    }
                }
                ++n9;
            }
            String[] stringArray3 = hashSet.toArray(new String[hashSet.size()]);
            int n10 = 0;
            while (n10 < stringArray3.length) {
                String string7 = stringArray3[n10];
                JavaClass javaClass = javaProvider.getClass(string7);
                if (javaClass != null && hashSet3.contains(javaClass.getName())) {
                    hashSet.remove(string7);
                    hashSet2.add(string7);
                }
                ++n10;
            }
        }
        return n;
    }

    private static void addAllImportedClasses(JavaProvider javaProvider, String string, HashSet hashSet) {
        Collection collection = javaProvider.getPackage(string).getDeclaredClasses();
        for (JavaClass javaClass : collection) {
            hashSet.add(javaClass.getName());
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        return _flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return FLAVOR.equals(dataFlavor) || dataFlavor.equals(DataFlavor.stringFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (FLAVOR.equals(dataFlavor)) {
            return this;
        }
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            return this._text;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public static class TextSegment {
        int start;
        int end;

        public TextSegment(int n, int n2) {
            this.start = n;
            this.end = n2;
        }
    }

    public static class ClassUseEntry
    implements Comparable {
        String fqName;
        ArrayList usedPos;

        public ClassUseEntry(String string, int n, int n2) {
            this.fqName = string;
            this.usedPos = new ArrayList(2);
            this.addPos(n, n2);
        }

        public ClassUseEntry(String string) {
            this.fqName = string;
            this.usedPos = new ArrayList(2);
        }

        void addPos(int n, int n2) {
            this.usedPos.add(new TextSegment(n, n2));
        }

        public int compareTo(Object object) {
            ClassUseEntry classUseEntry = (ClassUseEntry)object;
            return this.fqName.compareTo(classUseEntry.fqName);
        }
    }

    public static final class 2
    extends Visitor {
        private final /* synthetic */ int v$from;
        private final /* synthetic */ int v$to;

        private void checkEl(SourceElement sourceElement) {
            if (this.v$from <= sourceElement.getStartOffset() && sourceElement.getEndOffset() <= this.v$to) {
                this.setUserData(sourceElement);
                this.cancel();
            }
        }

        protected void whenEnterClass(SourceClass sourceClass) {
            this.skipChildren();
        }

        protected void whenEnterImportDeclaration(SourceImport sourceImport) {
            this.checkEl((SourceElement)sourceImport);
        }

        protected void whenEnterPackageDeclaration(SourcePackage sourcePackage) {
            this.checkEl((SourceElement)sourcePackage);
        }

        public 2(int n, int n2) {
            this.v$to = n2;
            this.v$from = n;
        }
    }

    public static final class 1
    extends Visitor {
        private final /* synthetic */ int v$from;
        private final /* synthetic */ int v$to;
        private final /* synthetic */ HashMap v$foundClasses;
        private final /* synthetic */ HashSet v$foundDeclarations;

        private void addSourceType(SourceTypeReference sourceTypeReference) {
            JavaType javaType;
            SourceName sourceName = sourceTypeReference.getNameElement();
            if (sourceName != null && this.v$from <= sourceName.getStartOffset() && sourceName.getEndOffset() <= this.v$to && (javaType = sourceTypeReference.getResolvedType()) != null) {
                String string = javaType.getRawName();
                ClassUseEntry classUseEntry = (ClassUseEntry)this.v$foundClasses.get(string);
                if (classUseEntry != null) {
                    classUseEntry.addPos(sourceName.getStartOffset() - this.v$from, sourceName.getEndOffset() - this.v$from);
                    return;
                }
                String string2 = javaType.getPackageName();
                if (string.indexOf(46) == -1 || !string.equals(sourceTypeReference.getText()) || string2.equals("")) {
                    this.addJavaType(javaType, (SourceElement)sourceName);
                }
            }
        }

        private void addJavaType(JavaType javaType, SourceElement sourceElement) {
            String string;
            while (javaType != null && javaType.isArray()) {
                javaType = javaType.getComponentType();
            }
            if (javaType != null && !javaType.isPrimitive() && !(string = javaType.getPackageName()).equals("java.lang")) {
                String string2;
                JavaClass javaClass = javaType.getOwningClass();
                if (javaClass != null) {
                    JavaClass javaClass2 = javaClass.getOwningClass();
                    while (javaClass2 != null) {
                        javaClass = javaClass2;
                        javaClass2 = javaClass.getOwningClass();
                    }
                    string2 = javaClass.getRawName();
                } else {
                    JavaClass javaClass3;
                    string2 = javaType.getRawName();
                    ClassUseEntry classUseEntry = (ClassUseEntry)this.v$foundClasses.get(string2);
                    if (classUseEntry != null) {
                        if (sourceElement != null) {
                            classUseEntry.addPos(sourceElement.getStartOffset() - this.v$from, sourceElement.getEndOffset() - this.v$from);
                        }
                        return;
                    }
                    JavaClass javaClass4 = javaType.getTypeErasure();
                    if (javaClass4 instanceof SourceClass && !(javaClass3 = ((SourceClass)javaClass4).getOwningSourceFile().getPrimaryClass()).equals((Object)javaClass4)) {
                        return;
                    }
                }
                if (sourceElement != null) {
                    this.v$foundClasses.put(string2, new ClassUseEntry(string2, sourceElement.getStartOffset() - this.v$from, sourceElement.getEndOffset() - this.v$from));
                } else {
                    this.v$foundClasses.put(string2, new ClassUseEntry(string2));
                }
            }
        }

        protected void whenEnterDotExpression(SourceDotExpression sourceDotExpression) {
            if (this.v$from <= sourceDotExpression.getStartOffset() && sourceDotExpression.getEndOffset() <= this.v$to) {
                String string = sourceDotExpression.getText();
                JavaHasType javaHasType = sourceDotExpression.getResolvedObject();
                if (javaHasType != null) {
                    if (javaHasType.getElementKind() != 3) {
                        return;
                    }
                    JavaType javaType = sourceDotExpression.getResolvedType();
                    if (javaType != null && javaType.getElementKind() == 3 && !javaType.getQualifiedName().equals(string)) {
                        this.addJavaType(javaType, null);
                    }
                }
            }
        }

        protected void whenEnterName(SourceName sourceName) {
            SourceElement sourceElement;
            if (this.v$from <= sourceName.getStartOffset() && sourceName.getEndOffset() <= this.v$to && (sourceElement = sourceName.getParent()) != null && sourceElement.getSymbolKind() == 3) {
                SourceClass sourceClass = (SourceClass)sourceElement;
                String string = sourceClass.getQualifiedName();
                ClassUseEntry classUseEntry = (ClassUseEntry)this.v$foundClasses.get(string);
                if (classUseEntry != null) {
                    classUseEntry.addPos(sourceName.getStartOffset() - this.v$from, sourceName.getEndOffset() - this.v$from);
                } else {
                    this.v$foundClasses.put(string, new ClassUseEntry(string, sourceName.getStartOffset() - this.v$from, sourceName.getEndOffset() - this.v$from));
                }
            }
        }

        protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
            if (this.v$from <= sourceSimpleNameExpression.getStartOffset() && sourceSimpleNameExpression.getEndOffset() <= this.v$to) {
                String string = sourceSimpleNameExpression.getText();
                JavaHasType javaHasType = sourceSimpleNameExpression.getResolvedObject();
                if (javaHasType != null) {
                    if (javaHasType.getElementKind() != 3) {
                        return;
                    }
                    JavaType javaType = sourceSimpleNameExpression.getResolvedType();
                    if (javaType != null && javaType.getElementKind() == 3) {
                        String string2 = javaType.getQualifiedName();
                        if (string2.equals(string)) {
                            return;
                        }
                        ClassUseEntry classUseEntry = (ClassUseEntry)this.v$foundClasses.get(string2);
                        if (classUseEntry != null) {
                            classUseEntry.addPos(sourceSimpleNameExpression.getStartOffset() - this.v$from, sourceSimpleNameExpression.getEndOffset() - this.v$from);
                            return;
                        }
                        this.addJavaType(javaType, (SourceElement)sourceSimpleNameExpression);
                    }
                }
            }
        }

        protected void whenEnterClass(SourceClass sourceClass) {
            SourceClassBody sourceClassBody;
            int n;
            if (this.v$from <= sourceClass.getStartOffset() && (n = (sourceClassBody = sourceClass.getSourceBody()) != null ? sourceClassBody.getStartOffset() : sourceClass.getEndOffset()) <= this.v$to) {
                this.v$foundDeclarations.add(sourceClass.getQualifiedName());
            }
        }

        protected void whenEnterTypeRef(SourceTypeReference sourceTypeReference) {
            this.addSourceType(sourceTypeReference);
        }

        public 1(int n, int n2, HashMap hashMap, HashSet hashSet) {
            this.v$foundDeclarations = hashSet;
            this.v$foundClasses = hashMap;
            this.v$to = n2;
            this.v$from = n;
        }
    }

    public static class ReplaceItem
    implements Comparable {
        String text;
        int start;
        int end;

        public ReplaceItem(String string, int n, int n2) {
            this.text = string;
            this.start = n;
            this.end = n2;
        }

        public int compareTo(Object object) {
            ReplaceItem replaceItem = (ReplaceItem)object;
            return this.start - replaceItem.start;
        }
    }
}

