/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.util;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;

public class SourceElementComparator {
    private ArrayList _duplicates;

    void $init$() {
        this._duplicates = new ArrayList(0);
    }

    public SourceExpression[] getDuplicates() {
        return this._duplicates.toArray(new SourceExpression[this._duplicates.size()]);
    }

    public void findDuplicates(SourceExpression sourceExpression, SourceElement sourceElement) {
        if (this.equals((SourceElement)sourceExpression, sourceElement)) {
            this._duplicates.add(sourceElement);
        } else {
            List list = sourceElement.getChildren();
            int n = 0;
            while (n < list.size()) {
                SourceElement sourceElement2 = (SourceElement)list.get(n);
                this.findDuplicates(sourceExpression, sourceElement2);
                ++n;
            }
        }
    }

    private boolean equals(SourceElement sourceElement, SourceElement sourceElement2) {
        if (sourceElement != sourceElement2) {
            int n;
            int n2 = sourceElement.getSymbolKind();
            if (n2 == (n = sourceElement2.getSymbolKind())) {
                switch (n2) {
                    case 56: {
                        return false;
                    }
                    case 48: 
                    case 50: 
                    case 52: 
                    case 54: 
                    case 55: 
                    case 57: 
                    case 59: 
                    case 60: 
                    case 62: {
                        break;
                    }
                    case 49: 
                    case 51: 
                    case 61: {
                        SourceExpression sourceExpression = (SourceExpression)sourceElement;
                        SourceExpression sourceExpression2 = (SourceExpression)sourceElement2;
                        int n3 = sourceExpression.getOperatorCode();
                        int n4 = sourceExpression2.getOperatorCode();
                        if (n3 != n4) {
                            return false;
                        }
                        switch (n3) {
                            case 1: 
                            case 20: 
                            case 35: {
                                return this.comparePermutationsOfChildren(sourceExpression, sourceExpression2);
                            }
                        }
                        break;
                    }
                    case 53: {
                        SourceLiteralExpression sourceLiteralExpression = (SourceLiteralExpression)sourceElement;
                        SourceLiteralExpression sourceLiteralExpression2 = (SourceLiteralExpression)sourceElement2;
                        String string = sourceLiteralExpression.getText();
                        String string2 = sourceLiteralExpression2.getText();
                        return string.equals(string2);
                    }
                    case 21: {
                        SourceName sourceName = (SourceName)sourceElement;
                        SourceName sourceName2 = (SourceName)sourceElement2;
                        String string = sourceName.getText();
                        String string3 = sourceName2.getText();
                        return string.equals(string3);
                    }
                    case 58: {
                        SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceElement;
                        SourceSimpleNameExpression sourceSimpleNameExpression2 = (SourceSimpleNameExpression)sourceElement2;
                        String string = sourceSimpleNameExpression.getName();
                        String string4 = sourceSimpleNameExpression2.getName();
                        if (!string.equals(string4)) {
                            return false;
                        }
                        JavaHasType javaHasType = sourceSimpleNameExpression.getResolvedObject();
                        if (javaHasType == null) {
                            return false;
                        }
                        JavaHasType javaHasType2 = sourceSimpleNameExpression2.getResolvedObject();
                        return javaHasType.equals(javaHasType2);
                    }
                    case 28: {
                        SourceTypeReference sourceTypeReference = (SourceTypeReference)sourceElement;
                        SourceTypeReference sourceTypeReference2 = (SourceTypeReference)sourceElement2;
                        JavaType javaType = sourceTypeReference.getResolvedType();
                        if (javaType == null) {
                            return false;
                        }
                        JavaType javaType2 = sourceTypeReference2.getResolvedType();
                        return javaType.equals((Object)javaType2);
                    }
                    default: {
                        System.out.println("Unknown symbol " + n2 + " from " + sourceElement.getStartOffset() + " to " + sourceElement.getEndOffset());
                    }
                }
                if (this.areChildrenEqual(sourceElement, sourceElement2)) {
                    return true;
                }
            }
        } else {
            this._duplicates.add(sourceElement);
        }
        return false;
    }

    private boolean comparePermutationsOfChildren(SourceExpression sourceExpression, SourceExpression sourceExpression2) {
        int n;
        List list = sourceExpression.getChildren();
        List list2 = sourceExpression2.getChildren();
        int n2 = list.size();
        if (n2 == (n = list2.size())) {
            SourceElement[] sourceElementArray = list.toArray(new SourceElement[n2]);
            SourceElement[] sourceElementArray2 = list2.toArray(new SourceElement[n]);
            return this.comparePermutationsOfChildren(sourceElementArray, sourceElementArray2, 0);
        }
        return false;
    }

    private boolean comparePermutationsOfChildren(SourceElement[] sourceElementArray, SourceElement[] sourceElementArray2, int n) {
        if (n < sourceElementArray.length) {
            SourceElement sourceElement = sourceElementArray[n];
            int n2 = n;
            while (n2 < sourceElementArray2.length) {
                SourceElement sourceElement2 = sourceElementArray2[n2];
                if (this.equals(sourceElement, sourceElement2)) {
                    SourceElementComparator.swap(sourceElementArray2, n2, n);
                    if (this.comparePermutationsOfChildren(sourceElementArray, sourceElementArray2, n + 1)) {
                        return true;
                    }
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    private static void swap(SourceElement[] sourceElementArray, int n, int n2) {
        SourceElement sourceElement = sourceElementArray[n];
        sourceElementArray[n] = sourceElementArray[n2];
        sourceElementArray[n2] = sourceElement;
    }

    private boolean areChildrenEqual(SourceElement sourceElement, SourceElement sourceElement2) {
        int n;
        List list = sourceElement.getChildren();
        List list2 = sourceElement2.getChildren();
        int n2 = list.size();
        if (n2 == (n = list2.size())) {
            int n3 = 0;
            while (n3 < n2) {
                SourceElement sourceElement3;
                SourceElement sourceElement4 = (SourceElement)list.get(n3);
                if (!this.equals(sourceElement4, sourceElement3 = (SourceElement)list2.get(n3))) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    public SourceElementComparator() {
        this.$init$();
    }
}

