/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.util;

import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.ide.ceditor.CodeEditor;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.statement.SourceCompoundStatement;

public class SourceFormatUtilities {
    public static String reIndent(BasicEditorPane basicEditorPane, String string, String string2, String string3) {
        int n = string2.length();
        int n2 = (Integer)basicEditorPane.getProperty("tab-size");
        boolean bl = (Boolean)basicEditorPane.getProperty("use-tabs");
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("\n") || string4.equals("\r")) {
                stringBuffer.append(string4);
                continue;
            }
            string4 = SourceFormatUtilities.tabToSpace(string4, n2);
            String string5 = string3;
            string5 = string4.startsWith(string2) ? string5 + string4.substring(n) : string5 + string4.trim();
            if (bl) {
                string5 = SourceFormatUtilities.spaceToTab(string5, n2);
            }
            stringBuffer.append(string5);
        }
        return stringBuffer.toString();
    }

    public static String tabToSpace(String string, int n) {
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n3 = 0;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            if (c != '\t') {
                stringBuffer.append(c);
                ++n2;
            } else {
                do {
                    stringBuffer.append(' ');
                } while (++n2 % n != 0);
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String spaceToTab(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        String string2 = "                     ".substring(0, n);
        while (string.startsWith(string2)) {
            stringBuffer.append('\t');
            string = string.substring(n);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String getIndentation(CodeEditor codeEditor, int n) {
        int n2 = codeEditor.getLineStartOffset(codeEditor.getLineFromOffset(n));
        String string = "";
        try {
            string = codeEditor.getText(n2, n - n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string.trim().length() != 0) {
            string = "";
        }
        return string;
    }

    public static String getIndentation(BasicEditorPane basicEditorPane, int n) {
        int n2 = basicEditorPane.getLineStartOffset(basicEditorPane.getLineFromOffset(n));
        String string = "";
        try {
            string = basicEditorPane.getText(n2, n - n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string.trim().length() != 0) {
            string = "";
        }
        return string;
    }

    public static SourceElement findPreviousElement(SourceElement sourceElement, int n) {
        SourceElement sourceElement2 = null;
        int n2 = sourceElement.getStartOffset();
        if (n < n2) {
            return sourceElement2;
        }
        sourceElement2 = sourceElement;
        if (n > sourceElement.getEndOffset()) {
            return sourceElement2;
        }
        Iterator iterator = sourceElement.getChildren(196608).iterator();
        while (iterator.hasNext()) {
            SourceElement sourceElement3 = SourceFormatUtilities.findPreviousElement((SourceElement)iterator.next(), n);
            if (sourceElement3 == null) {
                return sourceElement2;
            }
            sourceElement2 = sourceElement3;
        }
        return sourceElement2;
    }

    public static String getIdentFromOffset(BasicEditorPane basicEditorPane, int n) {
        int n2 = basicEditorPane.getLineStartOffset(basicEditorPane.getLineFromOffset(n));
        String string = "";
        try {
            string = basicEditorPane.getText(n2, n - n2);
            int n3 = 0;
            while (n3 < string.length() && (string.charAt(n3) == ' ' || string.charAt(n3) == '\t')) {
                ++n3;
            }
            string = string.substring(0, n3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    static String getIdentFromPreviousElement(BasicEditorPane basicEditorPane, SourceElement sourceElement, int n) {
        if (sourceElement == null) {
            return "";
        }
        int n2 = sourceElement.getSymbolKind();
        int n3 = (Integer)basicEditorPane.getProperty("indent-size");
        String string = "                     ".substring(0, n3);
        switch (n2) {
            case 13: 
            case 70: {
                return SourceFormatUtilities.getIdentFromOffset(basicEditorPane, sourceElement.getStartOffset());
            }
            case 64: {
                return SourceFormatUtilities.getIdentFromOffset(basicEditorPane, sourceElement.getStartOffset()) + " ";
            }
            case 2: 
            case 4: 
            case 30: {
                if (sourceElement.getEndOffset() <= n) break;
                return SourceFormatUtilities.getIdentFromOffset(basicEditorPane, sourceElement.getEndOffset()) + string;
            }
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 46: {
                SourceCompoundStatement sourceCompoundStatement = (SourceCompoundStatement)sourceElement;
                if (sourceCompoundStatement.getPrimaryClause() != null && n >= sourceCompoundStatement.getPrimaryClause().getStartOffset()) break;
                return SourceFormatUtilities.getIdentFromOffset(basicEditorPane, sourceElement.getStartOffset()) + string;
            }
        }
        return SourceFormatUtilities.getIdentFromPreviousElement(basicEditorPane, sourceElement.getParent(), n);
    }

    public static String getSmartIndentation(SourceFile sourceFile, BasicEditorPane basicEditorPane, int n) {
        int n2 = basicEditorPane.getLineStartOffset(basicEditorPane.getLineFromOffset(n));
        String string = "";
        try {
            string = basicEditorPane.getText(n2, n - n2);
            if (string == "" || string.trim().length() == 0) {
                SourceElement sourceElement = SourceFormatUtilities.findPreviousElement((SourceElement)sourceFile, n);
                string = SourceFormatUtilities.getIdentFromPreviousElement(basicEditorPane, sourceElement, n);
            } else {
                string = "";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }
}

