/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLChooserInit;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.runner.RunMgrArb;

public class DefaultRunnablePanel
extends JPanel {
    private final URLTextField targetTextField;
    private final JCheckBox runActiveFileCheckBox;
    private Context context;
    private URL urlSourcePath;
    private JEWTDialog dlg;

    public DefaultRunnablePanel() {
        this(true, RunMgrArb.getString(28));
    }

    public DefaultRunnablePanel(boolean bl, String string) {
        JLabel jLabel = new JLabel();
        this.targetTextField = new URLTextField(null, false, true);
        JButton jButton = new JButton();
        this.runActiveFileCheckBox = new JCheckBox();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.targetTextField, (String)string);
        ResourceUtils.resButton((AbstractButton)jButton, (String)RunMgrArb.getString(29));
        this.targetTextField.setDialogTitle(RunMgrArb.getString(26));
        this.targetTextField.setChooserInit((URLChooserInit)new 2());
        jButton.addActionListener((ActionListener)this.targetTextField);
        ResourceUtils.resButton((AbstractButton)this.runActiveFileCheckBox, (String)RunMgrArb.getString(30));
        this.targetTextField.getDocument().addDocumentListener(new 1());
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.add((Component)this.targetTextField, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jButton, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        if (bl) {
            this.add((Component)this.runActiveFileCheckBox, new GridBagConstraints(0, n, 0, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 0), 0, 0));
        }
    }

    Component getInitialFocus() {
        return this.targetTextField;
    }

    public boolean validateDefaultRunTarget(JRunProcess jRunProcess) {
        URL uRL;
        if (jRunProcess != null && (uRL = this.targetTextField.getURL()) != null) {
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.show();
            boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            Node node = DefaultRunnablePanel.getNode(uRL);
            if (node != null) {
                String string = jRunProcess.canGetStarterForTarget(node, null, arrayList);
                if (string == null) {
                    bl = true;
                }
            } else {
                arrayList.add(RunMgrArb.format(55, URLFileSystem.getFileName((URL)uRL)));
                bl = true;
            }
            waitCursor.hide();
            if (bl) {
                String string;
                if (node != null) {
                    string = node.getShortLabel();
                } else if (URLFileSystem.isDirectoryPath((URL)uRL)) {
                    string = URLFileSystem.getPlatformPathName((URL)uRL);
                } else {
                    String string2 = URLFileSystem.getFileName((URL)uRL);
                    String string3 = URLFileSystem.getPlatformPathName((URL)uRL);
                    string = RunMgrArb.format(85, string2, string3);
                }
                arrayList.add(0, RunMgrArb.format(32, string));
                arrayList.add(1, "");
                arrayList.add("");
                arrayList.add(RunMgrArb.format(33, string));
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < arrayList.size()) {
                    stringBuffer.append(arrayList.get(n));
                    if (n < arrayList.size() - 1) {
                        stringBuffer.append("\n");
                    }
                    ++n;
                }
                return MessageDialog.optionalConfirm((String)"jdeveloper.runner.defaultRunnableMessage", (Component)this, (String)stringBuffer.toString(), (String)RunMgrArb.getString(31), null);
            }
        }
        return true;
    }

    private void enableOk() {
        if (this.dlg != null) {
            this.dlg.setOKButtonEnabled(this.canOk());
        }
    }

    public void setJEWTDialog(JEWTDialog jEWTDialog) {
        this.dlg = jEWTDialog;
    }

    public boolean canOk() {
        return this.targetTextField.getURL() != null;
    }

    public void loadFrom(RunConfiguration runConfiguration, Object object) {
        this.targetTextField.setURL(runConfiguration.getTargetURL());
        this.runActiveFileCheckBox.setSelected(runConfiguration.isRunActiveFile());
        this.context = null;
        this.urlSourcePath = null;
        if (object instanceof Project) {
            Project project = (Project)object;
            this.context = Context.newIdeContext((Node)project);
            this.context.setWorkspace(Ide.getActiveWorkspace());
            this.urlSourcePath = PathsConfiguration.getInstance(project).getProjectSourcePath().getFirstEntry();
        }
    }

    public void commitTo(RunConfiguration runConfiguration) {
        runConfiguration.setTargetURL(this.targetTextField.getURL());
        runConfiguration.setRunActiveFile(this.runActiveFileCheckBox.isSelected());
    }

    static Node getNode(URL uRL) {
        try {
            Node node = NodeFactory.find((URL)uRL);
            if (node == null && URLFileSystem.exists((URL)uRL)) {
                node = NodeFactory.findOrCreate((URL)uRL);
            }
            Node node2 = node;
            return node2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static Context ra$context(DefaultRunnablePanel defaultRunnablePanel) {
        return defaultRunnablePanel.context;
    }

    static URL ra$urlSourcePath(DefaultRunnablePanel defaultRunnablePanel) {
        return defaultRunnablePanel.urlSourcePath;
    }

    static URLTextField ra$targetTextField(DefaultRunnablePanel defaultRunnablePanel) {
        return defaultRunnablePanel.targetTextField;
    }

    static void mav$enableOk(DefaultRunnablePanel defaultRunnablePanel) {
        defaultRunnablePanel.enableOk();
    }

    public final class 2
    implements URLChooserInit {
        public void initURLChooser(URLChooser uRLChooser) {
            if (DefaultRunnablePanel.ra$context(DefaultRunnablePanel.this) != null) {
                DialogUtil.addShortcutButtons((URLChooser)uRLChooser, (Context)DefaultRunnablePanel.ra$context(DefaultRunnablePanel.this));
            }
            if (DefaultRunnablePanel.ra$urlSourcePath(DefaultRunnablePanel.this) != null && DefaultRunnablePanel.ra$targetTextField(DefaultRunnablePanel.this).getURL() == null) {
                uRLChooser.setSelectedURL(DefaultRunnablePanel.ra$urlSourcePath(DefaultRunnablePanel.this));
            }
        }
    }

    public final class 1
    implements DocumentListener {
        public void changedUpdate(DocumentEvent documentEvent) {
            DefaultRunnablePanel.mav$enableOk(DefaultRunnablePanel.this);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            DefaultRunnablePanel.mav$enableOk(DefaultRunnablePanel.this);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            DefaultRunnablePanel.mav$enableOk(DefaultRunnablePanel.this);
        }
    }
}

