/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurationEditorUtil;
import oracle.jdevimpl.runner.DefaultRunnablePanel;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.run.RunningProcess;

public class RunConfigurationLaunchPanel
extends DefaultTraversablePanel {
    private DefaultRunnablePanel defaultRunnablePanel;
    private final JComboBox vmComboBox;
    private final JTextField javaOptionsTextField;
    private final JTextField programArgsTextField;
    private final URLTextField runDirTextField;
    private final JButton runDirButton;
    private final JCheckBox remoteDebuggingProfilingCheckBox;

    void $init$() {
        this.defaultRunnablePanel = new DefaultRunnablePanel();
    }

    RunConfigurationLaunchPanel() {
        this.$init$();
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_run_projset_runnerpanel_html");
        JLabel jLabel = new JLabel();
        this.vmComboBox = new JComboBox();
        JLabel jLabel2 = new JLabel();
        this.javaOptionsTextField = new JTextField();
        JLabel jLabel3 = new JLabel();
        this.programArgsTextField = new JTextField();
        JLabel jLabel4 = new JLabel();
        this.runDirTextField = new URLTextField(null, true, false);
        this.runDirButton = new JButton();
        this.remoteDebuggingProfilingCheckBox = new JCheckBox();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.vmComboBox, (String)RunMgrArb.getString(34));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.javaOptionsTextField, (String)RunMgrArb.getString(35));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.programArgsTextField, (String)RunMgrArb.getString(36));
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this.runDirTextField, (String)RunMgrArb.getString(37));
        ResourceUtils.resButton((AbstractButton)this.runDirButton, (String)RunMgrArb.getString(38));
        this.runDirTextField.setDialogTitle(RunMgrArb.getString(39));
        this.runDirButton.addActionListener((ActionListener)this.runDirTextField);
        ResourceUtils.resButton((AbstractButton)this.remoteDebuggingProfilingCheckBox, (String)RunMgrArb.getString(40));
        JPanel jPanel = this.makeVMPanel(jLabel, jLabel2);
        JPanel jPanel2 = this.makeProgramArgsPanel(jLabel3);
        JPanel jPanel3 = this.makeRunDirPanel(jLabel4);
        int n = 0;
        this.setLayout(new GridBagLayout());
        this.add(this.defaultRunnablePanel, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(jPanel, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add(jPanel2, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
        this.add(jPanel3, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add(this.remoteDebuggingProfilingCheckBox, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, n, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel makeVMPanel(JLabel jLabel, JLabel jLabel2) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 20), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(1, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        jPanel.add((Component)this.vmComboBox, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 20), 0, 0));
        jPanel.add((Component)this.javaOptionsTextField, new GridBagConstraints(1, n, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel makeProgramArgsPanel(JLabel jLabel) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        jPanel.add((Component)this.programArgsTextField, new GridBagConstraints(0, n, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel makeRunDirPanel(JLabel jLabel) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        jPanel.add((Component)this.runDirTextField, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.runDirButton, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        return jPanel;
    }

    public void onEntry(TraversableContext traversableContext) {
        RunConfiguration runConfiguration = RunConfigurationEditorUtil.getRunConfiguration((Namespace)traversableContext);
        this.loadFrom(runConfiguration);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        RunConfiguration runConfiguration = RunConfigurationEditorUtil.getRunConfiguration((Namespace)traversableContext);
        this.commitTo(runConfiguration);
    }

    private void loadFrom(RunConfiguration runConfiguration) {
        Project project = Ide.getActiveProject();
        JDK jDK = JProjectLibraries.getInstance((PropertyStorage)project).getJDK();
        this.setupVMComboBox(runConfiguration, jDK);
        this.defaultRunnablePanel.loadFrom(runConfiguration, project);
        this.javaOptionsTextField.setText(runConfiguration.getJavaOptions());
        this.programArgsTextField.setText(runConfiguration.getProgramArguments());
        URL uRL = runConfiguration.getRunDirectoryURL();
        this.runDirTextField.setURL(uRL);
        this.remoteDebuggingProfilingCheckBox.setSelected(runConfiguration.isRemoteDebuggingProfiling());
    }

    private void commitTo(RunConfiguration runConfiguration) throws TraversalException {
        String string = (String)this.vmComboBox.getSelectedItem();
        if (string == null) {
            throw new TraversalException(RunMgrArb.getString(41));
        }
        runConfiguration.setVMName(string);
        Project project = Ide.getActiveProject();
        Context context = Context.newIdeContext((Node)project);
        context.setWorkspace(Ide.getActiveWorkspace());
        context.setProject(project);
        RunningProcess runningProcess = new RunningProcess(context);
        if (!this.defaultRunnablePanel.validateDefaultRunTarget(runningProcess)) {
            throw new TraversalException(null);
        }
        this.defaultRunnablePanel.commitTo(runConfiguration);
        runConfiguration.setJavaOptions(this.javaOptionsTextField.getText());
        runConfiguration.setProgramArguments(this.programArgsTextField.getText());
        URL uRL = this.runDirTextField.getURL();
        if (uRL == null) {
            runConfiguration.setRunDirectoryURL(uRL);
        } else if (uRL.getProtocol().equals("file")) {
            runConfiguration.setRunDirectoryURL(URLFileSystem.canonicalize((URL)uRL));
        }
        runConfiguration.setRemoteDebuggingProfiling(this.remoteDebuggingProfilingCheckBox.isSelected());
    }

    private void setupVMComboBox(RunConfiguration runConfiguration, JDK jDK) {
        Object[] objectArray = jDK.getInstalledVMs();
        if (objectArray == null || objectArray.length == 0) {
            objectArray = new String[]{""};
        }
        this.vmComboBox.setModel(new NonNullableComboBoxModel(objectArray));
        String string = runConfiguration.getVMName(jDK);
        if (string == null) {
            string = "";
        }
        this.vmComboBox.setSelectedItem(string);
    }

    public static boolean showTargetDialog(Project project) {
        return RunConfigurationLaunchPanel.showTargetDialog(project, null);
    }

    public static boolean showTargetDialog(Project project, JRunProcess jRunProcess) {
        RunConfiguration runConfiguration = RunConfiguration.getInstance((PropertyStorage)project);
        JLabel jLabel = new JLabel();
        jLabel.setText(RunMgrArb.getString(27));
        DefaultRunnablePanel defaultRunnablePanel = new DefaultRunnablePanel();
        JPanel jPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(5);
        jPanel.setLayout(borderLayout);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)defaultRunnablePanel, "Center");
        String string = RunMgrArb.getString(26);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, (Component)defaultRunnablePanel.getInitialFocus(), (String)string);
        jEWTDialog.setResizable(true);
        defaultRunnablePanel.setJEWTDialog(jEWTDialog);
        defaultRunnablePanel.loadFrom(runConfiguration, project);
        jEWTDialog.setOKButtonEnabled(defaultRunnablePanel.canOk());
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_run_runtargetdialog_html");
        if (jRunProcess != null) {
            jEWTDialog.addVetoableChangeListener((VetoableChangeListener)new 1(defaultRunnablePanel, jRunProcess));
        }
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            defaultRunnablePanel.commitTo(runConfiguration);
            project.markDirty(true);
            return true;
        }
        return false;
    }

    public static final class 1
    implements VetoableChangeListener {
        private final /* synthetic */ DefaultRunnablePanel v$defaultRunnablePanel;
        private final /* synthetic */ JRunProcess v$jrunProcess;

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent) && !this.v$defaultRunnablePanel.validateDefaultRunTarget(this.v$jrunProcess)) {
                throw new PropertyVetoException("no", propertyChangeEvent);
            }
        }

        public 1(DefaultRunnablePanel defaultRunnablePanel, JRunProcess jRunProcess) {
            this.v$jrunProcess = jRunProcess;
            this.v$defaultRunnablePanel = defaultRunnablePanel;
        }
    }
}

