/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurationEditorUtil;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.ojc.compiler.Options;

class RunConfigurationToolPanel
extends DefaultTraversablePanel
implements ItemListener {
    private JCheckBox compileBeforeRunCheckBox;
    private JCheckBox ignoreCompilerErrorsCheckBox;
    private JCheckBox clearLogBeforeRunCheckBox;
    private JCheckBox logCommandCheckBox;
    private JCheckBox logOutputCheckBox;
    private JCheckBox logErrorCheckBox;
    private JCheckBox logExitCheckBox;
    private JCheckBox useProxyCheckBox;
    private JCheckBox allowInputCheckBox;
    private static Boolean showIgnoreCompilerErrorsCheckBox = null;

    RunConfigurationToolPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_run_projset_runneroptionspanel_html");
        JLabel jLabel = new JLabel(RunMgrArb.getString(43));
        this.compileBeforeRunCheckBox = new JCheckBox();
        this.ignoreCompilerErrorsCheckBox = new JCheckBox();
        this.clearLogBeforeRunCheckBox = new JCheckBox();
        JLabel jLabel2 = new JLabel(RunMgrArb.getString(47));
        this.logCommandCheckBox = new JCheckBox();
        this.logOutputCheckBox = new JCheckBox();
        this.logErrorCheckBox = new JCheckBox();
        this.logExitCheckBox = new JCheckBox();
        JLabel jLabel3 = new JLabel(RunMgrArb.getString(52));
        this.useProxyCheckBox = new JCheckBox();
        this.allowInputCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.compileBeforeRunCheckBox, (String)RunMgrArb.getString(44));
        ResourceUtils.resButton((AbstractButton)this.ignoreCompilerErrorsCheckBox, (String)RunMgrArb.getString(45));
        ResourceUtils.resButton((AbstractButton)this.clearLogBeforeRunCheckBox, (String)RunMgrArb.getString(46));
        ResourceUtils.resButton((AbstractButton)this.logCommandCheckBox, (String)RunMgrArb.getString(48));
        ResourceUtils.resButton((AbstractButton)this.logOutputCheckBox, (String)RunMgrArb.getString(49));
        ResourceUtils.resButton((AbstractButton)this.logErrorCheckBox, (String)RunMgrArb.getString(50));
        ResourceUtils.resButton((AbstractButton)this.logExitCheckBox, (String)RunMgrArb.getString(51));
        ResourceUtils.resButton((AbstractButton)this.useProxyCheckBox, (String)RunMgrArb.getString(53));
        ResourceUtils.resButton((AbstractButton)this.allowInputCheckBox, (String)RunMgrArb.getString(54));
        if (RunConfigurationToolPanel.showIgnoreCompilerErrorsCheckBox()) {
            this.ignoreCompilerErrorsCheckBox.setEnabled(this.compileBeforeRunCheckBox.isSelected());
            this.compileBeforeRunCheckBox.addItemListener(this);
        }
        this.setLayout(new GridBagLayout());
        int n = 0;
        Insets insets = new Insets(0, 0, 5, 0);
        Insets insets2 = new Insets(10, 0, 5, 0);
        Insets insets3 = new Insets(0, 8, 2, 0);
        Insets insets4 = new Insets(0, 25, 2, 0);
        this.add(jLabel, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, insets, 1, 0));
        this.add(this.compileBeforeRunCheckBox, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, insets3, 1, 0));
        if (RunConfigurationToolPanel.showIgnoreCompilerErrorsCheckBox()) {
            this.add(this.ignoreCompilerErrorsCheckBox, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, insets4, 1, 0));
        }
        this.add(this.clearLogBeforeRunCheckBox, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, insets3, 1, 0));
        this.add(jLabel2, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, insets2, 1, 0));
        this.add(this.logCommandCheckBox, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, insets3, 1, 0));
        this.add(this.logOutputCheckBox, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, insets3, 1, 0));
        this.add(this.logErrorCheckBox, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, insets3, 1, 0));
        this.add(this.logExitCheckBox, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, insets3, 1, 0));
        this.add(jLabel3, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, insets2, 1, 0));
        this.add(this.useProxyCheckBox, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, insets3, 1, 0));
        this.add(this.allowInputCheckBox, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, insets3, 1, 0));
        this.add(new JLabel(), new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private static synchronized boolean showIgnoreCompilerErrorsCheckBox() {
        if (showIgnoreCompilerErrorsCheckBox == null) {
            try {
                Class<Options> clazz = Options.class;
                if (clazz != null && clazz.getDeclaredField("generateClassesDespiteErrors") != null) {
                    showIgnoreCompilerErrorsCheckBox = Boolean.TRUE;
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            showIgnoreCompilerErrorsCheckBox = Boolean.FALSE;
        }
        return showIgnoreCompilerErrorsCheckBox;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.compileBeforeRunCheckBox) {
            this.ignoreCompilerErrorsCheckBox.setEnabled(this.compileBeforeRunCheckBox.isSelected());
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        RunConfiguration runConfiguration = RunConfigurationEditorUtil.getRunConfiguration((Namespace)traversableContext);
        this.loadFrom(runConfiguration);
    }

    public void onExit(TraversableContext traversableContext) {
        RunConfiguration runConfiguration = RunConfigurationEditorUtil.getRunConfiguration((Namespace)traversableContext);
        this.commitTo(runConfiguration);
    }

    private void loadFrom(RunConfiguration runConfiguration) {
        this.compileBeforeRunCheckBox.setSelected(runConfiguration.isCompileBeforeRun());
        if (RunConfigurationToolPanel.showIgnoreCompilerErrorsCheckBox()) {
            this.ignoreCompilerErrorsCheckBox.setSelected(runConfiguration.isIgnoreCompilerErrors());
        }
        this.clearLogBeforeRunCheckBox.setSelected(runConfiguration.isClearLogBeforeRun());
        this.logCommandCheckBox.setSelected(runConfiguration.isLogCommand());
        this.logOutputCheckBox.setSelected(runConfiguration.isLogOutput());
        this.logErrorCheckBox.setSelected(runConfiguration.isLogError());
        this.logExitCheckBox.setSelected(runConfiguration.isLogExit());
        this.useProxyCheckBox.setSelected(runConfiguration.isUseProxy());
        this.allowInputCheckBox.setSelected(runConfiguration.isAllowInput());
    }

    private void commitTo(RunConfiguration runConfiguration) {
        runConfiguration.setCompileBeforeRun(this.compileBeforeRunCheckBox.isSelected());
        if (RunConfigurationToolPanel.showIgnoreCompilerErrorsCheckBox()) {
            runConfiguration.setIgnoreCompilerErrors(this.ignoreCompilerErrorsCheckBox.isSelected());
        }
        runConfiguration.setClearLogBeforeRun(this.clearLogBeforeRunCheckBox.isSelected());
        runConfiguration.setLogCommand(this.logCommandCheckBox.isSelected());
        runConfiguration.setLogOutput(this.logOutputCheckBox.isSelected());
        runConfiguration.setLogError(this.logErrorCheckBox.isSelected());
        runConfiguration.setLogExit(this.logExitCheckBox.isSelected());
        runConfiguration.setUseProxy(this.useProxyCheckBox.isSelected());
        runConfiguration.setAllowInput(this.allowInputCheckBox.isSelected());
    }
}

