/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdevimpl.runner.RunConfigurationEditor;
import oracle.jdevimpl.runner.RunMgrArb;

public class RunConfigurationsPanel
extends ProjectSettingsTraversablePanel
implements ActionListener {
    private DefaultListModel profilesModel;
    private List profilesNames;
    private JList profilesList;
    private JButton editButton;
    private JButton newButton;
    private JButton deleteButton;
    private JButton restoreButton;
    private Project project;
    private boolean editingCustomProperties;
    private Map definedRunConfigurations;
    private static final String[] PROPERTY_KEYS = new String[]{"runConfigurationDefinitions", "runConfigurationList"};

    public RunConfigurationsPanel() {
        JLabel jLabel = new JLabel();
        this.profilesModel = new DefaultListModel();
        this.profilesNames = new ArrayList();
        this.profilesList = new JList(this.profilesModel);
        this.profilesList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.profilesList);
        this.editButton = new JButton();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.restoreButton = new JButton();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.profilesList, (String)RunMgrArb.getString(7));
        ResourceUtils.resButton((AbstractButton)this.editButton, (String)RunMgrArb.getString(8));
        ResourceUtils.resButton((AbstractButton)this.newButton, (String)RunMgrArb.getString(10));
        ResourceUtils.resButton((AbstractButton)this.deleteButton, (String)RunMgrArb.getString(11));
        ResourceUtils.resButton((AbstractButton)this.restoreButton, (String)RunMgrArb.getString(12));
        this.profilesList.addListSelectionListener(new 2());
        this.profilesList.addMouseListener(new 1());
        this.editButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.restoreButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.add(jLabel, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.add(jScrollPane, new GridBagConstraints(0, 1, 1, 0, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.editButton, new GridBagConstraints(1, 1, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.newButton, new GridBagConstraints(1, 2, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.deleteButton, new GridBagConstraints(1, 3, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.restoreButton, new GridBagConstraints(1, 4, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
    }

    public String getDataKey() {
        return RunConfigurations.DATA_KEY;
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void onProjectPanelEntry(TraversableContext traversableContext) {
        if (RunConfigurationsPanel.isDefaultProject((Namespace)traversableContext)) {
            this.setHelpID("f1_run_ppdefault_rundebug_html");
        } else if (RunConfigurationsPanel.editingUserProperties((Namespace)traversableContext)) {
            this.setHelpID("f1_run_ppcustom_rundebug_html");
        } else {
            this.setHelpID("f1_run_pp_rundebug_html");
        }
        RunConfigurations runConfigurations = RunConfigurationsPanel.getRunConfigurations(traversableContext);
        this.project = ProjectSettingsTraversablePanel.getProject((Namespace)traversableContext);
        this.editingCustomProperties = ProjectSettingsTraversablePanel.editingUserProperties((Namespace)traversableContext);
        this.loadFrom(runConfigurations);
    }

    public void onExit(TraversableContext traversableContext) {
        RunConfigurations runConfigurations = RunConfigurationsPanel.getRunConfigurations(traversableContext);
        this.commitTo(runConfigurations);
    }

    private static RunConfigurations getRunConfigurations(TraversableContext traversableContext) {
        return RunConfigurations.getInstance(RunConfigurationsPanel.getPropertyData((Namespace)traversableContext));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.editButton) {
            this.editRunConfiguration();
        } else if (object == this.newButton) {
            this.newRunConfiguration();
        } else if (object == this.deleteButton) {
            this.deleteRunConfiguration();
        } else if (object == this.restoreButton) {
            this.restoreRunConfiguration();
        }
    }

    private void loadFrom(RunConfigurations runConfigurations) {
        this.definedRunConfigurations = runConfigurations.getDefinedRunConfigurations();
        this.profilesModel.clear();
        this.profilesNames.clear();
        RunConfiguration[] runConfigurationArray = runConfigurations.getVisibleRunConfigurations();
        int n = runConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.profilesModel.addElement(runConfigurationArray[n2]);
            this.profilesNames.add(runConfigurationArray[n2].getName());
            ++n2;
        }
        int n3 = -1;
        String string = RunConfigurations.getActiveName(this.project);
        if (string != null) {
            n3 = this.profilesNames.indexOf(string);
        }
        if (n3 == -1) {
            n3 = 0;
        }
        if (n3 < this.profilesNames.size()) {
            this.profilesList.setSelectedIndex(n3);
        }
        this.updateButtons();
    }

    private void commitTo(RunConfigurations runConfigurations) {
        int n = this.profilesModel.size();
        RunConfiguration[] runConfigurationArray = new RunConfiguration[n];
        int n2 = 0;
        while (n2 < n) {
            runConfigurationArray[n2] = (RunConfiguration)((Object)this.profilesModel.get(n2));
            ++n2;
        }
        runConfigurations.setRunConfigurations(runConfigurationArray, this.editingCustomProperties);
    }

    private void updateButtons() {
        RunConfiguration runConfiguration = (RunConfiguration)((Object)this.profilesList.getSelectedValue());
        boolean bl = runConfiguration != null;
        this.editButton.setEnabled(bl);
        if (this.editingCustomProperties && bl && !runConfiguration.isCustom()) {
            ResourceUtils.resButton((AbstractButton)this.editButton, (String)RunMgrArb.getString(9));
        } else {
            ResourceUtils.resButton((AbstractButton)this.editButton, (String)RunMgrArb.getString(8));
        }
        this.deleteButton.setEnabled(bl && this.profilesModel.size() > 1);
        if (this.editingCustomProperties) {
            ResourceUtils.resButton((AbstractButton)this.restoreButton, (String)RunMgrArb.getString(12));
            boolean bl2 = false;
            for (String string : this.definedRunConfigurations.keySet()) {
                RunConfiguration runConfiguration2 = (RunConfiguration)((Object)this.definedRunConfigurations.get(string));
                if (runConfiguration2.isCustom() || this.profilesNames.contains(string)) continue;
                bl2 = true;
                break;
            }
            this.restoreButton.setEnabled(bl2);
        } else {
            ResourceUtils.resButton((AbstractButton)this.restoreButton, (String)RunMgrArb.getString(13));
            if (bl && runConfiguration.getName().equals(RunConfiguration.getDefaultName())) {
                this.restoreButton.setEnabled(true);
            } else {
                this.restoreButton.setEnabled(false);
            }
        }
    }

    private void editRunConfiguration() {
        RunConfiguration runConfiguration = (RunConfiguration)((Object)this.profilesList.getSelectedValue());
        if (runConfiguration != null) {
            this.editRunConfiguration(runConfiguration);
        }
    }

    private void editRunConfiguration(int n) {
        RunConfiguration runConfiguration = (RunConfiguration)((Object)this.profilesModel.get(n));
        this.editRunConfiguration(runConfiguration);
    }

    private void editRunConfiguration(RunConfiguration runConfiguration) {
        boolean bl = !this.editingCustomProperties || runConfiguration.isCustom();
        RunConfigurationEditor runConfigurationEditor = new RunConfigurationEditor(runConfiguration, bl);
        boolean bl2 = runConfigurationEditor.showDialog();
        if (bl && bl2) {
            RunConfigurations.setActiveRunConfiguration(this.project, runConfiguration);
        }
    }

    private void newRunConfiguration() {
        TreeSet<Object> treeSet = new TreeSet<Object>();
        treeSet.addAll(this.definedRunConfigurations.keySet());
        int n = this.profilesNames.size() - 1;
        while (n >= 0) {
            treeSet.add(this.profilesNames.get(n));
            --n;
        }
        RunConfiguration runConfiguration = (RunConfiguration)((Object)this.profilesList.getSelectedValue());
        String string = runConfiguration != null ? runConfiguration.getName() : null;
        NewDialog newDialog = new NewDialog(string, treeSet);
        if ((string = newDialog.showDialog()) != null) {
            RunConfiguration runConfiguration2 = NewDialog.mav$getCopyFrom(newDialog);
            RunConfiguration runConfiguration3 = new RunConfiguration(runConfiguration2, string, this.editingCustomProperties);
            int n2 = this.profilesList.getSelectedIndex() + 1;
            this.profilesModel.add(n2, runConfiguration3);
            this.profilesNames.add(n2, runConfiguration3.getName());
            this.profilesList.setSelectedIndex(n2);
        }
    }

    private void deleteRunConfiguration() {
        int n = this.profilesList.getSelectedIndex();
        if (n != -1) {
            this.profilesModel.remove(n);
            this.profilesNames.remove(n);
            if (n < this.profilesModel.size()) {
                this.profilesList.setSelectedIndex(n);
            } else if (n - 1 >= 0) {
                this.profilesList.setSelectedIndex(n - 1);
            }
            this.updateButtons();
        }
    }

    private void restoreRunConfiguration() {
        if (this.editingCustomProperties) {
            Set set = this.definedRunConfigurations.keySet();
            TreeSet treeSet = new TreeSet();
            treeSet.addAll(set);
            for (String string : set) {
                RunConfiguration runConfiguration = (RunConfiguration)((Object)this.definedRunConfigurations.get(string));
                if (!runConfiguration.isCustom() && !this.profilesNames.contains(string)) continue;
                treeSet.remove(string);
            }
            RestoreDialog restoreDialog = new RestoreDialog(treeSet);
            String[] stringArray = restoreDialog.showDialog();
            if (stringArray != null) {
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RunConfiguration runConfiguration = (RunConfiguration)((Object)this.definedRunConfigurations.get(stringArray[n2]));
                    this.profilesModel.addElement(runConfiguration);
                    this.profilesNames.add(stringArray[n2]);
                    ++n2;
                }
                this.updateButtons();
            }
        } else {
            RunConfiguration runConfiguration = (RunConfiguration)((Object)this.profilesList.getSelectedValue());
            if (runConfiguration != null) {
                runConfiguration.restoreDefaults();
            }
        }
    }

    static void mav$updateButtons(RunConfigurationsPanel runConfigurationsPanel) {
        runConfigurationsPanel.updateButtons();
    }

    static JList ra$profilesList(RunConfigurationsPanel runConfigurationsPanel) {
        return runConfigurationsPanel.profilesList;
    }

    static void mav$editRunConfiguration(RunConfigurationsPanel runConfigurationsPanel, int n) {
        runConfigurationsPanel.editRunConfiguration(n);
    }

    static DefaultListModel ra$profilesModel(RunConfigurationsPanel runConfigurationsPanel) {
        return runConfigurationsPanel.profilesModel;
    }

    static List ra$profilesNames(RunConfigurationsPanel runConfigurationsPanel) {
        return runConfigurationsPanel.profilesNames;
    }

    public final class 2
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            RunConfigurationsPanel.mav$updateButtons(RunConfigurationsPanel.this);
        }
    }

    public final class 1
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) != 0 && mouseEvent.getClickCount() == 2) {
                Rectangle rectangle;
                Point point = mouseEvent.getPoint();
                int n = RunConfigurationsPanel.ra$profilesList(RunConfigurationsPanel.this).locationToIndex(point);
                if (n != -1 && (rectangle = RunConfigurationsPanel.ra$profilesList(RunConfigurationsPanel.this).getCellBounds(n, n)).contains(point)) {
                    RunConfigurationsPanel.mav$editRunConfiguration(RunConfigurationsPanel.this, n);
                }
            }
        }
    }

    public class NewDialog
    extends JPanel
    implements DocumentListener {
        private JTextField nameTextField;
        private JComboBox copyFromComboBox;
        private JEWTDialog dlg;
        private Set usedNames;

        NewDialog(String string, Set set) {
            super(new GridBagLayout());
            this.usedNames = set;
            JLabel jLabel = new JLabel();
            String string2 = string != null ? RunMgrArb.format(15, string) : "";
            this.nameTextField = new JTextField(string2);
            JLabel jLabel2 = new JLabel();
            int n = RunConfigurationsPanel.ra$profilesNames(RunConfigurationsPanel.this).size() + 1;
            Object[] objectArray = new Object[n];
            objectArray[0] = RunMgrArb.getString(18);
            int n2 = 1;
            while (n2 < n) {
                objectArray[n2] = RunConfigurationsPanel.ra$profilesNames(RunConfigurationsPanel.this).get(n2 - 1);
                ++n2;
            }
            this.copyFromComboBox = new JComboBox(new NonNullableComboBoxModel(objectArray));
            this.copyFromComboBox.setSelectedItem(string);
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this.nameTextField, (String)RunMgrArb.getString(16));
            ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.copyFromComboBox, (String)RunMgrArb.getString(17));
            this.nameTextField.getDocument().addDocumentListener(this);
            int n3 = 0;
            this.add((Component)jLabel, new GridBagConstraints(0, n3++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.nameTextField, new GridBagConstraints(0, n3++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)jLabel2, new GridBagConstraints(0, n3++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
            this.add((Component)this.copyFromComboBox, new GridBagConstraints(0, n3++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)new JLabel(), new GridBagConstraints(0, n3, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        String showDialog() {
            String string = RunMgrArb.getString(14);
            JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)this.nameTextField, (String)string);
            this.setJEWTDialog(jEWTDialog);
            jEWTDialog.setOKButtonEnabled(this.canOk());
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_run_copyrunconfig_html");
            if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
                return this.getNewName();
            }
            return null;
        }

        private void setJEWTDialog(JEWTDialog jEWTDialog) {
            this.dlg = jEWTDialog;
            jEWTDialog.addVetoableChangeListener((VetoableChangeListener)new 1());
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.processChange();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.processChange();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.processChange();
        }

        private void processChange() {
            this.dlg.setOKButtonEnabled(this.canOk());
        }

        private boolean canOk() {
            return this.nameTextField.getText().length() > 0;
        }

        private boolean veto() {
            String string = this.nameTextField.getText();
            if (this.usedNames.contains(string)) {
                MessageDialog.error((Component)this, (Object)RunMgrArb.format(20, string), (String)RunMgrArb.format(19, this.dlg.getTitle()), null);
                return true;
            }
            return false;
        }

        private String getNewName() {
            return this.nameTextField.getText();
        }

        private RunConfiguration getCopyFrom() {
            int n = this.copyFromComboBox.getSelectedIndex();
            if (n <= 0) {
                return null;
            }
            return (RunConfiguration)((Object)RunConfigurationsPanel.ra$profilesModel(RunConfigurationsPanel.this).get(n - 1));
        }

        static RunConfiguration mav$getCopyFrom(NewDialog newDialog) {
            return newDialog.getCopyFrom();
        }

        static boolean mav$veto(NewDialog newDialog) {
            return newDialog.veto();
        }

        public final class 1
        implements VetoableChangeListener {
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent) && NewDialog.mav$veto(NewDialog.this)) {
                    throw new PropertyVetoException("no", propertyChangeEvent);
                }
            }
        }
    }

    public class RestoreDialog
    extends JPanel
    implements ListSelectionListener {
        private JList list;
        private JEWTDialog dlg;

        RestoreDialog(Set set) {
            super(new GridBagLayout());
            JLabel jLabel = new JLabel();
            DefaultListModel defaultListModel = new DefaultListModel();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                defaultListModel.addElement(iterator.next());
            }
            this.list = new JList(defaultListModel);
            this.list.setSelectionMode(2);
            JScrollPane jScrollPane = new JScrollPane(this.list);
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this.list, (String)RunMgrArb.getString(22));
            this.list.addListSelectionListener(this);
            int n = 0;
            this.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)jScrollPane, new GridBagConstraints(0, n, 0, 1, 1.0, 1.0, 17, 1, new Insets(2, 5, 0, 5), 0, 0));
        }

        String[] showDialog() {
            String string = RunMgrArb.getString(21);
            JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)this.list, (String)string);
            this.setJEWTDialog(jEWTDialog);
            jEWTDialog.setOKButtonEnabled(this.canOk());
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_run_restorerunconfig_html");
            if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
                return this.getItems();
            }
            return null;
        }

        private void setJEWTDialog(JEWTDialog jEWTDialog) {
            this.dlg = jEWTDialog;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.dlg.setOKButtonEnabled(this.canOk());
        }

        private boolean canOk() {
            return this.list.getSelectedIndex() != -1;
        }

        private String[] getItems() {
            Object[] objectArray = this.list.getSelectedValues();
            int n = objectArray.length;
            String[] stringArray = new String[n];
            System.arraycopy(objectArray, 0, stringArray, 0, n);
            return stringArray;
        }
    }
}

