/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.awt.Component;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.ide.menu.ItemFactory;
import javax.ide.view.GUIPanel;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ActionMenuToolButton;
import oracle.ide.model.Project;
import oracle.ide.view.View;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.run.JRunner;

public class RunItemFactory
extends ItemFactory {
    private Map mapPathToAction = new HashMap();

    public RunItemFactory() {
        this.mapPathToAction.put("javax.ide.view.MAIN_WINDOW_TOOLBAR_ID/oracle.jdeveloper.TB_RUN_SECTION/RunProjectCommand", JRunner.getInstance().getActionRunProject());
        this.mapPathToAction.put("javax.ide.view.MAIN_WINDOW_TOOLBAR_ID/oracle.jdeveloper.TB_DEBUG_SECTION/DebugProjectCommand", JDebugger.getInstance().getActionDebugProject());
    }

    public GUIPanel createItem(String string) {
        Action action = (Action)this.mapPathToAction.get(string);
        if (action != null) {
            return new GUIPanel((Object)new RunDebugButton(action), null);
        }
        return null;
    }

    private class RunDebugButton
    extends ActionMenuToolButton
    implements PopupMenuListener {
        public RunDebugButton(Action action) {
            super(action);
        }

        protected JPopupMenu createPopupMenu() {
            super.createPopupMenu();
            this._popup.addPopupMenuListener(this);
            return this._popup;
        }

        protected void releasePopupMenu() {
            if (this._popup != null) {
                this._popup.removePopupMenuListener(this);
            }
            super.releasePopupMenu();
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            View view;
            Project project = Ide.getActiveProject();
            if (project != null && !project.isOpen()) {
                try {
                    project.open();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Context context = (view = Ide.getMainWindow().getLastActiveView()) != null ? view.getContext((EventObject)popupMenuEvent) : Context.newIdeContext();
            int n = this._popup.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Action action;
                Component component = this._popup.getComponent(n2);
                if (component instanceof JMenuItem && (action = ((JMenuItem)component).getAction()) instanceof IdeAction) {
                    IdeAction ideAction = (IdeAction)action;
                    ideAction.updateAction(context);
                }
                ++n2;
            }
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }
    }
}

