/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.ProjectMigrator;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.Navigable;
import oracle.ide.runner.Runner;
import oracle.ide.runner.StarterFactory;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ideri.util.Product;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.cmd.NewEmptyProjectCommand;
import oracle.jdeveloper.model.JavaNode;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdevimpl.jar.JarNode;
import oracle.jdevimpl.runner.AddinStarterFactory;
import oracle.jdevimpl.runner.ApplicationStarterFactory;
import oracle.jdevimpl.runner.JarStarterFactory;
import oracle.jdevimpl.runner.RunConfigurationsMigrator;
import oracle.jdevimpl.runner.RunConfigurationsPanel;
import oracle.jdevimpl.runner.RunMgrArb;

public final class RunManager
implements Observer,
IdeListener,
Controller,
Addin {
    private Project activeProject;
    private static JMenu menuRunConfigurationList;
    private static final String ACTIVATE_RUN_CONFIGURATION_CMD_PREFIX = "ActivateRunConfiguration";
    private static IdeAction actionEmpty;
    private static int[] activateRunConfigurationCmdIds;
    private static final int MANAGE_RUN_CONFIGURATIONS_CMD_ID;
    private static IdeAction actionManageRunConfigurations;

    static {
        activateRunConfigurationCmdIds = new int[0];
        MANAGE_RUN_CONFIGURATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"ManageRunConfigurations");
    }

    public void initialize() {
        this.makeActionsAndMenus();
        this.registerProjectInitializerAndMigrator();
        RunManager.registerDefaultStarterFactories();
        RunManager.registerProjectSettingsPanels();
        Project.addProjectChangeListener((String)"", (ProjectChangeListener)new 3());
        Ide.addIdeListener((IdeListener)this);
    }

    public void shutdown() {
    }

    public boolean canShutdown() {
        return true;
    }

    public void addinsLoaded(IdeEvent ideEvent) {
    }

    public void mainWindowOpened(IdeEvent ideEvent) {
        Ide.removeIdeListener((IdeListener)this);
        this.activeProjectChanged();
        Ide.getSystem().attach((Observer)this);
        Project.addProjectChangeListener((String)"", (ProjectChangeListener)new 2());
    }

    public void mainWindowClosing(IdeEvent ideEvent) {
        Ide.getSystem().detach((Observer)this);
    }

    public void update(Object object, UpdateMessage updateMessage) {
        int n = updateMessage.getMessageID();
        if (object == Ide.getSystem()) {
            if (n == IdeConstants.ACTIVE_PROJECT_CHANGED) {
                this.activeProjectChanged();
            }
        } else if (object instanceof Project) {
            if (n == UpdateMessage.CHILD_REMOVED) {
                RunManager.projectFilesRemoved((Project)object, updateMessage.getRemoveObjects());
            } else if (n == UpdateMessage.CHILD_RENAMED) {
                RunManager.projectFileRenamed((Project)object, updateMessage);
            }
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (RunManager.arrayContains(activateRunConfigurationCmdIds, n)) {
            RunConfiguration runConfiguration = (RunConfiguration)((Object)ideAction.getValue("UserData"));
            RunConfigurations.setActiveRunConfiguration(this.activeProject, runConfiguration);
            return true;
        }
        if (n == MANAGE_RUN_CONFIGURATIONS_CMD_ID) {
            this.manageRunConfigurations(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (RunManager.arrayContains(activateRunConfigurationCmdIds, n)) {
            RunConfiguration runConfiguration = (RunConfiguration)((Object)ideAction.getValue("UserData"));
            boolean bl = RunConfigurations.isActiveRunConfiguration(this.activeProject, runConfiguration);
            ideAction.setState(bl);
            return true;
        }
        if (n == MANAGE_RUN_CONFIGURATIONS_CMD_ID) {
            ideAction.setEnabled(this.canManageRunConfigurations(context));
            return true;
        }
        return false;
    }

    private void makeActionsAndMenus() {
        JMenu jMenu = Runner.getRunner().getRunMenu();
        String string = jMenu.getText();
        Menubar menubar = Ide.getMenubar();
        int n = Ide.findOrCreateCmdID((String)"ActivateRunConfigurationEmpty");
        actionEmpty = IdeAction.get((int)n, null, (String)RunMgrArb.getString(2), (String)string, null, null, null, (boolean)false);
        menuRunConfigurationList = menubar.createSubMenu(RunMgrArb.getString(0), RunMgrArb.getInteger(1), 1.0f);
        if (!Product.isRaptor()) {
            menubar.add((Component)menuRunConfigurationList, jMenu, 1.0f);
        }
        actionManageRunConfigurations = IdeAction.get((int)MANAGE_RUN_CONFIGURATIONS_CMD_ID, null, (String)RunMgrArb.getString(3), (String)string, (Integer)RunMgrArb.getInteger(4), (ArrayResourceBundle)RunMgrArb.getInstance(), (int)5, null, (boolean)false);
        actionManageRunConfigurations.addController((Controller)this);
    }

    private void registerProjectInitializerAndMigrator() {
        NewEmptyProjectCommand.registerProjectInitializer(new 1());
        NodeMigrator nodeMigrator = NodeMigrator.getNodeMigrator((String)ProjectMigrator.MIGRATOR_NAME);
        if (nodeMigrator != null) {
            nodeMigrator.addHelper((NodeMigratorHelper)new RunConfigurationsMigrator());
        }
    }

    private static void registerDefaultStarterFactories() {
        Runner runner = Runner.getRunner();
        runner.registerStarterFactory(TextNode.class, (StarterFactory)new AddinStarterFactory(true));
        JarStarterFactory jarStarterFactory = new JarStarterFactory();
        runner.registerStarterFactory(JarNode.class, (StarterFactory)jarStarterFactory);
        ApplicationStarterFactory applicationStarterFactory = new ApplicationStarterFactory();
        runner.registerStarterFactory(JavaNode.class, (StarterFactory)applicationStarterFactory);
    }

    private static void registerProjectSettingsPanels() {
        Navigable navigable = new Navigable(RunMgrArb.getString(6), RunConfigurationsPanel.class);
        ProjectPropertiesDialog.addPanel((Navigable)navigable);
        Runner.getRunner().setProjectSettingsRunnerNavigable(navigable);
    }

    private void activeProjectChanged() {
        if (this.activeProject != null) {
            this.activeProject.detach((Observer)this);
        }
        this.activeProject = Ide.getActiveProject();
        if (this.activeProject != null) {
            this.activeProject.attach((Observer)this);
        }
        this.updateRunConfigurationList();
    }

    private static void projectFilesRemoved(Project project, List list) {
        try {
            RunConfiguration runConfiguration = RunConfiguration.getInstance((PropertyStorage)project);
            URL uRL = runConfiguration.getTargetURL();
            if (uRL != null) {
                for (Object e : list) {
                    if (!(e instanceof Locatable) || !((Locatable)e).getURL().equals(uRL)) continue;
                    runConfiguration.setTargetURL(null);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void projectFileRenamed(Project project, UpdateMessage updateMessage) {
        try {
            Node node;
            URL uRL;
            RunConfiguration runConfiguration = RunConfiguration.getInstance((PropertyStorage)project);
            URL uRL2 = runConfiguration.getTargetURL();
            if (uRL2 != null && (uRL = RenameMessage.getOldURL((UpdateMessage)updateMessage)) != null && URLFileSystem.equals((URL)uRL, (URL)uRL2) && (node = RenameMessage.getRenamedNode((UpdateMessage)updateMessage)) != null) {
                runConfiguration.setTargetURL(node.getURL());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateRunConfigurationList() {
        RunConfigurations runConfigurations;
        RunConfiguration[] runConfigurationArray;
        int n;
        IdeAction[] ideActionArray = null;
        if (this.activeProject != null && this.activeProject.isOpen() && (n = (runConfigurationArray = (runConfigurations = RunConfigurations.getInstance((PropertyStorage)this.activeProject)).getVisibleRunConfigurations()).length) > 0) {
            activateRunConfigurationCmdIds = new int[n];
            ideActionArray = new IdeAction[n];
            String string = Runner.getRunner().getRunMenu().getText();
            int n2 = 0;
            while (n2 < n) {
                RunConfiguration runConfiguration = runConfigurationArray[n2];
                String string2 = runConfiguration.getName();
                int n3 = Ide.findOrCreateCmdID((String)(ACTIVATE_RUN_CONFIGURATION_CMD_PREFIX + n2));
                IdeAction ideAction = IdeAction.get((int)n3, null, (String)string2, (String)string, null, null, (Object)((Object)runConfiguration), (boolean)true);
                ideAction.putValue("Name", (Object)string2);
                ideAction.putValue("UserData", (Object)runConfiguration);
                ideAction.putValue("Radio", (Object)Boolean.TRUE);
                ideAction.addController((Controller)this);
                RunManager.activateRunConfigurationCmdIds[n2] = n3;
                ideActionArray[n2] = ideAction;
                ++n2;
            }
        }
        if (ideActionArray == null) {
            activateRunConfigurationCmdIds = new int[0];
            ideActionArray = new IdeAction[]{actionEmpty};
        }
        Menubar menubar = Ide.getMenubar();
        menuRunConfigurationList.removeAll();
        int n4 = ideActionArray.length;
        int n5 = 0;
        while (n5 < n4) {
            menubar.add((Component)menubar.createMenuItem((ToggleAction)ideActionArray[n5]), menuRunConfigurationList, 1.0f);
            ++n5;
        }
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionManageRunConfigurations), menuRunConfigurationList, JDeveloperMenuConstants.SECTION_BOTTOM);
    }

    public static IdeAction getManageRunConfigurationsAction() {
        actionManageRunConfigurations.updateAction(Ide.getMainWindow().getLastActiveView().getContext());
        return actionManageRunConfigurations;
    }

    public static boolean arrayContains(int[] nArray, int n) {
        int n2 = nArray.length - 1;
        while (n2 >= 0) {
            if (nArray[n2] == n) {
                return true;
            }
            --n2;
        }
        return false;
    }

    private boolean canManageRunConfigurations(Context context) {
        Project project = context.getProject();
        return project != null;
    }

    private void manageRunConfigurations(Context context) {
        Project project = context.getProject();
        if (project != null) {
            String[] stringArray = new String[]{RunMgrArb.getString(6)};
            ProjectPropertiesDialog.showDialog((Frame)Ide.getMainWindow(), (Project)project, (String[])stringArray);
        }
    }

    static Project ra$activeProject(RunManager runManager) {
        return runManager.activeProject;
    }

    static void mav$updateRunConfigurationList(RunManager runManager) {
        runManager.updateRunConfigurationList();
    }

    public final class 3
    extends ProjectChangeListener {
        public void projectOpened(Project project) {
            RunConfigurations.projectCheck(project);
        }
    }

    public final class 2
    extends ProjectChangeListener {
        public void projectPropertiesChanged(ProjectChangeEvent projectChangeEvent) {
            if (projectChangeEvent.getProject() == RunManager.ra$activeProject(RunManager.this)) {
                1 var2_2 = new 1();
                if (SwingUtilities.isEventDispatchThread()) {
                    var2_2.run();
                } else {
                    SwingUtilities.invokeLater(var2_2);
                }
            }
        }

        public final class 1
        implements Runnable {
            public void run() {
                RunManager.mav$updateRunConfigurationList(RunManager.this);
            }
        }
    }

    public final class 1
    implements NewEmptyProjectCommand.ProjectInitializer {
        public void initializeProject(Project project, Workspace workspace) {
            RunConfigurations.projectCreated(project);
        }
    }
}

