/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.codecoach;

import java.net.URL;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.LineNavigationPoint;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.java.TransactionDescriptor;
import oracle.jdevimpl.runner.codecoach.CCAdviceGroup;
import oracle.jdevimpl.runner.codecoach.CCArb;

class CCAdvice {
    private static final int WRONG_OPTION_ID = 14;
    private static final int[] advicesIndex = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 53, 52, 54};
    private static HashMap advicesKeyMap;
    static BitSet allAdvices;
    static BitSet warnBitSet;
    static BitSet nullBitSet;
    int adviceID;
    OffsetMark omark;
    int line;
    String[] elems;
    String fullText;
    String fullFileName = null;
    CCAdviceGroup agroup;
    BitSet sgn;
    private static final HelpInfo HELP_TOPIC_CDA;
    private static final HelpInfo HELP_TOPIC_CND;
    private static final HelpInfo HELP_TOPIC_DCO;
    private static final HelpInfo HELP_TOPIC_FDA;
    private static final HelpInfo HELP_TOPIC_FSF;
    private static final HelpInfo HELP_TOPIC_FUN;
    private static final HelpInfo HELP_TOPIC_INC;
    private static final HelpInfo HELP_TOPIC_INI;
    private static final HelpInfo HELP_TOPIC_MDA;
    private static final HelpInfo HELP_TOPIC_NIC;
    private static final HelpInfo HELP_TOPIC_VSF;
    private static final HelpInfo HELP_TOPIC_VUN;

    static {
        nullBitSet = new BitSet();
        allAdvices = new BitSet();
        allAdvices.set(0);
        warnBitSet = new BitSet();
        warnBitSet.set(0);
        advicesKeyMap = new HashMap(10);
        CCAdvice.addtoKeyMap("CFIN", 1);
        CCAdvice.addtoKeyMap("CSTA", 2);
        CCAdvice.addtoKeyMap("MFIN", 3);
        CCAdvice.addtoKeyMap("MPRI", 4);
        CCAdvice.addtoKeyMap("MSTA", 5);
        CCAdvice.addtoKeyMap("FFIN", 6);
        CCAdvice.addtoKeyMap("FLOC", 7);
        CCAdvice.addtoKeyMap("FPRI", 8);
        CCAdvice.addtoKeyMap("FSTA", 9);
        CCAdvice.addtoKeyMap("FUNU", 10);
        CCAdvice.addtoKeyMap("LFIN", 11);
        CCAdvice.addtoKeyMap("LUNU", 12);
        CCAdvice.addtoKeyMap("NHTB", 13);
        CCAdvice.addtoKeyMap("NVCT", 14);
        CCAdvice.addtoKeyMap("NBST", 15);
        CCAdvice.addtoKeyMap("NHMP", 16);
        CCAdvice.addtoKeyMap("NWHT", 17);
        CCAdvice.addtoKeyMap("NALS", 18);
        CCAdvice.addtoKeyMap("NSBU", 19);
        CCAdvice.addtoKeyMap("CDEA", 20);
        CCAdvice.addtoKeyMap("ACST", 21);
        CCAdvice.addtoKeyMap("INST", 22);
        HELP_TOPIC_CDA = new HelpInfo(CCArb.getString(2));
        HELP_TOPIC_CND = new HelpInfo(CCArb.getString(3));
        HELP_TOPIC_DCO = new HelpInfo(CCArb.getString(4));
        HELP_TOPIC_FDA = new HelpInfo(CCArb.getString(5));
        HELP_TOPIC_FSF = new HelpInfo(CCArb.getString(6));
        HELP_TOPIC_FUN = new HelpInfo(CCArb.getString(7));
        HELP_TOPIC_INC = new HelpInfo(CCArb.getString(8));
        HELP_TOPIC_INI = new HelpInfo(CCArb.getString(9));
        HELP_TOPIC_MDA = new HelpInfo(CCArb.getString(10));
        HELP_TOPIC_NIC = new HelpInfo(CCArb.getString(11));
        HELP_TOPIC_VSF = new HelpInfo(CCArb.getString(12));
        HELP_TOPIC_VUN = new HelpInfo(CCArb.getString(13));
    }

    private static void addtoKeyMap(String string, int n) {
        BitSet bitSet = new BitSet();
        bitSet.set(n);
        allAdvices.set(n);
        advicesKeyMap.put(string, bitSet);
    }

    CCAdvice(String string) {
        String string2;
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        String[] stringArray = new String[15];
        while (n3 < string.length()) {
            switch (string.charAt(n3)) {
                case ';': {
                    if (!bl) {
                        stringArray[n5] = string.substring(n2, n4 + 1);
                        n4 = n2 = n3 + 1;
                        ++n5;
                        break;
                    }
                    n4 = n3;
                    break;
                }
                default: {
                    n4 = n3;
                    break;
                }
                case '\"': {
                    if (!bl) {
                        bl = true;
                        n4 = n2 = n3 + 1;
                        break;
                    }
                    bl = false;
                    n4 = n3 - 1;
                }
            }
            ++n3;
        }
        this.adviceID = Integer.parseInt(stringArray[0]);
        int n6 = Integer.parseInt(stringArray[1]);
        this.elems = new String[n6];
        System.arraycopy(stringArray, 2, this.elems, 0, n6);
        this.fullText = null;
        if (advicesIndex[this.adviceID] == 53 && (n = (string2 = this.getClassName()).lastIndexOf(36)) != -1 && (n = (string2 = string2.substring(0, n)).lastIndexOf(36)) != -1 && Character.isDigit((string2 = string2.substring(n + 1)).charAt(0))) {
            this.elems[2] = "0";
        }
        if (this.adviceID == 14) {
            this.sgn = warnBitSet;
        } else {
            this.sgn = new BitSet();
            StringTokenizer stringTokenizer = new StringTokenizer(this.elems[3], " ,");
            while (stringTokenizer.hasMoreElements()) {
                BitSet bitSet = (BitSet)advicesKeyMap.get(stringTokenizer.nextToken());
                this.sgn.or(bitSet);
            }
        }
    }

    void setOffsetMark(OffsetMark offsetMark) {
        this.omark = offsetMark;
    }

    OffsetMark getOffsetMark() {
        return this.omark;
    }

    void setLine(int n) {
        if (this.line == n) {
            return;
        }
        this.line = n;
        if (this.adviceID == 14) {
            return;
        }
        this.elems[2] = Integer.toString(n);
        this.fullText = null;
    }

    private void genFullText() {
        this.fullText = CCArb.format(advicesIndex[this.adviceID], this.elems);
    }

    String getFullText() {
        if (this.fullText == null) {
            this.genFullText();
        }
        return this.fullText;
    }

    public String toString() {
        return this.getFullText();
    }

    String getFileName() {
        if (this.adviceID == 14) {
            return "";
        }
        return this.elems[1];
    }

    int getLineNo() {
        if (this.adviceID == 14) {
            return -1;
        }
        return Integer.parseInt(this.elems[2]);
    }

    void showSource() {
        this.agroup.adjustLines();
        this.agroup.showSource(this.getLineNo());
    }

    String getClassName() {
        return this.elems[0];
    }

    void hideIt() {
        this.agroup.res.advMask.andNot(this.sgn);
    }

    boolean shouldShow() {
        BitSet bitSet = (BitSet)this.agroup.res.advMask.clone();
        bitSet.and(this.sgn);
        return bitSet.equals(nullBitSet) ^ true;
    }

    void removeIt() {
        this.sgn = nullBitSet;
    }

    boolean isFixable() {
        switch (advicesIndex[this.adviceID]) {
            case 40: 
            case 41: 
            case 44: 
            case 53: {
                return this.agroup.url != null && this.agroup.isModificationPossible();
            }
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: {
                return false;
            }
        }
        return false;
    }

    HelpInfo getHelpInfo() {
        switch (advicesIndex[this.adviceID]) {
            case 40: {
                return HELP_TOPIC_MDA;
            }
            case 41: {
                return HELP_TOPIC_FDA;
            }
            case 44: {
                return HELP_TOPIC_VSF;
            }
            case 53: {
                return HELP_TOPIC_CDA;
            }
            case 42: {
                return HELP_TOPIC_FUN;
            }
            case 43: {
                return HELP_TOPIC_FSF;
            }
            case 45: {
                return HELP_TOPIC_VUN;
            }
            case 46: 
            case 47: 
            case 48: {
                return HELP_TOPIC_DCO;
            }
            case 49: {
                return HELP_TOPIC_NIC;
            }
            case 50: {
                return HELP_TOPIC_INC;
            }
            case 51: {
                return HELP_TOPIC_INC;
            }
            case 52: {
                return HELP_TOPIC_INI;
            }
            case 54: {
                return HELP_TOPIC_CND;
            }
        }
        return null;
    }

    boolean isFindable() {
        return this.agroup.url != null;
    }

    boolean isIgnorable() {
        switch (advicesIndex[this.adviceID]) {
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return this.agroup.url != null && this.agroup.isModificationPossible();
            }
            case 54: {
                return false;
            }
        }
        return false;
    }

    int getModifiersFromString(String string, int n) {
        if (string.indexOf("final") != -1) {
            n |= 0x10;
        }
        if (string.indexOf("static") != -1) {
            n |= 8;
        }
        if (string.indexOf("private") != -1) {
            n |= 2;
            n &= 0xFFFFFFFA;
        }
        return n;
    }

    String getNameFromMethod(String string) {
        int n = string.indexOf(40);
        int n2 = string.lastIndexOf(32, n);
        return string.substring(n2 + 1, n);
    }

    String getNameFromField(String string) {
        int n = string.lastIndexOf(32);
        String string2 = string.substring(n + 1);
        if ((n = string2.indexOf(91)) != -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    String getTypeFromField(String string) {
        int n = string.indexOf(32);
        String string2 = string.substring(0, n);
        n = string.indexOf(91);
        if (n != -1) {
            string2 = string2 + string.substring(n);
        }
        return string2;
    }

    private SourceExpression cleanAssignments(SourceElement sourceElement, String string, SourceExpression sourceExpression) {
        block3: {
            block2: {
                SourceSimpleNameExpression sourceSimpleNameExpression;
                if (sourceElement.getSymbolKind() != 49) break block2;
                SourceAssignmentExpression sourceAssignmentExpression = (SourceAssignmentExpression)sourceElement;
                SourceExpression sourceExpression2 = sourceAssignmentExpression.getFirstOperand();
                if (sourceExpression2.getSymbolKind() != 58 || (sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceExpression2) == null || !sourceSimpleNameExpression.getName().equals(string)) break block3;
                if (sourceExpression == null) {
                    sourceExpression = sourceAssignmentExpression.getSecondOperand();
                }
                if (sourceAssignmentExpression.getParent().getSymbolKind() != 37) break block3;
                sourceAssignmentExpression.getParent().removeSelf();
                break block3;
            }
            Iterator iterator = sourceElement.getChildren().iterator();
            while (iterator.hasNext()) {
                sourceExpression = this.cleanAssignments((SourceElement)iterator.next(), string, sourceExpression);
            }
        }
        return sourceExpression;
    }

    boolean fixIt() {
        try {
            if (this.isFixable()) {
                switch (advicesIndex[this.adviceID]) {
                    case 40: {
                        this.fixMethodAccess();
                        boolean bl = true;
                        return bl;
                    }
                    case 41: {
                        this.fixFieldAccess();
                        boolean bl = true;
                        return bl;
                    }
                    case 44: {
                        this.fixLocalModifier();
                        boolean bl = true;
                        return bl;
                    }
                    case 53: {
                        this.fixClassAccess();
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Got exc " + exception + " in fix it");
        }
        return false;
    }

    private void fixFieldAccess() {
        SourceFile sourceFile = this.agroup.getJavaFile();
        SourceElement sourceElement = sourceFile.getElementAt(this.omark.getOffset());
        while (sourceElement.getSymbolKind() != 3) {
            sourceElement = sourceElement.getParent();
        }
        SourceTransaction sourceTransaction = null;
        try {
            sourceTransaction = sourceFile.beginTransaction();
            SourceClass sourceClass = (SourceClass)sourceElement;
            String string = this.getNameFromField(this.elems[4]);
            SourceFieldVariable sourceFieldVariable = sourceClass.getSourceFieldVariable(string);
            SourceVariableDeclaration sourceVariableDeclaration = sourceFieldVariable.getOwningDeclaration();
            int n = sourceVariableDeclaration.getModifiers();
            if (sourceVariableDeclaration.getVariables().size() > 1) {
                sourceVariableDeclaration.getVariables().remove(sourceFieldVariable);
                SourceVariableDeclaration sourceVariableDeclaration2 = (SourceVariableDeclaration)sourceVariableDeclaration.cloneSelf(sourceFile);
                sourceVariableDeclaration2.getVariables().clear();
                sourceVariableDeclaration2.getVariables().add(sourceFieldVariable.cloneSelf(sourceFile));
                sourceVariableDeclaration = sourceVariableDeclaration2;
            }
            n = this.getModifiersFromString(this.elems[5], n);
            sourceVariableDeclaration.setModifiers(n);
            this.agroup.getManager().commitTransaction(sourceTransaction, new TransactionDescriptor(CCArb.getString(84)));
        }
        catch (Exception exception) {
            sourceTransaction.abort();
        }
    }

    private void fixLocalModifier() {
        SourceFile sourceFile = this.agroup.getJavaFile();
        SourceElement sourceElement = sourceFile.getElementAt(this.omark.getOffset());
        while (sourceElement.getSymbolKind() != 2) {
            sourceElement = sourceElement.getParent();
        }
        SourceBlock sourceBlock = (SourceBlock)sourceElement;
        Iterator iterator = sourceBlock.getLocalVariables().iterator();
        SourceLocalVariable sourceLocalVariable = null;
        while (iterator.hasNext()) {
            sourceLocalVariable = (SourceLocalVariable)iterator.next();
            if (sourceLocalVariable.getName().equals(this.elems[5])) break;
        }
        SourceVariableDeclaration sourceVariableDeclaration = sourceLocalVariable.getOwningDeclaration();
        int n = sourceVariableDeclaration.getModifiers();
        SourceTransaction sourceTransaction = null;
        try {
            sourceTransaction = sourceFile.beginTransaction();
            if (sourceVariableDeclaration.getVariables().size() > 1) {
                sourceLocalVariable.removeSelf();
                sourceLocalVariable = (SourceLocalVariable)sourceLocalVariable.cloneSelf(sourceFile);
                SourceLocalVariableDeclaration sourceLocalVariableDeclaration = sourceFile.getFactory().createLocalVariableDeclaration(sourceLocalVariable);
                sourceLocalVariableDeclaration.addSelfBefore((SourceElement)sourceVariableDeclaration);
                sourceVariableDeclaration = sourceLocalVariableDeclaration;
            }
            sourceVariableDeclaration.setModifiers(n |= 0x10);
            SourceExpression sourceExpression = this.cleanAssignments((SourceElement)sourceBlock, this.elems[5], null);
            if (sourceLocalVariable.getInitializer() == null) {
                sourceLocalVariable.setInitializer((SourceExpression)sourceExpression.cloneSelf(sourceFile));
            }
            this.agroup.getManager().commitTransaction(sourceTransaction, new TransactionDescriptor(CCArb.getString(84)));
        }
        catch (Exception exception) {
            sourceTransaction.abort();
        }
    }

    private void fixClassAccess() {
        SourceFile sourceFile = this.agroup.getJavaFile();
        SourceElement sourceElement = sourceFile.getElementAt(this.omark.getOffset());
        while (sourceElement.getSymbolKind() != 3) {
            sourceElement = sourceElement.getParent();
        }
        SourceClass sourceClass = (SourceClass)sourceElement;
        int n = sourceClass.getModifiers();
        n = this.getModifiersFromString(this.elems[5], n);
        SourceTransaction sourceTransaction = null;
        try {
            sourceTransaction = sourceFile.beginTransaction();
            sourceClass.setModifiers(n);
            this.agroup.getManager().commitTransaction(sourceTransaction, new TransactionDescriptor(CCArb.getString(84)));
        }
        catch (Exception exception) {
            sourceTransaction.abort();
        }
    }

    private void fixMethodAccess() {
        SourceFile sourceFile = this.agroup.getJavaFile();
        int n = this.omark.getOffset();
        SourceElement sourceElement = null;
        while (sourceElement == null) {
            sourceElement = sourceFile.getElementAt(n);
            if (sourceElement.getSymbolKind() == 19) continue;
            sourceElement = sourceElement.getParent();
        }
        if (sourceElement != null) {
            SourceTransaction sourceTransaction = null;
            try {
                sourceTransaction = sourceFile.beginTransaction();
                SourceMethod sourceMethod = (SourceMethod)sourceElement;
                int n2 = sourceMethod.getModifiers();
                n2 = this.getModifiersFromString(this.elems[5], n2);
                sourceMethod.setModifiers(n2);
                this.agroup.getManager().commitTransaction(sourceTransaction, new TransactionDescriptor(CCArb.getString(84)));
            }
            catch (Exception exception) {
                sourceTransaction.abort();
            }
        }
    }

    boolean ignoreIt() {
        try {
            if (this.isIgnorable()) {
                this.agroup.adjustLines();
                Node node = NodeFactory.findOrCreate((URL)this.agroup.url);
                if (node != null) {
                    Context context = Context.newIdeContext((Node)node);
                    context.setWorkspace(this.agroup.res.workspace);
                    context.setProject(this.agroup.res.project);
                    if (this.line != 0) {
                        NavigationManager navigationManager = NavigationManager.getNavigationManager();
                        LineNavigationPoint lineNavigationPoint = new LineNavigationPoint(context, this.getLineNo(), 0, false);
                        int n = 1;
                        n = navigationManager != null ? navigationManager.navigateTo((NavigationPoint)lineNavigationPoint, true) : lineNavigationPoint.navigate();
                        if (n == 0) {
                            CodeEditor codeEditor = (CodeEditor)lineNavigationPoint.getContext().getView();
                            codeEditor.replaceSelection("//@codecoach:disable nextline\n");
                            boolean bl = true;
                            return bl;
                        }
                    } else {
                        EditorManager.getEditorManager().openEditorInFrame(CodeEditor.class, context);
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Got exc " + exception + " in ignore it");
        }
        return false;
    }
}

