/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.codecoach;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.runner.codecoach.AdviceComparator;
import oracle.jdevimpl.runner.codecoach.CCAdvice;
import oracle.jdevimpl.runner.codecoach.CCResults;

class CCAdviceGroup {
    private static final AdviceComparator advc = new AdviceComparator();
    String key;
    URL url;
    CCResults res;
    ArrayList advList;

    CCAdviceGroup(CCResults cCResults, String string, URL uRL) {
        this.key = string;
        this.url = uRL;
        this.res = cCResults;
        this.advList = new ArrayList();
    }

    public String toString() {
        return this.key;
    }

    void addAdviceToGroup(CCAdvice cCAdvice) {
        this.advList.add(cCAdvice);
        cCAdvice.agroup = this;
    }

    void finalizeAdvices() {
        Object[] objectArray = this.advList.toArray();
        Arrays.sort(objectArray, advc);
        this.advList = new ArrayList(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            this.advList.add(objectArray[n]);
            ++n;
        }
        if (this.url != null) {
            try {
                TextBuffer textBuffer;
                TextNode textNode = (TextNode)NodeFactory.findOrCreate((URL)this.url);
                if (textNode != null && (textBuffer = textNode.acquireTextBuffer()) != null) {
                    LineMap lineMap = textBuffer.getLineMap();
                    n = 0;
                    while (n < objectArray.length) {
                        CCAdvice cCAdvice = (CCAdvice)objectArray[n];
                        int n2 = cCAdvice.getLineNo();
                        int n3 = lineMap.getLineStartOffset(n2);
                        OffsetMark offsetMark = textBuffer.addOffsetMark(n3);
                        cCAdvice.setOffsetMark(offsetMark);
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void adjustLines() {
        if (this.url != null) {
            try {
                TextBuffer textBuffer;
                TextNode textNode = (TextNode)NodeFactory.findOrCreate((URL)this.url);
                if (textNode != null && (textBuffer = textNode.acquireTextBuffer()) != null) {
                    LineMap lineMap = textBuffer.getLineMap();
                    Iterator iterator = this.iterator();
                    while (iterator.hasNext()) {
                        CCAdvice cCAdvice = (CCAdvice)iterator.next();
                        OffsetMark offsetMark = cCAdvice.getOffsetMark();
                        if (offsetMark == null || offsetMark.getOffset() == 0) {
                            if (offsetMark != null) {
                                textBuffer.removeOffsetMark(offsetMark);
                            }
                            int n = cCAdvice.getLineNo();
                            int n2 = lineMap.getLineStartOffset(n);
                            offsetMark = textBuffer.addOffsetMark(n2);
                            cCAdvice.setOffsetMark(offsetMark);
                            continue;
                        }
                        int n = offsetMark.getOffset();
                        int n3 = lineMap.getLineFromOffset(n);
                        cCAdvice.setLine(n3);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    Iterator iterator() {
        return this.advList.iterator();
    }

    void showSource(int n) {
        if (this.url != null) {
            Source.showSourceFile(this.res.workspace, this.res.project, this.url, n, true);
        }
    }

    boolean isEditorOpen() {
        EditorManager editorManager = EditorManager.getEditorManager();
        List list = editorManager.getAllEditors();
        int n = 0;
        while (n < list.size()) {
            Editor editor = (Editor)list.get(n);
            Context context = editor.getContext();
            Node node = context.getNode();
            if (this.url == node.getURL()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean isModificationPossible() {
        SourceFile sourceFile = this.getManager().getSourceFile(this.url);
        return sourceFile != null;
    }

    JavaManager getManager() {
        return this.res.getJavaManager();
    }

    SourceFile getJavaFile() {
        return this.getManager().getSourceFile(this.url);
    }

    protected void finalize() throws Throwable {
        TextBuffer textBuffer;
        TextNode textNode;
        super.finalize();
        if (this.url != null && (textNode = (TextNode)NodeFactory.findOrCreate((URL)this.url)) != null && (textBuffer = textNode.acquireTextBuffer()) != null) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CCAdvice cCAdvice = (CCAdvice)iterator.next();
                textBuffer.removeOffsetMark(cCAdvice.getOffsetMark());
            }
        }
    }
}

