/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.codecoach;

import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.runner.RunConfiguration;

class CCConfiguration
extends HashStructureAdapter {
    private static final String DATA_KEY = CCConfiguration.class.getName();
    private static final String ADVICES = "advices";
    private static final String INCLUDE = "include";
    private static final String EXCLUDE = "exclude";
    private static final String LEVEL = "level";

    private CCConfiguration(HashStructure hashStructure) {
        super(hashStructure);
    }

    static CCConfiguration getInstance(PropertyStorage propertyStorage) {
        if (propertyStorage instanceof RunConfiguration) {
            return new CCConfiguration(CCConfiguration.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
        }
        RunConfiguration runConfiguration = RunConfiguration.getInstance(propertyStorage);
        return CCConfiguration.getInstance(runConfiguration);
    }

    String getAdvices() {
        return this._hash.getString(ADVICES, "ALL");
    }

    void setAdvices(String string) {
        if (string == null) {
            string = "ALL";
        }
        this._hash.putString(ADVICES, string);
    }

    String getInclude() {
        return this._hash.getString(INCLUDE, "");
    }

    void setInclude(String string) {
        if (string == null) {
            string = "";
        }
        this._hash.putString(INCLUDE, string);
    }

    String getExclude() {
        return this._hash.getString(EXCLUDE, "com;java;javax;sun;sunw;org;oracle;COM;antlr");
    }

    void setExclude(String string) {
        if (string == null) {
            string = "";
        }
        this._hash.putString(EXCLUDE, string);
    }

    int getLevel() {
        return this._hash.getInt(LEVEL, 4);
    }

    void setLevel(int n) {
        this._hash.putInt(LEVEL, n);
    }
}

