/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.codecoach;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.dialogs.ClassPackageListBrowser;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurationEditorUtil;
import oracle.jdevimpl.runner.codecoach.CCAdviceTreePanel;
import oracle.jdevimpl.runner.codecoach.CCArb;
import oracle.jdevimpl.runner.codecoach.CCConfiguration;

public class CCConfigurationPanel
extends DefaultTraversablePanel
implements ActionListener {
    JLabel adviceLabel;
    CCAdviceTreePanel advicesTree;
    JLabel includesLabel;
    JLabel levelLabel;
    JSlider levelSlider;
    JTextField includesTextField;
    JButton includesButton;
    JLabel excludesLabel;
    JTextField excludesTextField;
    JButton excludesButton;
    GridBagLayout gridBagLayout1;
    private static final String HELP_ID = "f1_idedclasspkginclexcl_html";

    void $init$() {
        this.adviceLabel = new JLabel();
        this.advicesTree = new CCAdviceTreePanel();
        this.includesLabel = new JLabel();
        this.levelLabel = new JLabel();
        this.levelSlider = new JSlider();
        this.includesTextField = new JTextField();
        this.includesButton = new JButton();
        this.excludesLabel = new JLabel();
        this.excludesTextField = new JTextField();
        this.excludesButton = new JButton();
        this.gridBagLayout1 = new GridBagLayout();
    }

    public CCConfigurationPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        CCConfiguration cCConfiguration = CCConfigurationPanel.getCCConfiguration(traversableContext);
        this.loadFrom(cCConfiguration);
    }

    public void onExit(TraversableContext traversableContext) {
        CCConfiguration cCConfiguration = CCConfigurationPanel.getCCConfiguration(traversableContext);
        this.commitTo(cCConfiguration);
    }

    private static CCConfiguration getCCConfiguration(TraversableContext traversableContext) {
        RunConfiguration runConfiguration = RunConfigurationEditorUtil.getRunConfiguration((Namespace)traversableContext);
        return CCConfiguration.getInstance(runConfiguration);
    }

    private void loadFrom(CCConfiguration cCConfiguration) {
        this.advicesTree.setValue(cCConfiguration.getAdvices());
        this.includesTextField.setText(cCConfiguration.getInclude());
        this.excludesTextField.setText(cCConfiguration.getExclude());
        this.levelSlider.setValue(cCConfiguration.getLevel() + 1);
    }

    private void commitTo(CCConfiguration cCConfiguration) {
        cCConfiguration.setAdvices(this.advicesTree.getValue());
        cCConfiguration.setInclude(this.includesTextField.getText());
        cCConfiguration.setExclude(this.excludesTextField.getText());
        int n = this.levelSlider.getValue() - 1;
        cCConfiguration.setLevel(n);
    }

    private void jbInit() throws Exception {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), CCArb.getString(0));
        ResourceUtils.resLabel((JLabel)this.adviceLabel, (Component)this.advicesTree.getComponent(), (String)CCArb.getString(30));
        ResourceUtils.resLabel((JLabel)this.levelLabel, (Component)this.levelSlider, (String)CCArb.getString(31));
        this.levelSlider.setMinimum(1);
        this.levelSlider.setMaximum(10);
        this.levelSlider.setPaintLabels(true);
        this.levelSlider.setMajorTickSpacing(1);
        this.levelSlider.setSnapToTicks(true);
        ResourceUtils.resLabel((JLabel)this.includesLabel, (Component)this.includesTextField, (String)CCArb.getString(32));
        ResourceUtils.resButton((AbstractButton)this.includesButton, (String)CCArb.getString(33));
        this.includesButton.addActionListener(this);
        ResourceUtils.resLabel((JLabel)this.excludesLabel, (Component)this.excludesTextField, (String)CCArb.getString(35));
        ResourceUtils.resButton((AbstractButton)this.excludesButton, (String)CCArb.getString(36));
        this.excludesButton.addActionListener(this);
        if (Ide.getActiveProject() == null) {
            this.includesButton.setEnabled(false);
            this.excludesButton.setEnabled(false);
        }
        this.setLayout(this.gridBagLayout1);
        int n = 0;
        int n2 = 0;
        this.add(this.adviceLabel, new GridBagConstraints(n, n2++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.advicesTree, new GridBagConstraints(n, n2++, 0, 1, 1.0, 1.0, 17, 1, new Insets(2, 0, 0, 0), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.levelLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.levelSlider, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 8, 0, 0), 0, 0));
        this.add(jPanel, new GridBagConstraints(n, n2++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        n = 0;
        this.add(this.includesLabel, new GridBagConstraints(n, n2++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add(this.includesTextField, new GridBagConstraints(n++, n2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
        this.add(this.includesButton, new GridBagConstraints(n, n2++, 0, 1, 0.0, 0.0, 17, 0, new Insets(2, 8, 0, 0), 0, 0));
        n = 0;
        this.add(this.excludesLabel, new GridBagConstraints(n, n2++, 0, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 0, 0), 0, 0));
        this.add(this.excludesTextField, new GridBagConstraints(n++, n2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
        this.add(this.excludesButton, new GridBagConstraints(n, n2, 0, 1, 0.0, 0.0, 17, 0, new Insets(2, 8, 0, 0), 0, 0));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.includesButton) {
            String string = CCArb.getString(34);
            String string2 = this.includesTextField.getText();
            ArrayList arrayList = new ArrayList();
            IdeUtil.string2List((String)string2, arrayList);
            Project project = Ide.getActiveProject();
            if (ClassPackageListBrowser.browseClassPackageList((Component)((Object)this), string, project, true, true, arrayList, HELP_ID)) {
                string2 = IdeUtil.list2String(arrayList);
                this.includesTextField.setText(string2);
            }
        } else if (object == this.excludesButton) {
            String string = CCArb.getString(37);
            String string3 = this.excludesTextField.getText();
            ArrayList arrayList = new ArrayList();
            IdeUtil.string2List((String)string3, arrayList);
            Project project = Ide.getActiveProject();
            if (ClassPackageListBrowser.browseClassPackageList((Component)((Object)this), string, project, true, true, arrayList, HELP_ID)) {
                string3 = IdeUtil.list2String(arrayList);
                this.excludesTextField.setText(string3);
            }
        }
    }
}

